/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIExpression;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.ptp.ui.views.IToolTipProvider;

public class PVariableManager {
    private Map<String, List<PVariableInfo>> jobVariableMap = new HashMap<String, List<PVariableInfo>>();
    private UpdateVariableJob upVariableJob = new UpdateVariableJob();

    public void shutdown() {
        this.jobVariableMap.clear();
        this.upVariableJob.cancelAll();
    }

    public PVariableInfo[] getPVariableInfo() {
        ArrayList aList = new ArrayList();
        Iterator<List<PVariableInfo>> i = this.jobVariableMap.values().iterator();
        while (i.hasNext()) {
            aList.addAll(i.next());
        }
        return aList.toArray(new PVariableInfo[0]);
    }

    public PVariableInfo[] getPVariableInfo(IPJob job) {
        List<PVariableInfo> infoList = this.jobVariableMap.get(job.getID());
        if (infoList == null) {
            return new PVariableInfo[0];
        }
        return infoList.toArray(new PVariableInfo[0]);
    }

    public boolean isPVariableEnable(IPJob job, String varname) {
        List<PVariableInfo> infoList = this.jobVariableMap.get(job.getID());
        if (infoList != null) {
            PVariableInfo[] pVariableInfoArray = infoList.toArray(new PVariableInfo[0]);
            int n = pVariableInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                PVariableInfo info = pVariableInfoArray[n2];
                if (info.getName().equals(varname)) {
                    return info.isEnabled();
                }
                ++n2;
            }
        }
        return false;
    }

    public void updateVariableStatus(PVariableInfo info, boolean enabled) throws CoreException {
        info.setEnabled(enabled);
        this.getSession(info.getJob()).getPDISession().getExpressionManager().updateStatusMultiExpressions(info.getName(), enabled);
    }

    public void updateVariableStatus(IPJob job, String varname, boolean enabled) throws CoreException {
        PVariableInfo info = this.findVariableInfo(job, varname);
        if (info == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, NLS.bind((String)Messages.PVariableManager_0, (Object)varname), null));
        }
        this.updateVariableStatus(info, enabled);
    }

    public void addVariable(IPJob job, String varname, boolean enabled) throws CoreException {
        if (this.findVariableInfo(job, varname) != null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, NLS.bind((String)Messages.PVariableManager_1, (Object)varname), null));
        }
        List<PVariableInfo> infoList = this.jobVariableMap.get(job.getID());
        if (infoList == null) {
            infoList = new ArrayList<PVariableInfo>();
            this.jobVariableMap.put(job.getID(), infoList);
        }
        IPSession session = this.getSession(job);
        session.getPDISession().getExpressionManager().createMutliExpressions(session.getTasks(), varname, enabled);
        infoList.add(new PVariableInfo(job, varname, enabled));
    }

    public void removeVariable(IPJob job) {
        this.removeVariable(job.getID());
    }

    public void removeVariable(String job_id) {
        this.jobVariableMap.remove(job_id);
    }

    public void removeVariable(IPJob job, String varname) throws CoreException {
        PVariableInfo info = this.findVariableInfo(job, varname);
        if (info == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, NLS.bind((String)Messages.PVariableManager_0, (Object)varname), null));
        }
        this.jobVariableMap.get(job.getID()).remove(info);
        this.getSession(job).getPDISession().getExpressionManager().removeMutliExpressions(varname);
    }

    public void updateVariable(IPJob job, String varname, String newvarname, boolean enabled) throws CoreException {
        if (newvarname != null) {
            this.removeVariable(job, varname);
            this.addVariable(job, newvarname, enabled);
        } else {
            this.updateVariableStatus(job, varname, enabled);
        }
    }

    public void updateValues(IPJob job) {
        try {
            this.updateValues(job, this.getSession(job).getTasks());
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public void updateValues(final IPJob job, final BitList tasks) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IPDISession session = PVariableManager.this.getSession(job).getPDISession();
                    BitList targetTasks = session.getTaskManager().getSuspendedTasks(tasks);
                    if (targetTasks.isEmpty()) {
                        monitor.done();
                    } else {
                        session.getExpressionManager().updateMultiExpressions(targetTasks, monitor);
                    }
                }
                catch (CoreException ce) {
                    throw new InterruptedException(ce.getMessage());
                }
                catch (PDIException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
        };
        try {
            new ProgressMonitorDialog(PTPDebugUIPlugin.getActiveWorkbenchShell()).run(true, true, runnable);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException ie) {
            ie.printStackTrace();
        }
    }

    public String getValue(final IPJob job, final int task, final IToolTipProvider provider) {
        IPDIExpression[] expressions;
        block11: {
            block10: {
                IPSession session = this.getSession(job);
                expressions = session.getPDISession().getExpressionManager().getMultiExpressions(task);
                if (expressions != null && expressions.length != 0) break block10;
                return "";
            }
            IPProcess p = job.getProcessByIndex(task);
            if (p != null && p.getState() != ProcessAttributes.State.SUSPENDED) break block11;
            return "";
        }
        try {
            StringBuffer display = new StringBuffer();
            IPDIExpression[] iPDIExpressionArray = expressions;
            int n = expressions.length;
            int n2 = 0;
            while (n2 < n) {
                IPDIExpression expression = iPDIExpressionArray[n2];
                display.append("<i>");
                display.append(expression.getExpressionText());
                display.append("</i>");
                display.append(" = ");
                try {
                    IAIF aif = expression.getAIF();
                    if (aif == null) {
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    IPSession session = PVariableManager.this.getSession(job);
                                    session.getPDISession().getExpressionManager().updateMultiExpressions(session.getTasks(task), monitor);
                                }
                                catch (CoreException ce) {
                                    throw new InterruptedException(ce.getMessage());
                                }
                                catch (PDIException pDIException) {}
                                if (provider != null) {
                                    provider.update(null, PVariableManager.this.getValue(job, task, null));
                                }
                            }
                        };
                        this.queueRunnable(runnable);
                        display.append(Messages.PVariableManager_2);
                    } else {
                        display.append(aif.getValue().getValueString());
                    }
                }
                catch (PDIException e) {
                    display.append(e.getMessage());
                }
                catch (AIFException ae) {
                    display.append(ae.getMessage());
                }
                display.append("<br>");
                ++n2;
            }
            return display.toString();
        }
        catch (CoreException e) {
            return e.getMessage();
        }
    }

    public void resetValues(final IPJob job) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IPSession session = PVariableManager.this.getSession(job);
                    session.getPDISession().getExpressionManager().cleanMultiExpressions(session.getTasks(), monitor);
                }
                catch (CoreException ce) {
                    throw new InterruptedException(ce.getMessage());
                }
                catch (PDIException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
        };
        this.queueRunnable(runnable);
    }

    public void resetValue(final IPJob job, final BitList tasks) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IPSession session = PVariableManager.this.getSession(job);
                    session.getPDISession().getExpressionManager().cleanMultiExpressions(tasks, monitor);
                }
                catch (CoreException ce) {
                    throw new InterruptedException(ce.getMessage());
                }
                catch (PDIException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
        };
        this.queueRunnable(runnable);
    }

    private PVariableInfo findVariableInfo(IPJob job, String varname) {
        List<PVariableInfo> infoList = this.jobVariableMap.get(job.getID());
        if (infoList != null) {
            PVariableInfo[] pVariableInfoArray = infoList.toArray(new PVariableInfo[0]);
            int n = pVariableInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                PVariableInfo info = pVariableInfoArray[n2];
                if (info.getName().equals(varname)) {
                    return info;
                }
                ++n2;
            }
        }
        return null;
    }

    private IPSession getSession(IPJob job) throws CoreException {
        IPSession session = PTPDebugCorePlugin.getDebugModel().getSession(job);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.PVariableManager_3, null));
        }
        return session;
    }

    public void queueRunnable(IRunnableWithProgress runnable) {
        this.upVariableJob.addRunnable(runnable);
    }

    public class PVariableInfo {
        private IPJob job;
        private String name;
        private boolean enabled;

        public PVariableInfo(IPJob job, String name, boolean enabled) {
            this.job = job;
            this.name = name;
            this.enabled = enabled;
        }

        public IPJob getJob() {
            return this.job;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    private class UpdateVariableJob
    extends Job {
        private Vector<IRunnableWithProgress> fRunnables;

        public UpdateVariableJob() {
            super(Messages.PVariableManager_4);
            this.setSystem(true);
            this.fRunnables = new Vector(10);
        }

        public void cancelAll() {
            this.fRunnables.clear();
            super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRunnable(IRunnableWithProgress runnable) {
            Vector<IRunnableWithProgress> vector = this.fRunnables;
            synchronized (vector) {
                this.fRunnables.add(runnable);
            }
            this.schedule();
        }

        public boolean shouldRun() {
            return !this.fRunnables.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            IRunnableWithProgress[] runnables;
            Vector<IRunnableWithProgress> vector = this.fRunnables;
            synchronized (vector) {
                runnables = this.fRunnables.toArray(new IRunnableWithProgress[0]);
                this.fRunnables.clear();
            }
            MultiStatus failed = null;
            monitor.beginTask(this.getName(), runnables.length);
            IRunnableWithProgress[] iRunnableWithProgressArray = runnables;
            int n = runnables.length;
            int n2 = 0;
            while (n2 < n) {
                IRunnableWithProgress runnable = iRunnableWithProgressArray[n2];
                try {
                    runnable.run(monitor);
                }
                catch (Exception e) {
                    if (failed == null) {
                        failed = new MultiStatus(PTPDebugCorePlugin.getUniqueIdentifier(), 1000, Messages.PVariableManager_5, null);
                    }
                    failed.add((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, Messages.PVariableManager_5, (Throwable)e));
                }
                monitor.worked(1);
                ++n2;
            }
            monitor.done();
            if (failed == null) {
                return Status.OK_STATUS;
            }
            return failed;
        }
    }
}

