/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteFileEnumeration;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.core.IRemotePathTools;
import org.eclipse.ptp.remotetools.core.IRemoteScript;
import org.eclipse.ptp.remotetools.core.RemoteProcess;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.Messages;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileAttributes;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileEnumeration;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileRecursiveEnumeration;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTools
implements IRemoteFileTools {
    protected ExecutionManager manager;
    private int cachedUserID;
    private Set<Integer> cachedGroupIDSet;
    private String fOSName = null;

    protected FileTools(ExecutionManager manager) {
        this.manager = manager;
    }

    @Override
    public void assureDirectory(String directory) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(directory);
        if (!this.hasDirectory(directory)) {
            this.createDirectory(directory);
        }
    }

    @Override
    public boolean canExecute(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isExecutable();
    }

    @Override
    public boolean canRead(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isReadable();
    }

    @Override
    public boolean canWrite(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isWritable();
    }

    @Override
    public void copyFile(String from, String to) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(from);
        this.validateRemotePath(to);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        try {
            this.executeCommand("cp -f " + pathTool.quote(from, true) + " " + pathTool.quote(to, true));
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDirectory(String directory) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(directory);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        String path = pathTool.quote(directory, true);
        String parent = pathTool.parent(path);
        RemoteFileAttributes attrs = this.fetchRemoteAttr(parent);
        if (attrs == null) {
            this.createDirectory(parent);
        }
        FileTools fileTools = this;
        synchronized (fileTools) {
            try {
                this.manager.getConnection().getDefaultSFTPChannel().mkdir(path);
            }
            catch (SftpException e) {
                if (e.id == 4) {
                    try {
                        this.executeCommand("mkdir -p " + path);
                    }
                    catch (RemoteExecutionException e1) {
                        throw new RemoteOperationException(e1);
                    }
                }
                throw new RemoteOperationException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFile(String file) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        String path = pathTool.quote(file, true);
        FileTools fileTools = this;
        synchronized (fileTools) {
            try {
                OutputStream os = this.manager.getConnection().getDefaultSFTPChannel().put(path);
                os.close();
            }
            catch (Exception e) {
                throw new RemoteOperationException(e);
            }
        }
    }

    @Override
    public IRemoteFileEnumeration createFileEnumeration(String path) throws RemoteOperationException, RemoteConnectionException, CancelException {
        return new RemoteFileEnumeration(this, path);
    }

    @Override
    public IRemoteFileEnumeration createRecursiveFileEnumeration(String path) throws RemoteOperationException, RemoteConnectionException, CancelException {
        return new RemoteFileRecursiveEnumeration(this, path);
    }

    @Override
    public IRemoteItem getDirectory(String directoryPath) throws RemoteOperationException, RemoteConnectionException, CancelException, RemoteOperationException {
        this.test();
        this.validateRemotePath(directoryPath);
        directoryPath = this.removeTrailingSlash(directoryPath);
        this.cacheUserData();
        RemoteItem remfile = new RemoteItem(this, directoryPath);
        remfile.refreshAttributes();
        if (!remfile.isDirectory()) {
            throw new RemoteOperationException("Not a directory");
        }
        return remfile;
    }

    @Override
    public IRemoteItem getFile(String filePath) throws RemoteOperationException, RemoteConnectionException, CancelException, RemoteOperationException {
        this.test();
        this.validateRemotePath(filePath);
        filePath = this.removeTrailingSlash(filePath);
        this.cacheUserData();
        RemoteItem remfile = new RemoteItem(this, filePath);
        remfile.refreshAttributes();
        if (remfile.isDirectory()) {
            throw new RemoteOperationException("Not a file");
        }
        return remfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(String file, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        String path = pathTool.quote(file, true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IRemoteScript script = this.manager.executionTools.createScript();
        script.setScript("cat " + path);
        RemoteProcess proc = null;
        FileTools fileTools = this;
        synchronized (fileTools) {
            try {
                proc = this.manager.executionTools.executeProcess(script);
            }
            catch (RemoteExecutionException e) {
                throw new RemoteOperationException(e.getLocalizedMessage());
            }
            if (proc == null) {
                throw new RemoteOperationException("Unable to get input stream");
            }
        }
        return proc.getInputStream();
    }

    @Override
    public IRemoteItem getItem(String path) throws RemoteConnectionException, RemoteOperationException, CancelException, RemoteOperationException {
        this.test();
        this.validateRemotePath(path);
        path = this.removeTrailingSlash(path);
        this.cacheUserData();
        return new RemoteItem(this, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream(String file, int options, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        String path = pathTool.quote(file, true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        RemoteProcess proc = null;
        IRemoteScript script = this.manager.executionTools.createScript();
        if ((options & 1) == 0) {
            script.setScript("cat > " + path);
        } else {
            script.setScript("cat >> " + path);
        }
        FileTools fileTools = this;
        synchronized (fileTools) {
            try {
                proc = this.manager.executionTools.executeProcess(script);
            }
            catch (RemoteExecutionException e) {
                throw new RemoteOperationException(e.getLocalizedMessage());
            }
            if (proc == null) {
                throw new RemoteOperationException("Unable to get output stream");
            }
        }
        return proc.getOutputStream();
    }

    @Override
    public IRemoteCopyTools getRemoteCopyTools() throws RemoteConnectionException {
        return this.manager.getRemoteCopyTools();
    }

    @Override
    public boolean hasDirectory(String directory) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(directory);
        RemoteItem item = (RemoteItem)this.getItem(directory);
        item.refreshAttributes();
        if (item == null) {
            return false;
        }
        if (!item.exists()) {
            return false;
        }
        return item.isDirectory();
    }

    @Override
    public boolean hasFile(String file) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemoteItem item = this.getItem(file);
        item.refreshAttributes();
        if (item == null) {
            return false;
        }
        if (!item.exists()) {
            return false;
        }
        return !item.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRemoteItem[] listItems(String root) throws RemoteOperationException, RemoteConnectionException, CancelException {
        Vector files;
        this.validateRemotePath(root);
        FileTools fileTools = this;
        synchronized (fileTools) {
            try {
                files = this.manager.getConnection().getDefaultSFTPChannel().ls(root);
            }
            catch (SftpException e) {
                IRemoteItem item;
                if (e.id == 2 && (item = this.getItem(root)).exists() && item.isDirectory()) {
                    return new IRemoteItem[0];
                }
                throw new RemoteOperationException(Messages.RemoteFileTools_ListFiles_FailedListRemote, e);
            }
        }
        this.cacheUserData();
        ArrayList<RemoteItem> result = new ArrayList<RemoteItem>();
        Enumeration enumeration = files.elements();
        while (enumeration.hasMoreElements()) {
            ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)enumeration.nextElement();
            String fileName = entry.getFilename();
            String pathName = this.concatenateRemotePath(root, fileName);
            if (fileName.equals(".") || fileName.equals("..")) continue;
            result.add(new RemoteItem(this, pathName, entry.getAttrs()));
        }
        IRemoteItem[] resultArray = new IRemoteItem[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    @Override
    public void moveFile(String from, String to) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(from);
        this.validateRemotePath(to);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        try {
            this.executeCommand("mv -f " + pathTool.quote(from, true) + " " + pathTool.quote(to, true));
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFile(String file) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        String path = pathTool.quote(file, true);
        FileTools fileTools = this;
        synchronized (fileTools) {
            try {
                this.manager.getConnection().getDefaultSFTPChannel().rm(path);
            }
            catch (SftpException e) {
                if (e.id == 4) {
                    try {
                        this.executeCommand("rm -f " + path);
                    }
                    catch (RemoteExecutionException e1) {
                        throw new RemoteOperationException(e1);
                    }
                }
                throw new RemoteOperationException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDirectory(String dir) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(dir);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        String path = pathTool.quote(dir, true);
        FileTools fileTools = this;
        synchronized (fileTools) {
            try {
                this.manager.getConnection().getDefaultSFTPChannel().rmdir(path);
            }
            catch (SftpException e) {
                if (e.id == 4) {
                    try {
                        this.executeCommand("rm -rf " + path);
                    }
                    catch (RemoteExecutionException e1) {
                        throw new RemoteOperationException(e1);
                    }
                }
                throw new RemoteOperationException(e);
            }
        }
    }

    private void cacheUserData() throws RemoteConnectionException, RemoteOperationException, CancelException {
        if (this.cachedGroupIDSet == null) {
            this.cachedGroupIDSet = this.manager.getRemoteStatusTools().getGroupIDSet();
            this.cachedUserID = this.manager.getRemoteStatusTools().getUserID();
        }
    }

    protected void executeCommand(String command) throws RemoteConnectionException, RemoteExecutionException, CancelException {
        this.manager.executionTools.executeBashCommand(command);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RemoteFileAttributes fetchRemoteAttr(String path) throws RemoteOperationException {
        try {
            this.test();
        }
        catch (RemoteConnectionException e) {
            throw new RemoteOperationException(e.getLocalizedMessage());
        }
        catch (CancelException e) {
            throw new RemoteOperationException(e.getLocalizedMessage());
        }
        this.validateRemotePath(path);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        String quotedPath = pathTool.quote(path, true);
        ExecutionManager executionManager = this.manager;
        synchronized (executionManager) {
            try {
                SftpATTRS attrs = this.manager.getConnection().getDefaultSFTPChannel().stat(path);
                return RemoteFileAttributes.getAttributes(attrs);
            }
            catch (SftpException e) {
                String result;
                if (e.id == 2) {
                    return null;
                }
                if (e.id != 4) {
                    throw new RemoteOperationException(Messages.RemoteFileTools_FetchRemoteAttr_FailedFetchAttr);
                }
                String statCmd = this.checkOSName("Darwin") ? "stat -f \"0%p %z %u %g %m %a\" " + quotedPath + " 2>&1" : "stat --format \"0x%f %s %u %g %X %Y\" " + quotedPath + " 2>&1";
                try {
                    result = this.manager.executionTools.executeWithOutput(statCmd);
                }
                catch (RemoteExecutionException e1) {
                    throw new RemoteOperationException(e1.getLocalizedMessage());
                }
                catch (RemoteConnectionException e1) {
                    throw new RemoteOperationException(e1.getLocalizedMessage());
                }
                catch (CancelException e1) {
                    throw new RemoteOperationException(e1.getLocalizedMessage());
                }
                return RemoteFileAttributes.getAttributes(result.trim());
            }
            catch (RemoteConnectionException e) {
                throw new RemoteOperationException(e.getLocalizedMessage());
            }
        }
    }

    public int getCachedUserID() {
        return this.cachedUserID;
    }

    public Set<Integer> getCachedGroupIDSet() {
        return this.cachedGroupIDSet;
    }

    protected void test() throws RemoteConnectionException, CancelException {
        this.manager.test();
        this.manager.testCancel();
    }

    private boolean checkOSName(String name) {
        if (this.fOSName == null) {
            try {
                this.fOSName = this.manager.getExecutionTools().executeWithOutput("uname").trim();
            }
            catch (RemoteExecutionException remoteExecutionException) {
                return false;
            }
            catch (RemoteConnectionException remoteConnectionException) {
                return false;
            }
            catch (CancelException cancelException) {
                return false;
            }
        }
        return this.fOSName.equals(name);
    }

    public String addTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path;
        }
        return String.valueOf(path) + "/";
    }

    public String concatenateRemotePath(String p1, String p2) {
        if (p1.endsWith("/")) {
            return String.valueOf(p1) + p2;
        }
        return String.valueOf(p1) + "/" + p2;
    }

    public String parentOfRemotePath(String path) {
        int index = (path = this.removeTrailingSlash(path)).lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return this.removeTrailingSlash(path.substring(0, index));
    }

    public String removeTrailingSlash(String path) {
        if (!path.equals("/") && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public String suffixOfRemotePath(String path) {
        int index = (path = this.removeTrailingSlash(path)).lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return this.removeTrailingSlash(path.substring(index + 1));
    }

    public void uploadPermissions(File file, String remoteFilePath) throws RemoteConnectionException, RemoteOperationException, CancelException {
        IRemoteItem item = this.getItem(remoteFilePath);
        item.setReadable(file.canRead());
        item.setWriteable(file.canWrite());
        item.commitAttributes();
    }

    public void validateRemotePath(String path) throws RemoteOperationException {
        if (!path.startsWith("/")) {
            throw new RemoteOperationException(String.valueOf(path) + Messages.RemoteFileTools_ValidateRemotePath_NotValid);
        }
    }

    public static class FileToolsProgressMonitor
    implements SftpProgressMonitor {
        private IProgressMonitor fMonitor;
        private long fWorkToDate;

        public FileToolsProgressMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public boolean count(long count) {
            this.fWorkToDate += count;
            return !this.fMonitor.isCanceled();
        }

        public void end() {
        }

        public void init(int op, String src, String dest, long max) {
            String srcFile;
            this.fWorkToDate = 0L;
            String desc = srcFile = new Path(src).lastSegment();
            this.fMonitor.beginTask(desc, (int)max);
        }
    }
}

