/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisitor;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTTemplatedTypeTemplateParameter
extends ASTNode
implements ICPPASTTemplatedTypeTemplateParameter,
IASTAmbiguityParent {
    private ICPPASTTemplateParameter[] parameters = null;
    private int parametersPos = -1;
    private IASTName name;
    private IASTExpression defaultValue;

    public CPPASTTemplatedTypeTemplateParameter() {
    }

    public CPPASTTemplatedTypeTemplateParameter(IASTName name, IASTExpression defaultValue) {
        this.setName(name);
        this.setDefaultValue(defaultValue);
    }

    public CPPASTTemplatedTypeTemplateParameter copy() {
        CPPASTTemplatedTypeTemplateParameter copy = new CPPASTTemplatedTypeTemplateParameter();
        copy.setName(this.name == null ? null : this.name.copy());
        copy.setDefaultValue(this.defaultValue == null ? null : this.defaultValue.copy());
        ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = this.getTemplateParameters();
        int n = iCPPASTTemplateParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTTemplateParameter param = iCPPASTTemplateParameterArray[n2];
            copy.addTemplateParamter(param == null ? null : param.copy());
            ++n2;
        }
        copy.setOffsetAndLength(this);
        return copy;
    }

    public ICPPASTTemplateParameter[] getTemplateParameters() {
        if (this.parameters == null) {
            return ICPPASTTemplateParameter.EMPTY_TEMPLATEPARAMETER_ARRAY;
        }
        this.parameters = (ICPPASTTemplateParameter[])ArrayUtil.removeNullsAfter(ICPPASTTemplateParameter.class, this.parameters, this.parametersPos);
        return this.parameters;
    }

    public void addTemplateParamter(ICPPASTTemplateParameter parm) {
        this.assertNotFrozen();
        if (parm != null) {
            this.parameters = (ICPPASTTemplateParameter[])ArrayUtil.append(ICPPASTTemplateParameter.class, this.parameters, ++this.parametersPos, parm);
            parm.setParent(this);
            parm.setPropertyInParent(PARAMETER);
        }
    }

    public IASTName getName() {
        return this.name;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(PARAMETER_NAME);
        }
    }

    public IASTExpression getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(IASTExpression expression) {
        this.assertNotFrozen();
        this.defaultValue = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(DEFAULT_VALUE);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitTemplateParameters && action instanceof ICPPASTVisitor) {
            switch (((ICPPASTVisitor)((Object)action)).visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        ICPPASTTemplateParameter[] ps = this.getTemplateParameters();
        int i = 0;
        while (i < ps.length) {
            if (!ps[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (this.defaultValue != null && !this.defaultValue.accept(action)) {
            return false;
        }
        if (action.shouldVisitTemplateParameters && action instanceof ICPPASTVisitor) {
            switch (((ICPPASTVisitor)((Object)action)).leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 0;
        }
        return 3;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.defaultValue) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.defaultValue = (IASTExpression)other;
        }
    }
}

