/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.manager;

import java.math.BigInteger;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDISourceManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIInstruction;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMixedInstruction;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.internal.core.pdi.manager.AbstractPDIManager;

public class SourceManager
extends AbstractPDIManager
implements IPDISourceManager {
    public SourceManager(IPDISession session) {
        super(session, false);
    }

    public String getDetailTypeName(IPDITarget target, String typename) throws PDIException {
        throw new PDIException(target.getTasks(), "Not implements SourceManager - getDetailTypeName() yet");
    }

    public String getDetailTypeNameFromVariable(IPDIStackFrame frame, String variable) throws PDIException {
        IPDITarget target = frame.getTarget();
        IPDIThread currentThread = target.getCurrentThread();
        IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            target.setCurrentThread(frame.getThread(), false);
            frame.getThread().setCurrentStackFrame(frame, false);
            String string = this.getDetailTypeName(target, variable);
            return string;
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
        }
    }

    public IPDIInstruction[] getInstructions(BitList qTasks, BigInteger start, BigInteger end) throws PDIException {
        throw new PDIException(qTasks, "Not implemented SourceManager - getInstructions() yet");
    }

    public IPDIInstruction[] getInstructions(BitList qTasks, String filename, int linenum) throws PDIException {
        return this.getInstructions(qTasks, filename, linenum, -1);
    }

    public IPDIInstruction[] getInstructions(BitList qTasks, String filename, int linenum, int lines) throws PDIException {
        throw new PDIException(qTasks, "Not implemented SourceManager - getInstructions() yet");
    }

    public IPDIMixedInstruction[] getMixedInstructions(BitList qTasks, BigInteger start, BigInteger end) throws PDIException {
        throw new PDIException(qTasks, "Not implemented SourceManager - getMixedInstructions() yet");
    }

    public IPDIMixedInstruction[] getMixedInstructions(BitList qTasks, String filename, int linenum) throws PDIException {
        return this.getMixedInstructions(qTasks, filename, linenum, -1);
    }

    public IPDIMixedInstruction[] getMixedInstructions(BitList qTasks, String filename, int linenum, int lines) throws PDIException {
        throw new PDIException(qTasks, "Not implemented SourceManager - getMixedInstructions() yet");
    }

    public String[] getSourcePaths(BitList qTasks) throws PDIException {
        throw new PDIException(qTasks, "Not implemented SourceManager - getSourcePaths() yet");
    }

    public String getTypeName(IPDITarget target, String variable) throws PDIException {
        throw new PDIException(target.getTasks(), "Not implements SourceManager - getTypeName() yet");
    }

    public String getTypeNameFromVariable(IPDIStackFrame frame, String variable) throws PDIException {
        IPDITarget target = frame.getTarget();
        IPDIThread currentThread = target.getCurrentThread();
        IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            target.setCurrentThread(frame.getThread(), false);
            frame.getThread().setCurrentStackFrame(frame, false);
            String string = this.getTypeName(target, variable);
            return string;
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
        }
    }

    public void setSourcePaths(BitList qTasks, String[] dirs) throws PDIException {
        throw new PDIException(qTasks, "Not implemented SourceManager - setSourcePaths() yet");
    }

    public void shutdown() {
    }

    public void update(BitList qTasks) throws PDIException {
    }
}

