/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.ui.views;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.event.IPDebugErrorInfo;
import org.eclipse.ptp.debug.core.event.IPDebugEvent;
import org.eclipse.ptp.debug.core.event.IPDebugInfo;
import org.eclipse.ptp.debug.core.event.IPDebugRegisterInfo;
import org.eclipse.ptp.debug.internal.ui.PDebugUIUtils;
import org.eclipse.ptp.debug.internal.ui.views.AbstractPDebugViewEventHandler;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.UIDebugManager;
import org.eclipse.ptp.debug.ui.views.ParallelDebugView;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ui.IViewPart;

public class ParallelDebugViewEventHandler
extends AbstractPDebugViewEventHandler {
    private long time_record = 0L;

    public ParallelDebugViewEventHandler(ParallelDebugView view) {
        super((IViewPart)view);
    }

    public ParallelDebugView getPView() {
        return (ParallelDebugView)this.getView();
    }

    public void refresh(boolean all) {
        if (this.getPView().isVisible()) {
            this.getPView().refresh(all);
        }
    }

    protected void doHandleDebugEvent(IPDebugEvent event, IProgressMonitor monitor) {
        IPDebugInfo info = event.getInfo();
        IPJob job = info.getJob();
        block0 : switch (event.getKind()) {
            case 4: {
                switch (event.getDetail()) {
                    case 2048: {
                        boolean refresh = true;
                        if (info instanceof IPDebugRegisterInfo) {
                            refresh = ((IPDebugRegisterInfo)info).isRefresh();
                        }
                        int[] c_regTask_array = info.getAllTasks().toArray();
                        if (refresh) {
                            IElementHandler elementHandler = this.getPView().getElementHandler(job.getID());
                            if (elementHandler != null) {
                                ArrayList<IElement> regElementArray = new ArrayList<IElement>();
                                int j = 0;
                                while (j < c_regTask_array.length) {
                                    IPProcess proc = job.getProcessByIndex(c_regTask_array[j]);
                                    ((UIDebugManager)this.getPView().getUIManager()).addConsoleWindow(job, proc);
                                    IElement element = elementHandler.getSetRoot().getElementByID(proc.getID());
                                    if (element != null) {
                                        regElementArray.add(element);
                                    }
                                    ++j;
                                }
                                elementHandler.addToRegister(regElementArray.toArray(new IElement[regElementArray.size()]));
                            }
                            this.refresh();
                        }
                        if (c_regTask_array.length <= 0) break block0;
                        this.getPView().focusOnDebugTarget(job, c_regTask_array[0]);
                        break block0;
                    }
                    case 1024: {
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                IElementHandler elementHandler = this.getPView().getElementHandler(job.getID());
                switch (event.getDetail()) {
                    case 1024: {
                        if (elementHandler != null) {
                            elementHandler.removeElements(elementHandler.getRegistered());
                        }
                        this.refresh(true);
                        break block0;
                    }
                    case 2048: {
                        boolean refresh = true;
                        if (info instanceof IPDebugRegisterInfo) {
                            refresh = ((IPDebugRegisterInfo)info).isRefresh();
                        }
                        if (!refresh) break block0;
                        if (elementHandler != null) {
                            int[] t_regTask_array = info.getAllTasks().toArray();
                            IElement[] regElementArray = new IElement[t_regTask_array.length];
                            int j = 0;
                            while (j < t_regTask_array.length) {
                                IPProcess proc = job.getProcessByIndex(t_regTask_array[j]);
                                ((UIDebugManager)this.getPView().getUIManager()).removeConsoleWindow(job, proc);
                                regElementArray[j] = elementHandler.getSetRoot().getElementByID(proc.getID());
                                ++j;
                            }
                            elementHandler.removeFromRegister(regElementArray);
                        }
                        this.refresh();
                        break block0;
                    }
                    case 16: {
                        break block0;
                    }
                    case 32: {
                        UIDebugManager uiMgr = (UIDebugManager)this.getPView().getUIManager();
                        IPSession session = uiMgr.getDebugSession(job);
                        if (session != null) {
                            uiMgr.unregisterTasks(session, info.getAllRegisteredTasks());
                        }
                        this.refresh(true);
                        break block0;
                    }
                }
                this.refresh(true);
                break;
            }
            case 1: {
                this.time_record = System.currentTimeMillis();
                System.err.println("================= TIME RESUME: " + this.time_record);
                this.refresh(true);
                break;
            }
            case 2: {
                int[] processes;
                IPSession s = ((UIDebugManager)this.getPView().getUIManager()).getDebugSession(job);
                if (s != null && s.getTasks().cardinality() == s.getPDISession().getTaskManager().getSuspendedTasks().cardinality()) {
                    System.err.println("================= TIME ALL SUSPENDED: " + (System.currentTimeMillis() - this.time_record));
                    this.time_record = System.currentTimeMillis();
                }
                if ((processes = info.getAllRegisteredTasks().toArray()).length > 0) {
                    this.getPView().focusOnDebugTarget(job, processes[0]);
                }
                this.refresh(true);
                break;
            }
            case 16: {
                switch (event.getDetail()) {
                    case 32: {
                        IPSession session;
                        UIDebugManager uiMgr = (UIDebugManager)this.getPView().getUIManager();
                        if (!uiMgr.isEnabledDefaultRegister() || (session = uiMgr.getDebugSession(job)) == null) break block0;
                        uiMgr.registerTasks(session, session.getTasks(0));
                        break block0;
                    }
                }
                break;
            }
            case 64: {
                int[] e_regTask_array;
                final IPDebugErrorInfo errInfo = (IPDebugErrorInfo)info;
                if (event.getDetail() == 1) break;
                PTPDebugUIPlugin.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        String msg = "Error on tasks: " + PDebugUIUtils.showBitList(errInfo.getAllTasks()) + " - " + errInfo.getMsg() + "\nReason: " + errInfo.getDetailsMsg();
                        Status status = new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, msg, null);
                        PTPDebugUIPlugin.errorDialog("Error", (IStatus)status);
                    }
                });
                if (event.getDetail() != 4) break;
                IElementHandler eHandler = this.getPView().getElementHandler(job.getID());
                if (eHandler != null && (e_regTask_array = info.getAllRegisteredTasks().toArray()).length > 0) {
                    IElement[] regElementArray = new IElement[e_regTask_array.length];
                    int j = 0;
                    while (j < e_regTask_array.length) {
                        IPProcess proc = job.getProcessByIndex(e_regTask_array[j]);
                        ((UIDebugManager)this.getPView().getUIManager()).removeConsoleWindow(job, proc);
                        regElementArray[j] = eHandler.getSetRoot().getElementByID(proc.getID());
                        ++j;
                    }
                    eHandler.removeFromRegister(regElementArray);
                }
                this.refresh(true);
            }
        }
    }
}

