/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.serviceproviders;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.internal.rdt.core.index.IIndexLifecycleService;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.serviceproviders.PropertyPageServiceModelWidget;
import org.eclipse.ptp.rdt.ui.wizards.ConfigureRemoteServices;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;

public class ServiceModelPropertyPage
extends PropertyPage {
    private PropertyPageServiceModelWidget fModelWidget = new PropertyPageServiceModelWidget();
    private String indexLocation = null;

    public ServiceModelPropertyPage() {
        this.fModelWidget.setConfigChangeListener(new Listener(){

            public void handleEvent(Event event) {
                ServiceModelPropertyPage.this.setValid(ServiceModelPropertyPage.this.fModelWidget.isConfigured());
            }
        });
    }

    private IIndexServiceProvider getIndexServiceProvider(String id) {
        return (IIndexServiceProvider)this.fModelWidget.getProviderIDToProviderMap().get(id);
    }

    protected Control createContents(Composite parent) {
        Control table = this.fModelWidget.createContents(parent);
        if (this.getElement() instanceof IProject) {
            this.fModelWidget.updateServicesTable((IProject)this.getElement());
        } else if (this.getElement() instanceof ICProject) {
            this.fModelWidget.updateServicesTable(((ICProject)this.getElement()).getProject());
        }
        IIndexServiceProvider isp = this.getIndexServiceProvider("org.eclipse.ptp.rdt.ui.RemoteCIndexServiceProvider");
        if (isp != null) {
            this.indexLocation = isp.getIndexLocation();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ptp.rdt.ui.servce_model_property_page_context");
        return table;
    }

    public boolean performOk() {
        IAdaptable element = this.getElement();
        final IProject project = element instanceof IProject ? (IProject)element : ((ICProject)element).getProject();
        ConfigureRemoteServices.configure(project, this.fModelWidget.getServiceIDToSelectedProviderID(), this.fModelWidget.getProviderIDToProviderMap(), (IProgressMonitor)new NullProgressMonitor());
        final IIndexServiceProvider isp = this.getIndexServiceProvider("org.eclipse.ptp.rdt.ui.RemoteCIndexServiceProvider");
        if (isp != null) {
            final String newIndexLocation = isp.getIndexLocation();
            if (this.indexLocation != null && !this.indexLocation.equals(newIndexLocation)) {
                final IIndexLifecycleService indexService = isp.getIndexLifeCycleService();
                Job job = new Job(Messages.getString("ServiceModelPropertyPage.0")){

                    protected IStatus run(IProgressMonitor monitor) {
                        final String actualLocation = indexService.moveIndexFile(project.getName(), newIndexLocation, monitor);
                        if (!actualLocation.equals(newIndexLocation)) {
                            UIJob uijob = new UIJob(Messages.getString("ServiceModelPropertyPage.0")){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("ServiceModelPropertyPage.1"), (String)Messages.getString("ServiceModelPropertyPage.2", newIndexLocation, actualLocation));
                                    isp.setIndexLocation(actualLocation);
                                    return Status.OK_STATUS;
                                }
                            };
                            uijob.schedule();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean isValid() {
        return this.fModelWidget.isConfigured();
    }
}

