/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.dependence;

import java.util.Arrays;
import org.eclipse.photran.internal.core.analysis.dependence.Direction;
import org.eclipse.photran.internal.core.analysis.dependence.IDependenceTester;

public class GeneralizedGCDTest
implements IDependenceTester {
    public IDependenceTester.Result test(int n, int[] L, int[] U, int[] a, int[] b, Direction[] direction) {
        IntMatrix coeffs = IntMatrix.zero(2 * n, 2 * n);
        int i = 1;
        while (i <= n) {
            coeffs.set(1, 2 * (i - 1) + 1, a[i]);
            coeffs.set(1, 2 * (i - 1) + 2, -b[i]);
            ++i;
        }
        int[] c = new int[2 * n];
        c[0] = b[0] - a[0];
        System.out.println("Solving\n" + coeffs + " * t =\n" + Arrays.toString(c));
        IntVector sol = coeffs.solve(c);
        System.out.println("    t =\n" + (sol == null ? "null" : sol));
        return sol != null && !sol.isZero() ? IDependenceTester.Result.POSSIBLE_DEPENDENCE : IDependenceTester.Result.NO_DEPENDENCE;
    }

    public static final class IntMatrix {
        protected final int rows;
        protected final int cols;
        protected final int[][] data;

        public static IntMatrix zero(int rows, int cols) {
            return new IntMatrix(rows, cols);
        }

        public static IntMatrix identity(int rank) {
            IntMatrix id = new IntMatrix(rank, rank);
            int i = 1;
            while (i <= rank) {
                id.set(i, i, 1);
                ++i;
            }
            return id;
        }

        public static IntMatrix copyFrom(IntMatrix m) {
            IntMatrix result = IntMatrix.zero(m.rows, m.cols);
            int col = 0;
            while (col < m.cols) {
                System.arraycopy(m.data[col], 0, result.data[col], 0, m.rows);
                ++col;
            }
            return result;
        }

        public static IntMatrix create(int rows, int cols, int ... vals) {
            if (vals.length != rows * cols) {
                throw new IllegalArgumentException("Wrong number of values");
            }
            IntMatrix result = IntMatrix.zero(rows, cols);
            int i = 0;
            int row = 1;
            while (row <= rows) {
                int col = 1;
                while (col <= cols) {
                    result.set(row, col, vals[i++]);
                    ++col;
                }
                ++row;
            }
            return result;
        }

        protected IntMatrix(int rows, int cols) {
            this.rows = rows;
            this.cols = cols;
            this.data = new int[cols][rows];
        }

        public int get(int row, int col) {
            this.check(row, col);
            return this.data[col - 1][row - 1];
        }

        public void set(int row, int col, int value) {
            this.check(row, col);
            this.data[col - 1][row - 1] = value;
        }

        public void swapColumns(int col1, int col2) {
            int[] tmp = this.data[col1 - 1];
            this.data[col1 - 1] = this.data[col2 - 1];
            this.data[col2 - 1] = tmp;
        }

        protected void check(int row, int col) {
            if (row < 1 || row > this.rows) {
                throw new IllegalArgumentException("Invalid row " + row);
            }
            if (col < 1 || col > this.cols) {
                throw new IllegalArgumentException("Invalid column " + col);
            }
        }

        public int numRows() {
            return this.rows;
        }

        public int numCols() {
            return this.cols;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int row = 1;
            while (row <= this.rows) {
                int col = 1;
                while (col <= this.cols) {
                    sb.append(String.format("%5d", this.get(row, col)));
                    ++col;
                }
                sb.append('\n');
                ++row;
            }
            return sb.toString();
        }

        public boolean equalsUnwrapped(int ... vals) {
            if (vals.length != this.rows * this.cols) {
                throw new IllegalArgumentException("Wrong length array");
            }
            int i = 0;
            int row = 1;
            while (row <= this.rows) {
                int col = 1;
                while (col <= this.cols) {
                    if (this.get(row, col) != vals[i++]) {
                        return false;
                    }
                    ++col;
                }
                ++row;
            }
            return true;
        }

        public Reduce reduce() {
            return new Reduce(this);
        }

        public IntVector solve(int ... c) {
            if (!this.isSquare()) {
                throw new IllegalArgumentException();
            }
            Reduce reduce = this.reduce();
            IntMatrix d = reduce.getColumnEchelonForm();
            IntVector t = d.forwardSubstitute(c);
            if (t == null) {
                return null;
            }
            IntVector x = reduce.getUnimodularMatrix().times(t);
            return x;
        }

        private IntVector times(IntVector vec) {
            int origSize = vec.size();
            if (origSize < this.numRows()) {
                IntVector newVec = IntVector.zero(this.numRows());
                int i = 1;
                while (i <= origSize) {
                    newVec.set(i, vec.get(i));
                    ++i;
                }
                vec = newVec;
            }
            int size = vec.size();
            if (this.numRows() != size) {
                throw new IllegalArgumentException();
            }
            if (this.numCols() != size) {
                throw new IllegalArgumentException();
            }
            IntVector result = IntVector.zero(size);
            int row = 1;
            while (row <= size) {
                int sum = 0;
                int col = 1;
                while (col <= size) {
                    sum += vec.get(col) * this.get(row, col);
                    ++col;
                }
                result.set(row, sum);
                ++row;
            }
            if (origSize != size) {
                IntVector newVec = IntVector.zero(origSize);
                int i = 1;
                while (i <= origSize) {
                    newVec.set(i, result.get(i));
                    ++i;
                }
                return newVec;
            }
            return result;
        }

        public boolean isZero(int row, int colFrom, int colThru) {
            int col = colFrom;
            while (col <= colThru) {
                if (this.get(row, col) != 0) {
                    return false;
                }
                ++col;
            }
            return true;
        }

        public int colWithMinimumMagnitude(int row, int fromCol, int thruCol) {
            while (this.get(row, fromCol) == 0 && fromCol <= this.cols) {
                ++fromCol;
            }
            if (fromCol > this.cols) {
                throw new IllegalArgumentException();
            }
            int result = fromCol;
            int col = fromCol;
            while (col <= thruCol) {
                if (this.get(row, col) != 0 && Math.abs(this.get(row, col)) < Math.abs(this.get(row, result))) {
                    result = col;
                }
                ++col;
            }
            return result;
        }

        public void addColumnMultiple(int col1, int factor, int col2) {
            int row = 1;
            while (row <= this.rows) {
                this.set(row, col1, this.get(row, col1) + factor * this.get(row, col2));
                ++row;
            }
        }

        public IntVector forwardSubstitute(int ... c) {
            if (!this.isSquare()) {
                throw new IllegalArgumentException();
            }
            if (c.length != this.numRows()) {
                throw new IllegalArgumentException();
            }
            int size = this.numRows();
            IntVector x = IntVector.zero(size);
            int i = 1;
            while (i <= size) {
                int sum = 0;
                int j = 1;
                while (j < i) {
                    sum += this.get(i, j) * x.get(j);
                    ++j;
                }
                if (c[i - 1] - sum == 0 && this.get(i, i) == 0) {
                    x.set(i, 0);
                } else {
                    if (this.get(i, i) == 0) {
                        return null;
                    }
                    x.set(i, (c[i - 1] - sum) / this.get(i, i));
                }
                ++i;
            }
            return x;
        }

        private boolean isSquare() {
            return this.numRows() == this.numCols();
        }

        public static final class Reduce {
            protected IntMatrix a;
            private IntMatrix d;
            private IntMatrix u;

            protected Reduce(IntMatrix a) {
                if (a.numRows() == 1) {
                    this.a = a;
                    this.u = IntMatrix.identity(a.numCols());
                    this.d = IntMatrix.copyFrom(a);
                    this.reduce(1, 1, a.numCols());
                } else {
                    this.a = a;
                    this.u = IntMatrix.identity(a.numCols());
                    this.d = IntMatrix.copyFrom(a);
                    int c = 1;
                    int i = 1;
                    while (i <= a.numRows()) {
                        this.reduce(i, c, a.numCols());
                        if (this.d.get(i, c) != 0) {
                            ++c;
                        }
                        ++i;
                    }
                }
            }

            protected void reduce(int i, int j, int n) {
                int k;
                boolean f;
                do {
                    if (this.d.isZero(i, j, n)) {
                        return;
                    }
                    k = this.d.colWithMinimumMagnitude(i, j, this.d.numCols());
                    f = true;
                    int m = j;
                    while (m <= n) {
                        int q;
                        if (m != k && (q = this.d.get(i, m) / this.d.get(i, k)) != 0) {
                            this.d.addColumnMultiple(m, -q, k);
                            this.u.addColumnMultiple(m, -q, k);
                            if (this.d.get(i, m) > 0) {
                                f = false;
                            }
                        }
                        ++m;
                    }
                } while (!f);
                if (k != 1) {
                    this.d.swapColumns(j, k);
                    this.u.swapColumns(j, k);
                }
            }

            public IntMatrix getUnimodularMatrix() {
                return this.u;
            }

            public IntMatrix getColumnEchelonForm() {
                return this.d;
            }

            public String toString() {
                return "A =\n" + this.a + "\n\nD =\n" + this.d + "\n\nU =\n" + this.u;
            }
        }
    }

    public static final class IntVector {
        protected final int[] data;

        public static IntVector zero(int size) {
            return new IntVector(size);
        }

        public static IntVector copyFrom(IntVector m) {
            IntVector result = IntVector.zero(m.data.length);
            System.arraycopy(m.data, 0, result.data, 0, m.data.length);
            return result;
        }

        public static IntVector create(int ... vals) {
            IntVector result = IntVector.zero(vals.length);
            System.arraycopy(vals, 0, result.data, 0, vals.length);
            return result;
        }

        protected IntVector(int size) {
            this.data = new int[size];
        }

        public int get(int element) {
            this.check(element);
            return this.data[element - 1];
        }

        public void set(int element, int value) {
            this.check(element);
            this.data[element - 1] = value;
        }

        protected void check(int element) {
            if (element < 1 || element > this.data.length) {
                throw new IllegalArgumentException("Invalid element " + element);
            }
        }

        public int size() {
            return this.data.length;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int row = 1;
            while (row <= this.size()) {
                sb.append(String.format("%5d", this.get(row)));
                sb.append('\n');
                ++row;
            }
            return sb.toString();
        }

        public boolean equalsUnwrapped(int ... vals) {
            if (vals.length != this.data.length) {
                throw new IllegalArgumentException("Wrong length array");
            }
            return Arrays.equals(vals, this.data);
        }

        public boolean isZero() {
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i] != 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public IntVector asRowTimes(IntMatrix matrix) {
            int size = this.size();
            if (matrix.numRows() != size) {
                throw new IllegalArgumentException();
            }
            if (matrix.numCols() != size) {
                throw new IllegalArgumentException();
            }
            IntVector result = IntVector.zero(size);
            int col = 1;
            while (col <= size) {
                int sum = 0;
                int row = 1;
                while (row <= size) {
                    sum += this.get(row) * matrix.get(row, col);
                    ++row;
                }
                result.set(col, sum);
                ++col;
            }
            return result;
        }
    }
}

