/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.loops;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.parser.ASTDoConstructNode;
import org.eclipse.photran.internal.core.parser.ASTEndDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTLabelDoStmtNode;
import org.eclipse.photran.internal.core.parser.IActionStmt;
import org.eclipse.photran.internal.core.parser.IExecutableConstruct;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.parser.IObsoleteActionStmt;
import org.eclipse.photran.internal.core.parser.Parser;

public class LoopReplacer {
    private List<ASTDoConstructNode> queue = new LinkedList<ASTDoConstructNode>();

    public static void replaceAllLoopsIn(ScopingNode scope) {
        new LoopReplacer().replaceLoopsFromLastToFirstIn(scope);
    }

    private void replaceLoopsFromLastToFirstIn(ScopingNode scope) {
        this.collectLoopsIn(scope);
        while (!this.queue.isEmpty()) {
            this.replaceLoop(this.queue.remove(0));
        }
    }

    private void collectLoopsIn(ScopingNode scope) {
        scope.accept(new Parser.ASTVisitor(){

            public void visitASTDoConstructNode(ASTDoConstructNode node) {
                if (!this.isHeaderForOldStyleLoop(node)) {
                    LoopReplacer.this.queue.add(0, node);
                }
            }

            private boolean isHeaderForOldStyleLoop(ASTDoConstructNode node) {
                return node.getLabelDoStmt().getLblRef() != null;
            }
        });
    }

    private void replaceLoop(ASTDoConstructNode loopToReplace) {
        ASTProperLoopConstructNode newLoop = this.buildASTProperLoopConstructNode(loopToReplace.getLabelDoStmt());
        this.removeAndReparentNodesIn(newLoop);
        Parser.IASTNode parent = loopToReplace.getParent();
        loopToReplace.replaceWith(newLoop);
        newLoop.setParent(parent);
    }

    private ASTProperLoopConstructNode buildASTProperLoopConstructNode(ASTLabelDoStmtNode lastLoopHeader) {
        ASTProperLoopConstructBuilder nodeBuilder = new ASTProperLoopConstructBuilder(lastLoopHeader);
        lastLoopHeader.findNearestAncestor(ScopingNode.class).accept(nodeBuilder);
        return nodeBuilder.result;
    }

    private void removeAndReparentNodesIn(ASTProperLoopConstructNode newLoop) {
        this.removeAndReparent(newLoop, newLoop.getLoopHeader());
        for (IExecutionPartConstruct stmt : newLoop.getBody()) {
            this.removeAndReparent(newLoop.getBody(), stmt);
        }
        this.removeAndReparent(newLoop, newLoop.getEndDoStmt());
    }

    private void removeAndReparent(Parser.IASTNode newParent, Parser.IASTNode stmt) {
        stmt.removeFromTree();
        stmt.setParent(newParent);
    }

    private class ASTProperLoopConstructBuilder
    extends ASTVisitorWithLoops {
        private ASTProperLoopConstructNode result = new ASTProperLoopConstructNode();
        private boolean loopHeaderFound = false;

        public ASTProperLoopConstructBuilder(ASTLabelDoStmtNode loopHeader) {
            this.result.loopHeader = loopHeader;
        }

        public void visitASTLabelDoStmtNode(ASTLabelDoStmtNode node) {
            if (node == this.result.loopHeader) {
                this.loopHeaderFound = true;
            }
            this.traverseChildren(node);
        }

        public void visitIExecutionPartConstruct(IExecutionPartConstruct node) {
            if (this.shouldBeInLoopBody(node)) {
                this.result.body.add(node);
            }
        }

        public void visitIExecutableConstruct(IExecutableConstruct node) {
            this.visitIExecutionPartConstruct(node);
        }

        public void visitIActionStmt(IActionStmt node) {
            this.visitIExecutionPartConstruct(node);
        }

        public void visitIObsoleteActionStmt(IObsoleteActionStmt node) {
            this.visitIExecutionPartConstruct(node);
        }

        private boolean shouldBeInLoopBody(IExecutionPartConstruct node) {
            return this.loopHeaderFound && !this.endDoStmtFound() && !this.isLoopHeader(node) && this.isCurrentlySiblingOfLoopHeader(node);
        }

        private boolean isCurrentlySiblingOfLoopHeader(IExecutionPartConstruct node) {
            Parser.IASTNode doConstructNode = this.result.loopHeader.getParent();
            return node.getParent() == doConstructNode.getParent();
        }

        private boolean isLoopHeader(IExecutionPartConstruct node) {
            return node == this.result.loopHeader || node == this.result.loopHeader.getParent();
        }

        public void visitASTEndDoStmtNode(ASTEndDoStmtNode node) {
            if (this.loopHeaderFound && !this.endDoStmtFound() && !(node.getParent() instanceof ASTProperLoopConstructNode)) {
                this.result.endDoStmt = node;
            }
            this.traverseChildren(node);
        }

        private boolean endDoStmtFound() {
            return this.result.endDoStmt != null;
        }

        public void visitASTProperLoopConstructNode(ASTProperLoopConstructNode node) {
        }
    }
}

