/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.File;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.IPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.IToken;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.util.OffsetLength;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Token
implements IToken,
Parser.IASTNode {
    protected Terminal terminal = null;
    protected String whiteBefore = "";
    protected String text = "";
    protected String whiteAfter = "";
    protected IPreprocessorReplacement preprocessorDirective = null;
    protected IFile ifile = null;
    protected File javaFile = null;
    protected int line = -1;
    protected int col = -1;
    protected int fileOffset = -1;
    protected int streamOffset = -1;
    protected int length = -1;
    protected PhotranTokenRef tokenRef = null;
    private Parser.IASTNode parent = null;

    public Token(Terminal terminal, String whiteBefore, String tokenText, String whiteAfter) {
        this.terminal = terminal;
        this.whiteBefore = whiteBefore == null ? "" : whiteBefore;
        this.text = tokenText == null ? "" : tokenText;
        this.whiteAfter = whiteAfter == null ? "" : whiteAfter;
    }

    public Token(Terminal terminal, String tokenText) {
        this(terminal, null, tokenText, null);
    }

    protected Token(Token copyFrom) {
        this.terminal = copyFrom.terminal;
        this.whiteBefore = copyFrom.whiteBefore;
        this.text = copyFrom.text;
        this.whiteAfter = copyFrom.whiteAfter;
        this.preprocessorDirective = copyFrom.preprocessorDirective;
        this.ifile = copyFrom.ifile;
        this.javaFile = copyFrom.javaFile;
        this.line = copyFrom.line;
        this.col = copyFrom.col;
        this.fileOffset = copyFrom.fileOffset;
        this.streamOffset = copyFrom.streamOffset;
        this.length = copyFrom.length;
        this.tokenRef = copyFrom.tokenRef;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(Terminal value) {
        this.terminal = value;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value == null ? "" : value;
    }

    public String getWhiteBefore() {
        return this.whiteBefore;
    }

    public void setWhiteBefore(String value) {
        this.whiteBefore = value == null ? "" : value;
    }

    public String getWhiteAfter() {
        return this.whiteAfter;
    }

    public void setWhiteAfter(String value) {
        this.whiteAfter = value == null ? "" : value;
    }

    public IPreprocessorReplacement getPreprocessorDirective() {
        return this.preprocessorDirective;
    }

    public void setPreprocessorDirective(IPreprocessorReplacement preprocessorDirective) {
        this.preprocessorDirective = preprocessorDirective;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public String getFilenameToDisplayToUser() {
        if (this.ifile != null) {
            return this.ifile.getFullPath().toOSString();
        }
        if (this.javaFile != null) {
            return this.javaFile.getAbsolutePath();
        }
        return null;
    }

    public IFile getIFile() {
        return this.ifile;
    }

    public File getJavaFile() {
        return this.javaFile;
    }

    public void setFile(IFile file) {
        this.ifile = file;
        IPath location = file == null ? null : file.getLocation();
        this.javaFile = location == null ? null : location.toFile();
    }

    public void setFile(File file) {
        this.ifile = null;
        this.javaFile = file;
    }

    public int getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(int fileOffset) {
        this.fileOffset = fileOffset;
    }

    public int getStreamOffset() {
        return this.streamOffset;
    }

    public void setStreamOffset(int streamOffset) {
        this.streamOffset = streamOffset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean containsFileOffset(int offset) {
        return OffsetLength.contains((int)this.fileOffset, (int)this.length, (int)offset, (int)0);
    }

    public boolean containsFileOffset(OffsetLength other) {
        return OffsetLength.contains((int)this.fileOffset, (int)this.length, (OffsetLength)other);
    }

    public boolean isOnOrAfterFileOffset(int targetOffset) {
        return this.fileOffset >= targetOffset;
    }

    public boolean containsStreamOffset(OffsetLength other) {
        return OffsetLength.contains((int)this.streamOffset, (int)this.length, (OffsetLength)other);
    }

    public boolean isOnOrAfterStreamOffset(int targetOffset) {
        return this.streamOffset >= targetOffset;
    }

    @Override
    public Parser.IASTNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Parser.IASTNode parent) {
        this.parent = parent;
    }

    @Override
    public void accept(Parser.IASTVisitor visitor) {
        visitor.visitToken(this);
    }

    @Override
    public Token findFirstToken() {
        return this;
    }

    @Override
    public Token findLastToken() {
        return this;
    }

    @Override
    public <T extends Parser.IASTNode> T findNearestAncestor(Class<T> targetClass) {
        return Parser.ASTNodeUtil.findNearestAncestor(this, targetClass);
    }

    @Override
    public Iterable<? extends Parser.IASTNode> getChildren() {
        return new LinkedList();
    }

    @Override
    public boolean isFirstChildInList() {
        return Parser.ASTNodeUtil.isFirstChildInList(this);
    }

    @Override
    public void replaceChild(Parser.IASTNode node, Parser.IASTNode withNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeFromTree() {
        Parser.ASTNodeUtil.removeFromTree(this);
    }

    @Override
    public void replaceWith(Parser.IASTNode newNode) {
        Parser.ASTNodeUtil.replaceWith((Parser.IASTNode)this, newNode);
    }

    @Override
    public void replaceWith(String string) {
        Parser.ASTNodeUtil.replaceWith((Parser.IASTNode)this, string);
    }

    @Override
    public Object clone() {
        return new Token(this);
    }

    public String getDescription() {
        return String.valueOf(this.terminal.toString()) + ": \"" + this.text + "\"";
    }

    @Override
    public IPreprocessorReplacement printOn(PrintStream out, IPreprocessorReplacement currentPreprocessorDirective) {
        if (this.preprocessorDirective != currentPreprocessorDirective) {
            if (this.preprocessorDirective != null) {
                out.print(this.whiteBefore);
                out.print(this.preprocessorDirective);
            }
            currentPreprocessorDirective = this.preprocessorDirective;
        }
        if (currentPreprocessorDirective == null && this.preprocessorDirective == null) {
            out.print(this.whiteBefore);
            out.print(this.text);
            out.print(this.whiteAfter);
        }
        return currentPreprocessorDirective;
    }

    public String toString() {
        return this.terminal + ": " + this.text.replace("\n", "\\n").replace("\r", "\\r");
    }

    public PhotranTokenRef getTokenRef() {
        if (this.tokenRef == null) {
            this.tokenRef = new PhotranTokenRef(this.ifile, this.fileOffset, this.length);
        }
        return this.tokenRef;
    }

    public ScopingNode getEnclosingScope() {
        return ScopingNode.getEnclosingScope(this);
    }

    public ScopingNode getLocalScope() {
        return ScopingNode.getLocalScope(this);
    }

    public List<PhotranTokenRef> manuallyResolveBinding() {
        return this.getEnclosingScope().manuallyResolve(this);
    }

    public List<PhotranTokenRef> manuallyResolveBindingNoImplicits() {
        return this.getEnclosingScope().manuallyResolveNoImplicits(this);
    }

    public ScopingNode findScopeDeclaringOrImporting(Definition definition) {
        return this.getEnclosingScope().findScopeDeclaringOrImporting(definition.getTokenRef().findToken());
    }

    public List<Definition> resolveBinding() {
        LinkedList<Definition> result = new LinkedList<Definition>();
        Definition def = PhotranVPG.getInstance().getDefinitionFor(this.getTokenRef());
        if (def != null) {
            result.add(def);
            return result;
        }
        for (VPGEdge edge : PhotranVPG.getDatabase().getOutgoingEdgesFrom(this.getTokenRef(), 2)) {
            def = PhotranVPG.getInstance().getDefinitionFor((PhotranTokenRef)edge.getSink());
            if (def == null) continue;
            result.add(def);
        }
        return result;
    }

    public boolean isIdentifier() {
        return this.getTerminal() == Terminal.T_IDENT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FakeToken
    extends Token {
        private ScopingNode scope;
        private FakeTokenRef tokenRef;

        public FakeToken(Token basedOn, String text) {
            super(basedOn);
            this.setText(text);
            this.scope = basedOn.getEnclosingScope();
            this.tokenRef = new FakeTokenRef(basedOn.getTokenRef(), text);
        }

        public FakeToken(ScopingNode scope, String text) {
            super(new Token(null, text));
            this.setText(text);
            this.scope = scope;
            this.tokenRef = new FakeTokenRef(text);
        }

        @Override
        public String getText() {
            return this.tokenRef.getText();
        }

        @Override
        public PhotranTokenRef getTokenRef() {
            return this.tokenRef;
        }

        @Override
        public List<PhotranTokenRef> manuallyResolveBinding() {
            return this.scope.manuallyResolve(this);
        }

        private static class FakeTokenRef
        extends PhotranTokenRef {
            private static final long serialVersionUID = 1L;
            private String text;

            public FakeTokenRef(PhotranTokenRef basedOn, String text) {
                super(basedOn);
                this.text = text;
            }

            public FakeTokenRef(String text) {
                this(new PhotranTokenRef("", -1, -1), text);
            }

            public String getText() {
                return this.text;
            }
        }
    }
}

