/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring.infrastructure;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.refactoring.infrastructure.AbstractFortranRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.refactorings.IResourceRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultipleFileFortranRefactoring
extends AbstractFortranRefactoring
implements IResourceRefactoring {
    protected List<IFile> selectedFiles = null;

    public void initialize(List<IFile> files) {
        assert (files != null && files.size() > 0);
        this.vpg = PhotranVPG.getInstance();
        this.selectedFiles = new LinkedList<IFile>();
        this.selectedFiles.addAll(files);
    }

    @Override
    protected RefactoringStatus getAbstractSyntaxTree(RefactoringStatus status) {
        return status;
    }

    @Override
    protected void ensureProjectHasRefactoringEnabled(RefactoringStatus status) throws AbstractFortranRefactoring.PreconditionFailure {
        if (PhotranVPG.inTestingMode()) {
            return;
        }
        HashSet<IFile> filesToBeRemoved = new HashSet<IFile>();
        for (IFile f : this.selectedFiles) {
            if (PhotranVPG.getInstance().doesProjectHaveRefactoringEnabled(f)) continue;
            status.addWarning("Please enable analysis and refactoring in the project " + f.getProject().getName() + " properties.");
            filesToBeRemoved.add(f);
        }
        this.selectedFiles.removeAll(filesToBeRemoved);
    }

    protected void removeFixedFormFilesFrom(Collection<IFile> files, RefactoringStatus status) {
        HashSet<IFile> filesToRemove = new HashSet<IFile>();
        for (IFile file : files) {
            if (filesToRemove.contains(file) || !PhotranVPG.hasFixedFormContentType(file)) continue;
            status.addError("The fixed form file " + file.getName() + " will not be refactored.");
            filesToRemove.add(file);
        }
        files.removeAll(filesToRemove);
    }
}

