/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.debug.sdm.ui.messages.Messages;
import org.eclipse.ptp.debug.ui.PreferencesAdapter;
import org.eclipse.ptp.ui.preferences.AbstractPreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SDMPreferencePage
extends AbstractPreferencePage {
    private Text sdmBackendPathText = null;
    private Text sdmArgsText = null;
    private Combo sdmBackendCombo = null;
    private Button debugEnabledButton;
    private Button debugStartupButton;
    private Button debugMessagesButton;
    private Button debugRoutingButton;
    private Button debugServerButton;
    private Button debugBackendButton;
    private Button debugProtocolButton;
    private Button debugMasterEnabledButton;
    private Button debugMasterTraceButton;
    private Button debugMasterTraceMoreButton;
    private Button debugMasterOutputButton;
    private boolean debugEnabled = false;
    private int debugLevel = 0;
    private boolean debugMasterEnabled = false;
    private int debugMasterLevel = 0;
    protected WidgetListener listener = new WidgetListener();

    public SDMPreferencePage() {
        this.setPreferenceStore((IPreferenceStore)new PreferencesAdapter(SDMDebugCorePlugin.getDefault().getPluginPreferences()));
        this.setDescription(Messages.SDMPreferencePage_0);
    }

    public boolean isValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.sdmArgsText.setText(store.getDefaultString(SDMPreferenceConstants.SDM_DEBUGGER_ARGS));
        this.sdmBackendCombo.select(this.sdmBackendCombo.indexOf(store.getDefaultString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE)));
        this.sdmBackendPathText.setText(store.getDefaultString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_PATH));
        this.debugEnabled = false;
        this.debugLevel = 0;
        this.debugMasterEnabled = false;
        this.debugMasterLevel = 0;
        this.updateDebugButtons();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        SDMDebugCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setValid(this.isValid());
    }

    private void handleSDMComboSelected() {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createSpacer(composite, 1);
        this.createSDMSetting(composite);
        this.setValues();
        return composite;
    }

    protected void createSDMSetting(Composite parent) {
        Composite group = this.createGroupComposite(parent, 1, false, Messages.SDMPreferencePage_1);
        Composite comp = this.createComposite(group, 2);
        GridData gd = new GridData(768);
        new Label(comp, 0).setText(Messages.SDMPreferencePage_2);
        this.sdmBackendCombo = new Combo(comp, 8);
        this.sdmBackendCombo.setLayoutData((Object)gd);
        this.sdmBackendCombo.setItems(SDMPreferenceConstants.SDM_DEBUGGER_BACKENDS);
        this.sdmBackendCombo.addSelectionListener((SelectionListener)this.listener);
        new Label(comp, 0).setText(Messages.SDMPreferencePage_3);
        this.sdmBackendPathText = new Text(comp, 2052);
        this.sdmBackendPathText.setLayoutData((Object)gd);
        this.sdmBackendPathText.addModifyListener((ModifyListener)this.listener);
        new Label(comp, 0).setText(Messages.SDMPreferencePage_4);
        this.sdmArgsText = new Text(comp, 2052);
        this.sdmArgsText.setLayoutData((Object)gd);
        this.sdmArgsText.addModifyListener((ModifyListener)this.listener);
        Composite debugGroup = this.createGroupComposite(parent, 2, false, Messages.SDMPreferencePage_5);
        Composite sdmDebugComp = this.createComposite(debugGroup, 1);
        gd = new GridData();
        gd.verticalAlignment = 128;
        sdmDebugComp.setLayoutData((Object)gd);
        this.debugEnabledButton = new Button(sdmDebugComp, 32);
        this.debugEnabledButton.setText(Messages.SDMPreferencePage_6);
        this.debugEnabledButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SDMPreferencePage.this.debugEnabled = SDMPreferencePage.this.debugEnabledButton.getSelection();
                SDMPreferencePage.this.updateDebugButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.debugStartupButton = new Button(sdmDebugComp, 32);
        this.debugStartupButton.setText(Messages.SDMPreferencePage_7);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.debugStartupButton.setLayoutData((Object)gd);
        this.debugStartupButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SDMPreferencePage.this.debugStartupButton.getSelection()) {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel | 1;
                } else {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel & 0xFFFFFFFE;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.debugMessagesButton = new Button(sdmDebugComp, 32);
        this.debugMessagesButton.setText(Messages.SDMPreferencePage_8);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.debugMessagesButton.setLayoutData((Object)gd);
        this.debugMessagesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SDMPreferencePage.this.debugMessagesButton.getSelection()) {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel | 2;
                } else {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel & 0xFFFFFFFD;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.debugRoutingButton = new Button(sdmDebugComp, 32);
        this.debugRoutingButton.setText(Messages.SDMPreferencePage_9);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.debugRoutingButton.setLayoutData((Object)gd);
        this.debugRoutingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SDMPreferencePage.this.debugRoutingButton.getSelection()) {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel | 4;
                } else {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel & 0xFFFFFFFB;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.debugServerButton = new Button(sdmDebugComp, 32);
        this.debugServerButton.setText(Messages.SDMPreferencePage_10);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.debugServerButton.setLayoutData((Object)gd);
        this.debugServerButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SDMPreferencePage.this.debugServerButton.getSelection()) {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel | 8;
                } else {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel & 0xFFFFFFF7;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.debugBackendButton = new Button(sdmDebugComp, 32);
        this.debugBackendButton.setText(Messages.SDMPreferencePage_11);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.debugBackendButton.setLayoutData((Object)gd);
        this.debugBackendButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SDMPreferencePage.this.debugBackendButton.getSelection()) {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel | 0x10;
                } else {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel & 0xFFFFFFEF;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.debugProtocolButton = new Button(sdmDebugComp, 32);
        this.debugProtocolButton.setText(Messages.SDMPreferencePage_12);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.debugProtocolButton.setLayoutData((Object)gd);
        this.debugProtocolButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SDMPreferencePage.this.debugProtocolButton.getSelection()) {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel | 0x20;
                } else {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugLevel = sDMPreferencePage.debugLevel & 0xFFFFFFDF;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite masterDebugComp = this.createComposite(debugGroup, 1);
        gd = new GridData();
        gd.verticalAlignment = 128;
        masterDebugComp.setLayoutData((Object)gd);
        this.debugMasterEnabledButton = new Button(masterDebugComp, 32);
        this.debugMasterEnabledButton.setText(Messages.SDMPreferencePage_13);
        this.debugMasterEnabledButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SDMPreferencePage.this.debugMasterEnabled = SDMPreferencePage.this.debugMasterEnabledButton.getSelection();
                SDMPreferencePage.this.updateDebugButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.debugMasterTraceButton = new Button(masterDebugComp, 32);
        this.debugMasterTraceButton.setText(Messages.SDMPreferencePage_14);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.debugMasterTraceButton.setLayoutData((Object)gd);
        this.debugMasterTraceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SDMPreferencePage.this.debugMasterTraceButton.getSelection()) {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugMasterLevel = sDMPreferencePage.debugMasterLevel | 1;
                } else {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugMasterLevel = sDMPreferencePage.debugMasterLevel & 0xFFFFFFFE;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.debugMasterTraceMoreButton = new Button(masterDebugComp, 32);
        this.debugMasterTraceMoreButton.setText(Messages.SDMPreferencePage_15);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.debugMasterTraceMoreButton.setLayoutData((Object)gd);
        this.debugMasterTraceMoreButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SDMPreferencePage.this.debugMasterTraceMoreButton.getSelection()) {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugMasterLevel = sDMPreferencePage.debugMasterLevel | 2;
                } else {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugMasterLevel = sDMPreferencePage.debugMasterLevel & 0xFFFFFFFD;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.debugMasterOutputButton = new Button(masterDebugComp, 32);
        this.debugMasterOutputButton.setText(Messages.SDMPreferencePage_16);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.debugMasterOutputButton.setLayoutData((Object)gd);
        this.debugMasterOutputButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SDMPreferencePage.this.debugMasterOutputButton.getSelection()) {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugMasterLevel = sDMPreferencePage.debugMasterLevel | 3;
                } else {
                    SDMPreferencePage sDMPreferencePage = SDMPreferencePage.this;
                    sDMPreferencePage.debugMasterLevel = sDMPreferencePage.debugMasterLevel & 0xFFFFFFFC;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.updateDebugButtons();
        Dialog.applyDialogFont((Control)parent);
    }

    private void updateDebugButtons() {
        this.debugEnabledButton.setSelection(this.debugEnabled);
        this.debugStartupButton.setEnabled(this.debugEnabled);
        this.debugMessagesButton.setEnabled(this.debugEnabled);
        this.debugRoutingButton.setEnabled(this.debugEnabled);
        this.debugServerButton.setEnabled(this.debugEnabled);
        this.debugBackendButton.setEnabled(this.debugEnabled);
        this.debugProtocolButton.setEnabled(this.debugEnabled);
        this.debugStartupButton.setSelection((this.debugLevel & 1) == 1);
        this.debugMessagesButton.setSelection((this.debugLevel & 2) == 2);
        this.debugRoutingButton.setSelection((this.debugLevel & 4) == 4);
        this.debugServerButton.setSelection((this.debugLevel & 8) == 8);
        this.debugBackendButton.setSelection((this.debugLevel & 0x10) == 16);
        this.debugProtocolButton.setSelection((this.debugLevel & 0x20) == 32);
        this.debugMasterEnabledButton.setSelection(this.debugMasterEnabled);
        this.debugMasterTraceButton.setEnabled(this.debugMasterEnabled);
        this.debugMasterTraceMoreButton.setEnabled(this.debugMasterEnabled);
        this.debugMasterOutputButton.setEnabled(this.debugMasterEnabled);
        this.debugMasterTraceButton.setSelection((this.debugMasterLevel & 1) == 1);
        this.debugMasterTraceMoreButton.setSelection((this.debugMasterLevel & 2) == 2);
        this.debugMasterOutputButton.setSelection((this.debugMasterLevel & 3) == 3);
    }

    protected void setValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.sdmArgsText.setText(store.getString(SDMPreferenceConstants.SDM_DEBUGGER_ARGS));
        this.sdmBackendCombo.select(this.sdmBackendCombo.indexOf(store.getString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE)));
        this.sdmBackendPathText.setText(store.getString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_PATH));
        this.debugEnabled = store.getBoolean(SDMPreferenceConstants.SDM_DEBUG_ENABLED);
        this.debugLevel = store.getInt(SDMPreferenceConstants.SDM_DEBUG_LEVEL);
        this.debugMasterEnabled = store.getBoolean(SDMPreferenceConstants.SDM_DEBUG_MASTER_ENABLED);
        this.debugMasterLevel = store.getInt(SDMPreferenceConstants.SDM_DEBUG_MASTER_LEVEL);
        this.updateDebugButtons();
    }

    protected void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(SDMPreferenceConstants.SDM_DEBUGGER_ARGS, this.sdmArgsText.getText());
        store.setValue(SDMPreferenceConstants.SDM_DEBUG_ENABLED, this.debugEnabled);
        store.setValue(SDMPreferenceConstants.SDM_DEBUG_LEVEL, this.debugLevel);
        store.setValue(SDMPreferenceConstants.SDM_DEBUG_MASTER_ENABLED, this.debugMasterEnabled);
        store.setValue(SDMPreferenceConstants.SDM_DEBUG_MASTER_LEVEL, this.debugMasterLevel);
        store.setValue(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE, this.sdmBackendCombo.getItem(this.sdmBackendCombo.getSelectionIndex()));
        store.setValue(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_PATH, this.sdmBackendPathText.getText());
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            SDMPreferencePage.this.setValid(SDMPreferencePage.this.isValid());
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == SDMPreferencePage.this.sdmBackendCombo) {
                SDMPreferencePage.this.handleSDMComboSelected();
            }
        }
    }
}

