/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class CASTDesignatedInitializer
extends ASTNode
implements ICASTDesignatedInitializer {
    private IASTInitializer rhs;
    private ICASTDesignator[] designators = null;
    int designatorsPos = -1;

    public CASTDesignatedInitializer() {
    }

    public CASTDesignatedInitializer(IASTInitializer operandInitializer) {
        this.setOperandInitializer(operandInitializer);
    }

    public CASTDesignatedInitializer copy() {
        CASTDesignatedInitializer copy = new CASTDesignatedInitializer(this.rhs == null ? null : this.rhs.copy());
        ICASTDesignator[] iCASTDesignatorArray = this.getDesignators();
        int n = iCASTDesignatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICASTDesignator designator = iCASTDesignatorArray[n2];
            copy.addDesignator(designator == null ? null : designator.copy());
            ++n2;
        }
        copy.setOffsetAndLength(this);
        return copy;
    }

    public void addDesignator(ICASTDesignator designator) {
        this.assertNotFrozen();
        if (designator != null) {
            designator.setParent(this);
            designator.setPropertyInParent(DESIGNATOR);
            this.designators = (ICASTDesignator[])ArrayUtil.append(ICASTDesignator.class, this.designators, ++this.designatorsPos, designator);
        }
    }

    public ICASTDesignator[] getDesignators() {
        if (this.designators == null) {
            return ICASTDesignatedInitializer.EMPTY_DESIGNATOR_ARRAY;
        }
        this.designators = (ICASTDesignator[])ArrayUtil.removeNullsAfter(ICASTDesignator.class, this.designators, this.designatorsPos);
        return this.designators;
    }

    public IASTInitializer getOperandInitializer() {
        return this.rhs;
    }

    public void setOperandInitializer(IASTInitializer rhs) {
        this.assertNotFrozen();
        this.rhs = rhs;
        if (rhs != null) {
            rhs.setParent(this);
            rhs.setPropertyInParent(OPERAND);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitInitializers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        ICASTDesignator[] ds = this.getDesignators();
        int i = 0;
        while (i < ds.length) {
            if (!ds[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (this.rhs != null && !this.rhs.accept(action)) {
            return false;
        }
        if (action.shouldVisitInitializers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

