/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.index.CPPReferenceTypeClone;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPReferenceType
extends PDOMNode
implements ICPPReferenceType,
ITypeContainer,
IIndexType {
    private static final int TYPE = 8;
    protected static final int RECORD_SIZE = 12;
    private IType targetType;

    public PDOMCPPReferenceType(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public PDOMCPPReferenceType(PDOMLinkage linkage, PDOMNode parent, ICPPReferenceType type) throws CoreException {
        super(linkage, parent);
        Database db = this.getDB();
        try {
            long typeRec = 0L;
            if (type != null) {
                IType targetType = type.getType();
                PDOMNode targetTypeNode = this.getLinkage().addType(this, targetType);
                if (targetTypeNode != null) {
                    typeRec = targetTypeNode.getRecord();
                }
            }
            db.putRecPtr(this.record + 8L, typeRec);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus((Throwable)e));
        }
    }

    protected int getRecordSize() {
        return 12;
    }

    public int getNodeType() {
        return 20;
    }

    public IType getType() {
        if (this.targetType == null) {
            this.targetType = this.readType();
        }
        return this.targetType;
    }

    private IType readType() {
        try {
            PDOMNode node = this.getLinkage().getNode(this.getDB().getRecPtr(this.record + 8L));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public boolean isSameType(IType type) {
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (!(type instanceof ICPPReferenceType)) {
            return false;
        }
        ICPPReferenceType rhs = (ICPPReferenceType)type;
        try {
            IType type1 = this.getType();
            if (type1 != null) {
                return type1.isSameType(rhs.getType());
            }
        }
        catch (DOMException dOMException) {}
        return false;
    }

    public void setType(IType type) {
        throw new PDOMNotImplementedError();
    }

    public Object clone() {
        return new CPPReferenceTypeClone(this);
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        linkage.deleteType(this.getType(), this.record);
        super.delete(linkage);
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }
}

