/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTypedefSpecialization;
import org.eclipse.cdt.internal.core.index.CPPTypedefClone;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPTypedefSpecialization
extends PDOMCPPSpecialization
implements ITypedef,
ITypeContainer,
IIndexType {
    private static final int TYPE = 40;
    protected static final int RECORD_SIZE = 44;

    public PDOMCPPTypedefSpecialization(PDOMLinkage linkage, PDOMNode parent, ITypedef typedef, PDOMBinding specialized) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)typedef), specialized);
        try {
            if (typedef instanceof CPPTypedefSpecialization && ((CPPTypedefSpecialization)typedef).incResolutionDepth(1) > 5) {
                return;
            }
            try {
                IType type = typedef.getType();
                PDOMNode typeNode = parent.getLinkage().addType(this, type);
                if (typeNode != null) {
                    this.getDB().putRecPtr(this.record + 40L, typeNode.getRecord());
                }
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus((Throwable)e));
            }
        }
        finally {
            if (typedef instanceof CPPTypedefSpecialization) {
                ((CPPTypedefSpecialization)typedef).incResolutionDepth(-1);
            }
        }
    }

    public PDOMCPPTypedefSpecialization(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    protected int getRecordSize() {
        return 44;
    }

    public int getNodeType() {
        return 42;
    }

    public IType getType() throws DOMException {
        try {
            PDOMNode node = ((PDOMLinkage)this.getLinkage()).getNode(this.getDB().getRecPtr(this.record + 40L));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public boolean isSameType(IType o) {
        if (this.equals(o)) {
            return true;
        }
        if (o instanceof ITypedef) {
            try {
                IType t = this.getType();
                if (t != null) {
                    return t.isSameType(((ITypedef)o).getType());
                }
                return false;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        try {
            IType t = this.getType();
            if (t != null) {
                return t.isSameType(o);
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
        return false;
    }

    public void setType(IType type) {
        this.fail();
    }

    public Object clone() {
        return new CPPTypedefClone(this);
    }
}

