/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.SftpATTRS;
import java.util.Set;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.remotetools.internal.ssh.FileTools;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileAttributes;

class RemoteItem
implements IRemoteItem {
    protected String path;
    protected boolean isReadable;
    protected boolean isWritable;
    protected boolean isExecutable;
    protected boolean exist;
    protected FileTools fileTools;
    protected int userID;
    protected int permissions;
    protected long size;
    protected int accessTime;
    protected int modificationTime;
    protected int groupID;
    protected int changes;
    protected boolean isDirectory;
    protected final int PERMISSION = 1;
    protected final int MODIFICATION_TIME = 2;

    protected RemoteItem() {
    }

    RemoteItem(FileTools fileTools, String path) {
        this.fileTools = fileTools;
        this.path = path;
    }

    RemoteItem(FileTools fileTools, String path, SftpATTRS attrs) {
        this.fileTools = fileTools;
        this.path = path;
        RemoteFileAttributes remoteAttrs = new RemoteFileAttributes(attrs);
        this.parseAttrs(remoteAttrs);
    }

    public void commitAttributes() throws RemoteConnectionException, CancelException, RemoteOperationException {
        this.fileTools.test();
        if ((this.changes & 1) != 0) {
            this.fileTools.chmod(this.permissions, this.path, null);
            this.changes &= 0xFFFFFFFE;
        }
        if ((this.changes & 2) != 0) {
            this.fileTools.setMtime(this.path, this.modificationTime, null);
            this.changes &= 0xFFFFFFFD;
        }
    }

    public boolean exists() {
        return this.exist;
    }

    public long getAccessTime() {
        return (long)this.accessTime * 1000L;
    }

    public long getModificationTime() {
        return (long)this.modificationTime * 1000L;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isExecutable() {
        return this.isExecutable;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public void refreshAttributes() throws RemoteConnectionException, RemoteOperationException, CancelException {
        this.fileTools.test();
        RemoteFileAttributes attrs = this.fileTools.fetchRemoteAttr(this.path);
        this.parseAttrs(attrs);
    }

    public void setExecutable(boolean flag) {
        int oldPermissions = this.permissions;
        if (this.userID == this.fileTools.getCachedUserID()) {
            this.permissions = flag ? (this.permissions |= 0x40) : (this.permissions &= 0xFFFFFFBF);
        }
        if (this.fileTools.getCachedGroupIDSet().contains(new Integer(this.groupID))) {
            this.permissions = flag ? (this.permissions |= 8) : (this.permissions &= 0xFFFFFFF7);
        }
        this.permissions = flag ? (this.permissions |= 1) : (this.permissions &= 0xFFFFFFFE);
        if (oldPermissions != this.permissions) {
            this.changes |= 1;
        }
    }

    public void setModificationTime(long time) {
        int oldModificationTime = this.modificationTime;
        this.modificationTime = (int)(time / 1000L);
        if (oldModificationTime != this.modificationTime) {
            this.changes |= 2;
        }
    }

    public void setReadable(boolean flag) {
        Set<Integer> groupIDSet;
        int oldPermissions = this.permissions;
        if (this.userID == this.fileTools.getCachedUserID()) {
            this.permissions = flag ? (this.permissions |= 0x100) : (this.permissions &= 0xFFFFFEFF);
        }
        if ((groupIDSet = this.fileTools.getCachedGroupIDSet()).contains(new Integer(this.groupID))) {
            this.permissions = flag ? (this.permissions |= 0x20) : (this.permissions &= 0xFFFFFFDF);
        }
        this.permissions = flag ? (this.permissions |= 4) : (this.permissions &= 0xFFFFFFFB);
        if (oldPermissions != this.permissions) {
            this.changes |= 1;
        }
    }

    public void setWriteable(boolean flag) {
        Set<Integer> groupIDSet;
        int oldPermissions = this.permissions;
        if (this.userID == this.fileTools.getCachedUserID()) {
            this.permissions = flag ? (this.permissions |= 0x80) : (this.permissions &= 0xFFFFFF7F);
        }
        if ((groupIDSet = this.fileTools.getCachedGroupIDSet()).contains(new Integer(this.groupID))) {
            this.permissions = flag ? (this.permissions |= 0x10) : (this.permissions &= 0xFFFFFFEF);
        }
        this.permissions = flag ? (this.permissions |= 2) : (this.permissions &= 0xFFFFFFFD);
        if (oldPermissions != this.permissions) {
            this.changes |= 1;
        }
    }

    public String toString() {
        if (this.exist) {
            return String.valueOf(this.path) + (this.isDirectory ? "(d)" : "(f)");
        }
        return String.valueOf(this.path) + " does not exist";
    }

    private void parseAttrs(RemoteFileAttributes attrs) {
        Set<Integer> groupIDSet;
        if (attrs == null) {
            this.exist = false;
            return;
        }
        this.exist = true;
        this.changes = 0;
        assert (this.isDirectory == attrs.isDir());
        this.isDirectory = attrs.isDir();
        this.userID = attrs.getUId();
        this.groupID = attrs.getGId();
        this.permissions = attrs.getPermissions();
        this.isReadable = false;
        this.isWritable = false;
        this.isExecutable = false;
        if (this.userID == this.fileTools.getCachedUserID()) {
            if ((this.permissions & 0x100) != 0) {
                this.isReadable = true;
            }
            if ((this.permissions & 0x80) != 0) {
                this.isWritable = true;
            }
            if ((this.permissions & 0x40) != 0) {
                this.isExecutable = true;
            }
        }
        if ((groupIDSet = this.fileTools.getCachedGroupIDSet()).contains(new Integer(this.groupID))) {
            if ((this.permissions & 0x20) != 0) {
                this.isReadable = true;
            }
            if ((this.permissions & 0x10) != 0) {
                this.isWritable = true;
            }
            if ((this.permissions & 8) != 0) {
                this.isExecutable = true;
            }
        }
        if ((this.permissions & 4) != 0) {
            this.isReadable = true;
        }
        if ((this.permissions & 2) != 0) {
            this.isWritable = true;
        }
        if ((this.permissions & 1) != 0) {
            this.isExecutable = true;
        }
        this.size = attrs.getSize();
        this.accessTime = attrs.getATime();
        this.modificationTime = attrs.getMTime();
    }

    protected void copyAttributesFrom(RemoteItem other) {
        this.path = other.path;
        this.isReadable = other.isReadable;
        this.isWritable = other.isWritable;
        this.isExecutable = other.isExecutable;
        this.exist = other.exist;
        this.fileTools = other.fileTools;
        this.userID = other.userID;
        this.permissions = other.permissions;
        this.size = other.size;
        this.accessTime = other.accessTime;
        this.modificationTime = other.modificationTime;
        this.groupID = other.groupID;
        this.changes = other.changes;
        this.isDirectory = other.isDirectory;
    }
}

