/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.etfw.internal.BuildLaunchUtils;
import org.eclipse.ptp.etfw.toolopts.ToolApp;
import org.eclipse.ptp.etfw.toolopts.ToolIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ToolStep
extends Job
implements IToolLaunchConfigurationConstants {
    protected String projectLocation = null;
    protected String outputLocation = null;
    protected String projectBinary = null;
    protected String projectName = null;
    protected ICProject thisCProject = null;
    protected IProject thisProject = null;
    protected ILaunchConfiguration configuration = null;
    protected Map<String, String> IOMap = null;

    protected ToolStep(ILaunchConfiguration conf, String name) throws CoreException {
        super(name);
        this.configuration = conf;
        this.thisProject = ToolStep.getProject(this.configuration);
        this.thisCProject = CCorePlugin.getDefault().getCoreModel().create(this.thisProject);
        this.outputLocation = this.projectLocation = this.thisCProject.getResource().getLocation().toOSString();
        this.projectBinary = "unknown";
        this.projectName = "unknown";
        this.IOMap = new HashMap<String, String>();
    }

    public void setConfiguration(ILaunchConfiguration conf) {
        this.configuration = conf;
    }

    public ILaunchConfiguration getConfiguration() {
        return this.configuration;
    }

    protected static IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute(configuration.getAttribute("perf_project_name_tag_for_name_value", null), null);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    private String insertProjectValues(String tmp) {
        tmp = tmp.replaceAll("%%REPLACE_WITH_BUILD_DIR%%", this.outputLocation);
        tmp = tmp.replaceAll("%%REPLACE_WITH_PROJECT_ROOT_DIR%%", this.projectLocation);
        tmp = tmp.replaceAll("%%REPLACE_WITH_PROJECT_BINARY%%", this.projectBinary);
        tmp = tmp.replaceAll("%%REPLACE_WITH_PROJECT_NAME%%", this.projectName);
        return tmp;
    }

    protected List<String> getToolArgumentList(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        if (app == null) {
            return null;
        }
        List allargs = app.getArguments(configuration);
        int i = 0;
        while (i < allargs.size()) {
            String tmp = this.insertProjectValues((String)allargs.get(i));
            allargs.set(i, tmp);
            ++i;
        }
        String io = this.parseInput(app).trim();
        if (io.length() > 0) {
            allargs.add(io);
        }
        if ((io = this.parseOutput(app).trim()).length() > 0) {
            allargs.add(io);
        }
        return allargs;
    }

    protected String getToolArguments(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        List<String> argList = this.getToolArgumentList(app, configuration);
        String args = "";
        if (argList == null) {
            return args;
        }
        for (String a : argList) {
            args = String.valueOf(args) + a + " ";
        }
        return args;
    }

    protected Map<String, String> getToolEnvVars(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        if (app == null) {
            return null;
        }
        Map map = app.getEnvVars(configuration);
        for (Map.Entry entry : map.entrySet()) {
            String tmp = this.insertProjectValues((String)entry.getValue());
            entry.setValue(tmp);
        }
        return map;
    }

    private String parseInput(ToolApp app) {
        String input = "";
        String oneIn = "";
        if (app.inputArgs != null) {
            int i = 0;
            while (i < app.inputArgs.length) {
                oneIn = "";
                if (app.inputArgs[i].pathFlag != null) {
                    oneIn = String.valueOf(oneIn) + app.inputArgs[i].pathFlag + " ";
                }
                if (!this.IOMap.containsKey(app.inputArgs[i].ID)) {
                    return "";
                }
                input = String.valueOf(input) + this.IOMap.get(app.inputArgs[i].ID);
                ++i;
            }
        }
        return input;
    }

    private String parseOutput(ToolApp app) {
        String output = "";
        if (app.outputArgs != null) {
            int i = 0;
            while (i < app.outputArgs.length) {
                if (app.outputArgs[i].pathFlag != null) {
                    output = String.valueOf(output) + app.outputArgs[i].pathFlag + " ";
                }
                output = this.IOMap.containsKey(app.outputArgs[i].ID) ? String.valueOf(output) + this.IOMap.get(app.outputArgs[i].ID) : String.valueOf(output) + this.createOutputPath(app.outputArgs[i]);
                ++i;
            }
        }
        return output;
    }

    private String createOutputPath(ToolIO IO) {
        String opath = String.valueOf(this.projectLocation) + File.separator + IO.ID + File.separator + BuildLaunchUtils.getNow();
        File ofile = new File(opath);
        ofile.mkdirs();
        this.IOMap.put(IO.ID, opath);
        return opath;
    }

    protected static String getToolExecutable(ToolApp app) {
        String command = app.toolCommand;
        String toolPath = BuildLaunchUtils.getToolPath(app.toolGroup);
        if (toolPath != null && toolPath.length() > 0) {
            command = String.valueOf(toolPath) + File.separator + command;
        }
        return command;
    }

    protected String getToolCommand(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        String command = ToolStep.getToolExecutable(app);
        if (command == null) {
            return null;
        }
        return String.valueOf(command) + " " + this.getToolArguments(app, configuration);
    }

    protected List<String> getToolCommandList(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        String exec = ToolStep.getToolExecutable(app);
        if (exec == null) {
            return null;
        }
        command.add(exec.trim());
        List<String> args = this.getToolArgumentList(app, configuration);
        if (args == null) {
            return command;
        }
        command.addAll(args);
        return command;
    }
}

