/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.TokenList;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.util.IterableWrapper;

public class FortranAST
implements IFortranAST {
    private IFile file;
    private ASTExecutableProgramNode root;
    private TokenList tokenList;

    public FortranAST(IFile file, ASTExecutableProgramNode root, TokenList tokenList) {
        this.file = file;
        this.root = root;
        this.tokenList = tokenList;
        for (Token token : new IterableWrapper(tokenList)) {
            if (token.getIFile() != null) continue;
            token.setFile(file);
        }
    }

    public void accept(Parser.IASTVisitor visitor) {
        this.root.accept(visitor);
    }

    public IFile getFile() {
        return this.file;
    }

    public ASTExecutableProgramNode getRoot() {
        return this.root;
    }

    public Iterator iterator() {
        return this.tokenList.iterator();
    }

    public Token findTokenByStreamOffsetLength(int offset, int length) {
        return this.tokenList.findStreamOffsetLength(offset, length);
    }

    public Token findTokenByFileOffsetLength(IFile file, int offset, int length) {
        int i = 0;
        while (i < this.tokenList.size()) {
            Token token = this.tokenList.get(i);
            if (token.getIFile() != null && token.getIFile().hashCode() == file.hashCode() && token.getIFile().equals((Object)file) && token.getFileOffset() == offset && token.getLength() == length) {
                return token;
            }
            ++i;
        }
        return null;
    }

    public Token findFirstTokenOnLine(int line) {
        return this.tokenList.findFirstTokenOnLine(line);
    }

    public Token findLastTokenOnLine(int line) {
        return this.tokenList.findLastTokenOnLine(line);
    }
}

