/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.serviceproviders.RemoteCIndexServiceProvider;
import org.eclipse.ptp.rdt.ui.wizards.IIndexFilePathChangeListener;
import org.eclipse.ptp.rdt.ui.wizards.IndexFileLocationWidget;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;
import org.eclipse.ptp.services.ui.IServiceProviderContributor;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.ui.wizards.newconnection.RSEDefaultNewConnectionWizard;
import org.eclipse.rse.ui.wizards.newconnection.RSEMainNewConnectionWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RemoteCIndexServiceProviderContributer
implements IServiceProviderContributor {
    private RemoteCIndexServiceProvider fProvider;
    private Map<Integer, IHost> hostComboIndexToHostMap = new HashMap<Integer, IHost>();
    private IHost selectedHost;
    private String configPath;

    public void configureServiceProvider(IServiceProvider sp, final Composite container) {
        if (sp instanceof IServiceProviderWorkingCopy) {
            sp = ((IServiceProviderWorkingCopy)sp).getOriginal();
        }
        if (!(sp instanceof RemoteCIndexServiceProvider)) {
            throw new IllegalArgumentException();
        }
        this.fProvider = (RemoteCIndexServiceProvider)sp;
        container.setLayout((Layout)new GridLayout(1, false));
        Group connectionGroup = new Group(container, 0);
        connectionGroup.setText("Connection");
        connectionGroup.setLayout((Layout)new GridLayout(1, false));
        connectionGroup.setLayoutData((Object)new GridData(768));
        Label hostLabel = new Label((Composite)connectionGroup, 16384);
        hostLabel.setLayoutData((Object)new GridData());
        hostLabel.setText(Messages.getString("HostSelectionDialog_0"));
        final Combo hostCombo = new Combo((Composite)connectionGroup, 12);
        hostCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        IHost hostSelected = this.fProvider.getHost();
        IHost[] hosts = SystemStartHere.getConnections();
        int toSelect = 0;
        int k = 0;
        while (k < hosts.length) {
            hostCombo.add(hosts[k].getAliasName(), k);
            this.hostComboIndexToHostMap.put(k, hosts[k]);
            if (hostSelected != null && hostSelected.getAliasName().compareTo(hosts[k].getAliasName()) == 0) {
                toSelect = k;
            }
            ++k;
        }
        hostCombo.select(toSelect);
        this.selectedHost = this.hostComboIndexToHostMap.get(toSelect);
        Button newConnectionButton = new Button((Composite)connectionGroup, 8);
        newConnectionButton.setLayoutData((Object)new GridData());
        newConnectionButton.setText(Messages.getString("HostSelectionDialog.0"));
        newConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RSEMainNewConnectionWizard wizard = new RSEMainNewConnectionWizard();
                WizardDialog wizardDialog = new WizardDialog(container.getShell(), (IWizard)wizard);
                wizardDialog.open();
                IWizard actualWizard = wizard.getSelectedWizard();
                if (actualWizard instanceof RSEDefaultNewConnectionWizard) {
                    IHost host = ((RSEDefaultNewConnectionWizard)actualWizard).getCreatedHost();
                    int index = hostCombo.getItemCount() - 1;
                    hostCombo.add(host.getAliasName(), index);
                    RemoteCIndexServiceProviderContributer.this.hostComboIndexToHostMap.put(index, host);
                    hostCombo.select(index);
                    RemoteCIndexServiceProviderContributer.this.selectedHost = host;
                    RemoteCIndexServiceProviderContributer.this.updateProvider();
                }
            }
        });
        this.configPath = this.fProvider.getIndexLocation();
        if (this.fProvider.isConfigured() && this.configPath == null) {
            this.configPath = "";
        }
        final IndexFileLocationWidget scopeWidget = new IndexFileLocationWidget(container, 0, this.selectedHost, this.configPath);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        scopeWidget.setLayoutData(data);
        scopeWidget.addPathListener(new IIndexFilePathChangeListener(){

            public void pathChanged(String newPath) {
                RemoteCIndexServiceProviderContributer.this.configPath = newPath;
                RemoteCIndexServiceProviderContributer.this.updateProvider();
            }
        });
        hostCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = hostCombo.getSelectionIndex();
                RemoteCIndexServiceProviderContributer.this.selectedHost = (IHost)RemoteCIndexServiceProviderContributer.this.hostComboIndexToHostMap.get(selectionIndex);
                scopeWidget.setHost(RemoteCIndexServiceProviderContributer.this.selectedHost);
                RemoteCIndexServiceProviderContributer.this.updateProvider();
            }
        });
        this.updateProvider();
    }

    private void updateProvider() {
        this.fProvider.setConnection(this.selectedHost, this.getDStoreConnectorService(this.selectedHost));
        this.fProvider.setIndexLocation(this.configPath);
        this.fProvider.setConfigured(true);
    }

    private IConnectorService getDStoreConnectorService(IHost host) {
        IConnectorService[] iConnectorServiceArray = host.getConnectorServices();
        int n = iConnectorServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService cs = iConnectorServiceArray[n2];
            if (cs instanceof DStoreConnectorService) {
                return cs;
            }
            ++n2;
        }
        return null;
    }

    public IWizard getWizard(IServiceProvider provider, IWizardPage page) {
        return null;
    }

    public WizardPage[] getWizardPages(IWizard wizard, IServiceProvider provider) {
        return null;
    }
}

