/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.rse.core.RSEConnection;

public class RSEFileManager
implements IRemoteFileManager {
    private final RSEConnection fConnection;

    public RSEFileManager(RSEConnection conn) {
        this.fConnection = conn;
    }

    public IFileStore getResource(String pathStr) {
        Path path = new Path(pathStr);
        if (!path.isAbsolute()) {
            path = new Path(this.fConnection.getWorkingDirectory()).append((IPath)path);
        }
        return this.fConnection.getFileSystem().getStore(this.toURI((IPath)path));
    }

    public String toPath(URI uri) {
        return uri.getPath();
    }

    public URI toURI(IPath path) {
        String authority = this.fConnection.getHost().getHostName();
        try {
            authority = URLEncoder.encode(authority, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        try {
            return new URI("rse", authority, path.makeAbsolute().toPortableString(), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public URI toURI(String path) {
        return this.toURI((IPath)new Path(path));
    }
}

