/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.rse.core.RSEConnection;
import org.eclipse.ptp.remote.rse.core.RSEFileManager;
import org.eclipse.ptp.remote.rse.core.RSEProcess;
import org.eclipse.ptp.remote.rse.core.messages.Messages;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSEProcessBuilder
extends AbstractRemoteProcessBuilder {
    private static final String EXIT_CMD = "exit";
    private static final String CMD_DELIMITER = ";";
    private final RSEConnection fConnection;
    private final RSEFileManager fFileMgr;
    private Map<String, String> fRemoteEnv = new HashMap<String, String>();

    public RSEProcessBuilder(IRemoteConnection conn, IRemoteFileManager fileMgr, List<String> command) {
        super(conn, command);
        this.fConnection = (RSEConnection)conn;
        this.fFileMgr = (RSEFileManager)fileMgr;
        this.fRemoteEnv = conn.getEnv();
    }

    public RSEProcessBuilder(IRemoteConnection conn, IRemoteFileManager fileMgr, String ... command) {
        this(conn, fileMgr, Arrays.asList(command));
    }

    public IFileStore directory() {
        IFileStore dir = super.directory();
        if (dir == null) {
            dir = this.fFileMgr.getResource(this.connection().getWorkingDirectory());
            this.directory(dir);
        }
        return dir;
    }

    private String[] getEnvironment() {
        String[] env = new String[this.fRemoteEnv.size()];
        int pos = 0;
        for (Map.Entry<String, String> entry : this.fRemoteEnv.entrySet()) {
            env[pos++] = String.valueOf(entry.getKey()) + "=" + entry.getValue();
        }
        return env;
    }

    public Map<String, String> environment() {
        return this.fRemoteEnv;
    }

    public IRemoteProcess start() throws IOException {
        List cmdArgs = this.command();
        if (cmdArgs.size() < 1) {
            throw new IndexOutOfBoundsException();
        }
        String remoteCmd = "";
        int i = 0;
        while (i < cmdArgs.size()) {
            if (i > 0) {
                remoteCmd = String.valueOf(remoteCmd) + " ";
            }
            remoteCmd = String.valueOf(remoteCmd) + this.spaceEscapify((String)cmdArgs.get(i));
            ++i;
        }
        remoteCmd = String.valueOf(remoteCmd) + ";exit";
        IShellService shellService = this.fConnection.getRemoteShellService();
        if (shellService == null) {
            throw new IOException(Messages.RSEProcessBuilder_0);
        }
        IHostShell hostShell = null;
        try {
            String initialDir = "";
            if (this.directory() != null) {
                initialDir = this.directory().toURI().getPath();
            }
            hostShell = shellService.runCommand(initialDir, remoteCmd, this.getEnvironment(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SystemMessageException e) {
            e.printStackTrace();
            return null;
        }
        return new RSEProcess(hostShell, this.redirectErrorStream());
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }
}

