/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.callhierarchy;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMessages;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.util.StatusLineHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.ICallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.ui.callhierarchy.RemoteCHViewPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class CallHierarchyUtil {
    private static boolean sIsJUnitTest = false;

    public static void open(final ICallHierarchyService service, final ITextEditor editor, ITextSelection sel) {
        IWorkingCopy inputCElement;
        if (editor != null && (inputCElement = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput())) != null) {
            final int selectionStart = sel.getOffset();
            final int selectionLength = sel.getLength();
            final ICProject project = inputCElement.getCProject();
            final Display display = Display.getCurrent();
            Job job = new Job(CHMessages.CallHierarchyUI_label){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        StatusLineHandler.clearStatusLine((IWorkbenchSite)editor.getSite());
                        Scope scope = new Scope(project.getProject().getName());
                        final ICElement[] elems = service.findDefinitions(scope, project, inputCElement, selectionStart, selectionLength, monitor);
                        if (elems.length > 0) {
                            display.asyncExec(new Runnable(){

                                public void run() {
                                    CallHierarchyUtil.internalOpen(editor.getSite().getWorkbenchWindow(), elems);
                                }
                            });
                        } else {
                            StatusLineHandler.showStatusLineMessage((IWorkbenchSite)editor.getSite(), (String)CHMessages.CallHierarchyUI_openFailureMessage);
                        }
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    public static void open(final ICallHierarchyService service, final IWorkbenchWindow window, final ICElement input) {
        if (input != null) {
            final Display display = Display.getCurrent();
            Job job = new Job(CHMessages.CallHierarchyUI_label){

                protected IStatus run(IProgressMonitor monitor) {
                    Scope scope = new Scope(input.getCProject().getProject().getName());
                    final ICElement[] elems = service.findDefinitions(scope, input, monitor);
                    if (elems != null && elems.length > 0) {
                        display.asyncExec(new Runnable(){

                            public void run() {
                                CallHierarchyUtil.internalOpen(window, elems);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private static RemoteCHViewPart internalOpen(IWorkbenchWindow window, ICElement input) {
        IWorkbenchPage page = window.getActivePage();
        try {
            RemoteCHViewPart result = (RemoteCHViewPart)page.showView("org.eclipse.ptp.rdt.ui.callHierarchy");
            result.setInput(input);
            return result;
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)window.getShell(), (String)CHMessages.OpenCallHierarchyAction_label, null);
            return null;
        }
    }

    private static RemoteCHViewPart internalOpen(IWorkbenchWindow window, ICElement[] input) {
        ICElement elem = null;
        switch (input.length) {
            case 0: {
                break;
            }
            case 1: {
                elem = input[0];
                break;
            }
            default: {
                if (sIsJUnitTest) {
                    throw new RuntimeException("ambiguous input");
                }
                elem = OpenActionUtil.selectCElement((ICElement[])input, (Shell)window.getShell(), (String)CHMessages.CallHierarchyUI_label, (String)CHMessages.CallHierarchyUI_selectMessage, (int)-2147483647, (int)0);
            }
        }
        if (elem != null) {
            return CallHierarchyUtil.internalOpen(window, elem);
        }
        return null;
    }

    public static void setIsJUnitTest(boolean val) {
        sIsJUnitTest = val;
    }
}

