/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.services.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;

public class ProjectChangeListener {
    private static final IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            HashMap<IProject, String> renamedFrom = new HashMap<IProject, String>();
            HashMap<String, IProject> renamedTo = new HashMap<String, IProject>();
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                if (delta.getResource() instanceof IProject) {
                    IProject project = (IProject)delta.getResource();
                    if (delta.getKind() == 1 && (delta.getFlags() & 0x1000) != 0) {
                        renamedFrom.put(project, delta.getMovedFromPath().segment(0));
                    } else if (delta.getKind() == 2 && (delta.getFlags() & 0x2000) != 0) {
                        renamedTo.put(project.getName(), project);
                    } else if (delta.getKind() == 2) {
                        ServiceModelManager.getInstance().remove(project);
                    }
                }
                ++n2;
            }
            for (Map.Entry addedInfo : renamedFrom.entrySet()) {
                IProject addedProject = (IProject)addedInfo.getKey();
                IProject removedProject = (IProject)renamedTo.remove(addedInfo.getValue());
                ServiceModelManager.getInstance().remap(removedProject, addedProject);
            }
        }
    };

    private ProjectChangeListener() {
    }

    public static void startListening() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(listener, 1);
    }

    public static void stopListening() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(listener);
    }
}

