/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VPGLog<T, R extends TokenRef<T>> {
    private VPG<?, T, R, ? extends VPGDB<?, T, R, ?>, ? extends VPGLog<T, R>> vpg = null;
    protected List<Entry> log = new LinkedList<Entry>();
    private Set<ILogListener> listeners = new HashSet<ILogListener>();
    private static final String EOL = System.getProperty("line.separator");
    private static final String EOL_ESCAPE = "&EOL;";

    public void setVPG(VPG<?, T, R, ? extends VPGDB<?, T, R, ?>, ? extends VPGLog<T, R>> vpg) {
        this.vpg = vpg;
    }

    protected VPG<?, T, R, ? extends VPGDB<?, T, R, ?>, ? extends VPGLog<T, R>> getVPG() {
        if (this.vpg == null) {
            throw new IllegalStateException("This VPG database has not been assigned to a VPG.  Construct a VPGDB object, and then pass it to the VPG or EclipseVPG constructor.");
        }
        return this.vpg;
    }

    public void clear() {
        this.log.clear();
        this.notifyListeners();
    }

    public void clearEntriesFor(String filename) {
        LinkedList<Entry> newLog = new LinkedList<Entry>();
        for (Entry entry : this.log) {
            Object tokenRef = entry.getTokenRef();
            if (tokenRef != null && ((TokenRef)tokenRef).getFilename().equals(filename)) continue;
            newLog.add(entry);
        }
        this.log = newLog;
        this.notifyListeners();
    }

    public void logWarning(String message) {
        this.log.add(new Entry(this, true, message, null));
        this.notifyListeners();
    }

    public void logWarning(String message, String filename) {
        this.log.add(new Entry(this, true, message, this.getVPG().createTokenRef(filename, 0, 0)));
        this.notifyListeners();
    }

    public void logWarning(String message, R tokenRef) {
        this.log.add(new Entry(this, true, message, tokenRef));
        this.notifyListeners();
    }

    public void logError(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName());
        sb.append(": ");
        sb.append(e.getMessage());
        sb.append("\n");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(bs));
        sb.append(bs);
        this.log.add(new Entry(this, false, sb.toString(), null));
        this.notifyListeners();
    }

    public void logError(String message) {
        this.log.add(new Entry(this, false, message, null));
        this.notifyListeners();
    }

    public void logError(String message, R tokenRef) {
        this.log.add(new Entry(this, false, message, tokenRef));
        this.notifyListeners();
    }

    public boolean hasErrorsLogged() {
        for (Entry entry : this.log) {
            if (!entry.isError()) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrorsOrWarningsLogged() {
        return !this.log.isEmpty();
    }

    public List<Entry> getEntries() {
        return this.log;
    }

    public void printOn(PrintStream out) {
        for (Entry entry : this.log) {
            out.print(entry.isError() ? "ERROR:   " : "Warning: ");
            out.println(entry.getMessage());
            Object t = entry.getTokenRef();
            if (t == null) continue;
            out.print("         (");
            out.print(((TokenRef)t).getFilename());
            out.print(", offset ");
            out.print(((TokenRef)t).getOffset());
            out.print(", length ");
            out.print(((TokenRef)t).getLength());
            out.println(")");
        }
    }

    public void addLogListener(ILogListener listener) {
        this.listeners.add(listener);
        listener.onLogChange();
    }

    public void removeLogListener(ILogListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners() {
        for (ILogListener listener : this.listeners) {
            listener.onLogChange();
        }
    }

    protected abstract File getLogFile();

    public void writeToFile() throws IOException {
        BufferedWriter output = new BufferedWriter(new FileWriter(this.getLogFile()));
        try {
            TokenRef tokenRef = null;
            String message = "";
            for (Entry entry : this.log) {
                output.write(String.valueOf(Boolean.toString(entry.isWarning())) + EOL);
                tokenRef = (TokenRef)entry.getTokenRef();
                output.write(String.valueOf(tokenRef.getFilename()) + "," + Integer.toString(tokenRef.getOffset()) + "," + Integer.toString(tokenRef.getLength()) + EOL);
                message = entry.getMessage();
                message.replaceAll(EOL, EOL_ESCAPE);
                output.write(String.valueOf(message) + EOL);
            }
        }
        finally {
            ((Writer)output).close();
        }
    }

    public void readLogFromFile() {
        try {
            try {
                String line;
                FileInputStream fstream = new FileInputStream(this.getLogFile());
                BufferedReader bRead = new BufferedReader(new InputStreamReader(fstream));
                boolean isWarning = false;
                TokenRef tokenRef = null;
                String[] tokenRefString = null;
                String message = "";
                this.clear();
                while ((line = bRead.readLine()) != null) {
                    isWarning = Boolean.parseBoolean(line);
                    line = bRead.readLine();
                    tokenRefString = line.split("\\,");
                    tokenRef = (TokenRef)this.vpg.createTokenRef(tokenRefString[0], Integer.parseInt(tokenRefString[1]), Integer.parseInt(tokenRefString[2]));
                    message = line = bRead.readLine();
                    message.replaceAll(EOL_ESCAPE, EOL);
                    this.log.add(new Entry(this, isWarning, message, tokenRef));
                }
                bRead.close();
                fstream.close();
            }
            catch (Exception exception) {
                this.notifyListeners();
                return;
            }
        }
        finally {
            this.notifyListeners();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry {
        private boolean isWarning;
        private String message;
        private R tokenRef;
        final /* synthetic */ VPGLog this$0;

        public Entry(boolean isWarningOnly, String message, R tokenRef) {
            this.this$0 = var1_1;
            this.isWarning = isWarningOnly;
            this.message = message;
            this.tokenRef = tokenRef;
        }

        public boolean isWarning() {
            return this.isWarning;
        }

        public boolean isError() {
            return !this.isWarning;
        }

        public String getMessage() {
            return this.message;
        }

        public R getTokenRef() {
            return this.tokenRef;
        }
    }

    public static interface ILogListener {
        public void onLogChange();
    }
}

