/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.LexerFactory;
import org.eclipse.photran.internal.core.lexer.SourceForm;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.IncludeLoaderCallback;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.editor.AbstractFortranEditor;
import org.eclipse.photran.internal.ui.editor_vpg.DefinitionMap;
import org.eclipse.photran.internal.ui.editor_vpg.IFortranEditorASTTask;
import org.eclipse.photran.internal.ui.editor_vpg.IFortranEditorVPGTask;
import org.eclipse.rephraserengine.core.vpg.eclipse.VPGJob;

public class FortranEditorTasks {
    private AbstractFortranEditor editor;
    private Runner runner;
    private final Set<IFortranEditorASTTask> astTasks = new HashSet<IFortranEditorASTTask>();
    private final Set<IFortranEditorVPGTask> vpgTasks = new HashSet<IFortranEditorVPGTask>();

    public static FortranEditorTasks instance(AbstractFortranEditor editor) {
        if (editor.reconcilerTasks == null) {
            editor.reconcilerTasks = new FortranEditorTasks(editor);
        }
        return (FortranEditorTasks)editor.reconcilerTasks;
    }

    private FortranEditorTasks(AbstractFortranEditor editor) {
        this.editor = editor;
        editor.reconcilerTasks = this;
        this.runner = new Runner();
    }

    public synchronized void addASTTask(IFortranEditorASTTask task) {
        this.astTasks.add(task);
    }

    public synchronized void addVPGTask(IFortranEditorVPGTask task) {
        this.vpgTasks.add(task);
    }

    public synchronized void removeASTTask(IFortranEditorASTTask task) {
        this.astTasks.remove(task);
    }

    public synchronized void removeVPGTask(IFortranEditorVPGTask task) {
        this.vpgTasks.remove(task);
    }

    public Runner getRunner() {
        return this.runner;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Runner {
        protected DefinitionMap<Definition> defMap = null;
        protected PhotranVPG vpg = PhotranVPG.getInstance();
        protected Job dispatchASTTasksJob = null;
        protected VPGJob<IFortranAST, Token> updateVPGJob = null;
        protected Job dispatchVPGTasksJob = null;
        protected IFortranAST vpgAST = null;
        private Parser parser = new Parser();

        public void runTasks() {
            this.runTasks(true);
        }

        public void runTasks(boolean runVPGTasks) {
            if (FortranEditorTasks.this.editor == null) {
                return;
            }
            String vpgEnabledProperty = SearchPathProperties.getProperty((IFile)FortranEditorTasks.this.editor.getIFile(), (String)"EnableVPG");
            if (vpgEnabledProperty != null && vpgEnabledProperty.equals("true")) {
                this.runASTTasks();
                if (runVPGTasks) {
                    this.runVPGTasks();
                }
            }
        }

        private void runASTTasks() {
            if (this.dispatchASTTasksJob != null) {
                return;
            }
            this.dispatchASTTasksJob = new Job("Updating Fortran editor with new parse information"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    block7: {
                        ASTExecutableProgramNode astRootNode = null;
                        try {
                            if (FortranEditorTasks.this.editor.getDocumentProvider() == null) break block7;
                            String editorContents = FortranEditorTasks.this.editor.getDocumentProvider().getDocument((Object)FortranEditorTasks.this.editor.getEditorInput()).get();
                            SourceForm sourceForm = FortranEditorTasks.this.editor.getIFile() == null || FortranEditorTasks.this.editor.getIFile().getProject() == null ? SourceForm.UNPREPROCESSED_FREE_FORM : SourceForm.preprocessedFreeForm((IncludeLoaderCallback)new IncludeLoaderCallback(FortranEditorTasks.this.editor.getIFile().getProject()));
                            IAccumulatingLexer lexer = LexerFactory.createLexer((InputStream)new ByteArrayInputStream(editorContents.getBytes()), (IFile)FortranEditorTasks.this.editor.getIFile(), (String)FortranEditorTasks.this.editor.getIFile().getName(), (SourceForm)sourceForm, (boolean)true);
                            astRootNode = Runner.this.parser.parse(lexer);
                            if (astRootNode == null) {
                                return Status.OK_STATUS;
                            }
                            HashSet<IFortranEditorASTTask> tasksToRemove = new HashSet<IFortranEditorASTTask>();
                            FortranEditorTasks fortranEditorTasks = FortranEditorTasks.instance(FortranEditorTasks.this.editor);
                            synchronized (fortranEditorTasks) {
                                for (IFortranEditorASTTask task : FortranEditorTasks.instance(FortranEditorTasks.this.editor).astTasks) {
                                    if (task.handle(astRootNode, lexer.getTokenList(), Runner.this.defMap)) continue;
                                    tasksToRemove.add(task);
                                }
                            }
                            FortranEditorTasks.instance(FortranEditorTasks.this.editor).astTasks.removeAll(tasksToRemove);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    Runner.this.dispatchASTTasksJob = null;
                    return Status.OK_STATUS;
                }
            };
            this.dispatchASTTasksJob.setPriority(50);
            this.dispatchASTTasksJob.schedule();
        }

        private void runVPGTasks() {
            if (this.updateVPGJob != null || this.dispatchVPGTasksJob != null) {
                return;
            }
            this.vpg.queueJobToEnsureVPGIsUpToDate();
            this.vpgAST = null;
            this.updateVPGJob = new VPGJob<IFortranAST, Token>("Updating Fortran editor with new analysis information"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    Runner.this.vpgAST = (IFortranAST)Runner.this.vpg.acquireTransientAST(PhotranVPG.getFilenameForIFile((IFile)FortranEditorTasks.this.editor.getIFile()));
                    Runner.this.updateVPGJob = null;
                    if (Runner.this.vpgAST != null) {
                        Runner.this.defMap = Runner.this.createDefMap();
                        for (IFortranEditorVPGTask task : FortranEditorTasks.instance(FortranEditorTasks.this.editor).vpgTasks) {
                            task.handle(FortranEditorTasks.this.editor.getIFile(), Runner.this.vpgAST, Runner.this.defMap);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.updateVPGJob.setPriority(50);
            this.updateVPGJob.schedule();
        }

        private DefinitionMap<Definition> createDefMap() {
            return new DefinitionMap<Definition>(this.vpgAST){

                @Override
                protected Definition map(String qualifiedName, Definition def) {
                    return def;
                }
            };
        }
    }
}

