/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.photran.internal.ui.editor.AbstractFortranEditor;
import org.eclipse.photran.internal.ui.search.VPGSearchQuery;
import org.eclipse.photran.internal.ui.vpg.Activator;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPGSearchPage
extends DialogPage
implements ISearchPage {
    public static final String EXTENSION_ID = "org.eclipse.photran.ui.vpgSearchPage";
    private static final String PAGE_NAME = "VPGSearchPage";
    private static final String STORE_PREVIOUS_PATTERNS = "previousPatterns";
    private static final String STORE_REGEX_SEARCH = "regexSearch";
    private static final String STORE_SEARCH_FLAGS = "searchFlags";
    private static final String[] searchForText = new String[]{"Common block", "Function", "Subroutine", "Module", "Variable", "Program"};
    private static final Integer[] searchForData = new Integer[]{new Integer(512), new Integer(32), new Integer(256), new Integer(1024), new Integer(64), new Integer(16)};
    private static String[] limitToText = new String[]{"All occurrences", "Declarations", "References"};
    private static Integer[] limitToData = new Integer[]{new Integer(3), new Integer(2), new Integer(1)};
    private Combo patternCombo;
    private String[] previousPatterns;
    private MessageBox errorBox;
    private Button[] searchForButtons;
    private Button[] limitToButtons;
    private Button regexButton;
    private boolean isRegex;
    private boolean firstTime = true;
    private IStructuredSelection structuredSelection;
    private ITextSelection textSelection;
    private ISearchPageContainer pageContainer;
    private Label patternLabel;
    private final String globPatternString = "(* = any string, ? = any character)";

    private static IResource getResource(Object obj) {
        if (obj instanceof ICElement) {
            return ((ICElement)obj).getResource();
        }
        if (obj instanceof IResource) {
            return (IResource)obj;
        }
        return null;
    }

    public boolean performAction() {
        VPGSearchQuery job;
        String patternStr = this.patternCombo.getText();
        int searchFlags = 0;
        int i = 0;
        while (i < this.searchForButtons.length) {
            if (this.searchForButtons[i].getSelection()) {
                searchFlags |= ((Integer)this.searchForButtons[i].getData()).intValue();
            }
            ++i;
        }
        i = 0;
        while (i < this.limitToButtons.length) {
            if (this.limitToButtons[i].getSelection()) {
                searchFlags |= ((Integer)this.limitToButtons[i].getData()).intValue();
            }
            ++i;
        }
        ArrayList<IResource> scope = new ArrayList<IResource>();
        String scopeDescription = this.determineScope(scope);
        try {
            job = new VPGSearchQuery(scope, scopeDescription, patternStr, searchFlags, this.isRegex);
        }
        catch (PatternSyntaxException e) {
            this.errorBox = new MessageBox(this.getShell(), 33);
            this.errorBox.setText("Invalid Search Pattern");
            this.errorBox.setMessage("The search pattern entered is invalid:\n" + e.getMessage());
            this.errorBox.open();
            return false;
        }
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)job);
        this.saveDialogSettings(patternStr, searchFlags);
        return true;
    }

    private String determineScope(List<IResource> scope) {
        String scopeDescription;
        switch (this.getContainer().getSelectedScope()) {
            case 3: {
                scopeDescription = "enclosing projects";
                if (this.structuredSelection != null) {
                    Iterator i = this.structuredSelection.iterator();
                    while (i.hasNext()) {
                        IResource res = VPGSearchPage.getResource(i.next());
                        if (res == null) continue;
                        scope.add(res);
                    }
                    break;
                }
                IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IEditorPart editor = wbWindow.getActivePage().getActiveEditor();
                AbstractFortranEditor fEditor = editor instanceof AbstractFortranEditor ? (AbstractFortranEditor)editor : null;
                scope.add((IResource)fEditor.getIFile().getProject());
                break;
            }
            case 1: {
                scopeDescription = "selected resources";
                if (this.structuredSelection == null) break;
                Iterator i = this.structuredSelection.iterator();
                while (i.hasNext()) {
                    IResource res = VPGSearchPage.getResource(i.next());
                    if (res == null) continue;
                    scope.add(res);
                }
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                scopeDescription = "Working Set - " + VPGSearchPage.toString(workingSets);
                int i = 0;
                while (i < workingSets.length) {
                    IAdaptable[] wsElements;
                    IAdaptable[] iAdaptableArray = wsElements = workingSets[i].getElements();
                    int n = wsElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAdaptable elem = iAdaptableArray[n2];
                        IResource res = VPGSearchPage.getResource(elem);
                        if (res != null) {
                            scope.add(res);
                        }
                        ++n2;
                    }
                    ++i;
                }
                break;
            }
            default: {
                scope.add((IResource)ResourcesPlugin.getWorkspace().getRoot());
                scopeDescription = "Workspace";
            }
        }
        return scopeDescription;
    }

    private void saveDialogSettings(String patternStr, int searchFlags) {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(STORE_REGEX_SEARCH, this.isRegex);
        if (this.previousPatterns == null) {
            this.previousPatterns = new String[]{patternStr};
        } else {
            boolean addit = true;
            int i = 0;
            while (i < this.previousPatterns.length) {
                if (patternStr.equals(this.previousPatterns[i])) {
                    String tmpPattern = this.previousPatterns[i];
                    System.arraycopy(this.previousPatterns, 0, this.previousPatterns, 1, i);
                    this.previousPatterns[0] = tmpPattern;
                    addit = false;
                    break;
                }
                ++i;
            }
            if (addit) {
                String[] newPatterns = new String[this.previousPatterns.length + 1];
                System.arraycopy(this.previousPatterns, 0, newPatterns, 1, this.previousPatterns.length);
                newPatterns[0] = patternStr;
                this.previousPatterns = newPatterns;
            }
        }
        settings.put(STORE_PREVIOUS_PATTERNS, this.previousPatterns);
        settings.put(STORE_SEARCH_FLAGS, searchFlags);
    }

    public void createControl(Composite parent) {
        Button button;
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 18;
        gd.horizontalSpan = 2;
        Label label = new Label(result, 16384);
        label.setText("Search pattern:");
        label.setLayoutData((Object)gd);
        this.patternCombo = new Combo(result, 2052);
        this.patternCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VPGSearchPage.this.setPerformActionEnabled();
            }
        });
        gd = new GridData(768);
        this.regexButton = new Button(result, 32);
        this.regexButton.setText("Regular e&xpression");
        gd = new GridData();
        this.regexButton.setLayoutData((Object)gd);
        this.regexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VPGSearchPage.this.isRegex = VPGSearchPage.this.regexButton.getSelection();
                VPGSearchPage.this.setPerformActionEnabled();
            }
        });
        gd = new GridData(768);
        gd.horizontalIndent = -gd.horizontalIndent;
        this.patternCombo.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 18;
        gd.horizontalSpan = 2;
        this.patternLabel = new Label(result, 16384);
        this.patternLabel.setText("(* = any string, ? = any character)");
        this.patternLabel.setLayoutData((Object)gd);
        Composite groupsComposite = new Composite(result, 0);
        layout = new GridLayout(2, false);
        groupsComposite.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        groupsComposite.setLayoutData((Object)gd);
        Group group = new Group(groupsComposite, 0);
        group.setText("Search for");
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(770));
        this.searchForButtons = new Button[searchForText.length];
        int i = 0;
        while (i < searchForText.length) {
            button = new Button((Composite)group, 32);
            button.setText(searchForText[i]);
            button.setData((Object)searchForData[i]);
            this.searchForButtons[i] = button;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    VPGSearchPage.this.setPerformActionEnabled();
                }
            });
            ++i;
        }
        group = new Group(groupsComposite, 0);
        group.setText("Limit to");
        layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(770));
        this.limitToButtons = new Button[limitToText.length];
        i = 0;
        while (i < limitToText.length) {
            button = new Button((Composite)group, 16);
            button.setText(limitToText[i]);
            button.setData((Object)limitToData[i]);
            this.limitToButtons[i] = button;
            ++i;
        }
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
    }

    public void setContainer(ISearchPageContainer container) {
        this.pageContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.pageContainer;
    }

    private void setPerformActionEnabled() {
        boolean enable = true;
        this.patternLabel.setVisible(!this.isRegex);
        if (this.patternCombo.getText().length() == 0) {
            enable = false;
        }
        boolean any = false;
        int i = 0;
        while (i < this.searchForButtons.length) {
            if (this.searchForButtons[i].getSelection()) {
                any = true;
                break;
            }
            ++i;
        }
        if (!any) {
            enable = false;
        }
        this.getContainer().setPerformActionEnabled(enable);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings searchSettings = settings.getSection(PAGE_NAME);
        if (searchSettings == null) {
            searchSettings = settings.addNewSection(PAGE_NAME);
        }
        return searchSettings;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.firstTime) {
                this.firstTime = false;
                this.restoreDialogSettings();
            }
            this.patternCombo.setFocus();
            this.setPerformActionEnabled();
        }
        super.setVisible(visible);
    }

    private void restoreDialogSettings() {
        ISelection selection;
        IDialogSettings settings = this.getDialogSettings();
        int searchFlags = 1907;
        try {
            searchFlags = settings.getInt(STORE_SEARCH_FLAGS);
        }
        catch (NumberFormatException numberFormatException) {}
        this.previousPatterns = settings.getArray(STORE_PREVIOUS_PATTERNS);
        if (this.previousPatterns != null) {
            this.patternCombo.setItems(this.previousPatterns);
        }
        if ((selection = this.getContainer().getSelection()) instanceof IStructuredSelection) {
            this.structuredSelection = (IStructuredSelection)selection;
        } else if (selection instanceof ITextSelection) {
            this.textSelection = (ITextSelection)selection;
            this.patternCombo.setText(this.textSelection.getText());
        }
        int i = 0;
        while (i < this.searchForButtons.length) {
            this.searchForButtons[i].setSelection((searchFlags & (Integer)this.searchForButtons[i].getData()) != 0);
            ++i;
        }
        i = 0;
        while (i < this.limitToButtons.length) {
            this.limitToButtons[i].setSelection((searchFlags & 3) == (Integer)this.limitToButtons[i].getData());
            ++i;
        }
        this.isRegex = settings.getBoolean(STORE_REGEX_SEARCH);
        this.regexButton.setSelection(this.isRegex);
    }

    public static String toString(IWorkingSet[] workingSets) {
        if (workingSets != null && workingSets.length > 0) {
            String string = new String();
            int i = 0;
            while (i < workingSets.length) {
                if (i > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + workingSets[i].getName();
                ++i;
            }
            return string;
        }
        return null;
    }
}

