/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.search;

import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.search.ReferenceSearchResult;
import org.eclipse.photran.internal.ui.search.VPGSearchMatch;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.Workbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPGSearchQuery
implements ISearchQuery {
    public static final int FIND_PROGRAM = 16;
    public static final int FIND_FUNCTION = 32;
    public static final int FIND_VARIABLE = 64;
    public static final int FIND_SUBROUTINE = 256;
    public static final int FIND_COMMON_BLOCK = 512;
    public static final int FIND_MODULE = 1024;
    public static final int FIND_ALL_TYPES = 1904;
    public static final int FIND_REFERENCES = 1;
    public static final int FIND_DECLARATIONS = 2;
    public static final int FIND_ALL_OCCURANCES = 3;
    protected ReferenceSearchResult result = new ReferenceSearchResult(this);
    private String scopeDesc;
    private String patternStr;
    private List<IResource> scope;
    private int searchFlags;
    private String origPatternStr;
    private TreeSet<String> projectsWithRefactoringDisabled = new TreeSet();

    public VPGSearchQuery(List<IResource> scope, String scopeDesc, String patternStr, int flags, boolean isRegex) {
        this.scope = scope;
        this.scopeDesc = scopeDesc;
        this.searchFlags = flags;
        this.origPatternStr = patternStr.trim();
        this.patternStr = this.convertPattern(isRegex, this.origPatternStr);
    }

    private String convertPattern(boolean isRegex, String patternStr) {
        if (isRegex) {
            Pattern.compile(patternStr);
            return patternStr;
        }
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < patternStr.length()) {
            char c = patternStr.charAt(i);
            switch (c) {
                case '*': {
                    buff.append(".*");
                    break;
                }
                case '?': {
                    buff.append(".");
                    break;
                }
                case '$': {
                    buff.append("\\$");
                    break;
                }
                default: {
                    if (!Character.toString(c).matches("[0-9a-zA-Z._]")) {
                        throw new PatternSyntaxException("Illegal character in pattern string", patternStr, i + 1);
                    }
                    buff.append("" + c);
                }
            }
            ++i;
        }
        return buff.toString();
    }

    public String getLabel() {
        return "'" + this.origPatternStr + "' - " + this.result.getMatchCount() + " occurence(s) in " + this.scopeDesc;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    protected static boolean shouldNotProcess(IResource resource) {
        return resource == null || resource instanceof IProject && !PhotranVPG.getInstance().shouldProcessProject((IProject)resource) || resource instanceof IFile && !PhotranVPG.getInstance().shouldProcessFile((IFile)resource);
    }

    public static void addSearchResultFromTokenRef(PhotranTokenRef tokenRef, ReferenceSearchResult searchResult) {
        Token token = tokenRef.findTokenOrReturnNull();
        if (token != null) {
            VPGSearchMatch match = new VPGSearchMatch(token.getIFile(), token.getFileOffset(), token.getLength());
            searchResult.addMatch(match);
        }
    }

    public final IStatus run(IProgressMonitor monitor) {
        int[] counter = new int[1];
        try {
            PhotranVPG.getInstance().ensureVPGIsUpToDate((IProgressMonitor)new SubProgressMonitor(monitor, 0));
            this.result.removeAll();
            counter[0] = 0;
            VPGCountResourceVisitor countVisitor = new VPGCountResourceVisitor(counter);
            for (IResource resource : this.scope) {
                resource.accept((IResourceVisitor)countVisitor);
            }
            monitor.beginTask("Searching for " + this.origPatternStr + " in " + this.scopeDesc, counter[0] * 2);
            VPGSearchResourceVisitor visitor = new VPGSearchResourceVisitor(monitor);
            for (IResource resource : this.scope) {
                resource.accept((IResourceVisitor)visitor);
            }
            visitor.addPostponedSearchResults((IProgressMonitor)new SubProgressMonitor(monitor, counter[0]));
            if (!PhotranVPG.inTestingMode() && Workbench.getInstance().getWorkbenchWindowCount() > 0 && !this.projectsWithRefactoringDisabled.isEmpty()) {
                Workbench.getInstance().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        StringBuilder projects = new StringBuilder();
                        for (String project : VPGSearchQuery.this.projectsWithRefactoringDisabled) {
                            projects.append(project);
                            projects.append('\n');
                        }
                        MessageDialog.openWarning((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)("References in the following projects have been excluded from the search results because Fortran analysis/refactoring is disabled:\n\n" + projects + "\nPlease enable Fortran analysis/refactoring for these projects if you wish" + " for their references to show in search results."));
                    }
                });
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private class VPGCountResourceVisitor
    implements IResourceVisitor {
        private int[] counter;

        public VPGCountResourceVisitor(int[] counter) {
            this.counter = counter;
        }

        public boolean visit(IResource resource) {
            if (VPGSearchQuery.shouldNotProcess(resource)) {
                return false;
            }
            this.counter[0] = this.counter[0] + 1;
            return !(resource instanceof IFile);
        }
    }

    private class VPGSearchResourceVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;
        private TreeSet<PhotranTokenRef> matchesToAddLater;

        public VPGSearchResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
            this.matchesToAddLater = new TreeSet();
        }

        public boolean visit(IResource resource) {
            if (VPGSearchQuery.shouldNotProcess(resource)) {
                return false;
            }
            this.monitor.worked(1);
            if (!(resource instanceof IFile)) {
                return true;
            }
            this.monitor.subTask("Searching " + resource.getName());
            IFortranAST ast = (IFortranAST)PhotranVPG.getInstance().acquireTransientAST((IFile)resource);
            if (ast == null) {
                return false;
            }
            Token searchToken = new Token(Terminal.T_IDENT, VPGSearchQuery.this.patternStr);
            searchToken.setFile((IFile)resource);
            searchToken.setContainerFile((IFile)resource);
            if (ast.getRoot().getEmptyProgram() == null) {
                for (ScopingNode sNode : ast.getRoot().getAllContainedScopes()) {
                    List refs = sNode.manuallyResolve(searchToken);
                    for (PhotranTokenRef ref : refs) {
                        if (ref.getOffset() < 0 || ref.getLength() < 0) continue;
                        this.foundDefinition(ref);
                    }
                }
            }
            return false;
        }

        private void foundDefinition(PhotranTokenRef ref) {
            Token token = ref.findToken();
            for (Definition def : token.resolveBinding()) {
                if (!this.shouldAccept(def)) continue;
                if ((VPGSearchQuery.this.searchFlags & 2) != 0) {
                    this.foundMatch(token);
                }
                if ((VPGSearchQuery.this.searchFlags & 1) == 0) continue;
                for (PhotranTokenRef rref : def.findAllReferences(true)) {
                    this.foundMatch(rref);
                }
            }
        }

        private boolean shouldAccept(Definition def) {
            if (!PhotranVPG.getInstance().doesProjectHaveRefactoringEnabled(def.getTokenRef().getFile())) {
                VPGSearchQuery.this.projectsWithRefactoringDisabled.add(def.getTokenRef().getFile().getProject().getName());
                return false;
            }
            if ((VPGSearchQuery.this.searchFlags & 0x10) != 0 && def.isMainProgram()) {
                return true;
            }
            if ((VPGSearchQuery.this.searchFlags & 0x20) != 0 && def.getClassification() == Definition.Classification.FUNCTION) {
                return true;
            }
            if ((VPGSearchQuery.this.searchFlags & 0x40) != 0 && def.isLocalVariable()) {
                return true;
            }
            if ((VPGSearchQuery.this.searchFlags & 0x100) != 0 && def.getClassification() == Definition.Classification.SUBROUTINE) {
                return true;
            }
            if ((VPGSearchQuery.this.searchFlags & 0x400) != 0 && def.getClassification() == Definition.Classification.MODULE) {
                return true;
            }
            return (VPGSearchQuery.this.searchFlags & 0x200) != 0 && def.isCommon();
        }

        private void foundMatch(Token token) {
            this.addSearchResultFromTokenRef(token.getTokenRef());
        }

        private void foundMatch(PhotranTokenRef ref) {
            this.matchesToAddLater.add(ref);
        }

        public void addPostponedSearchResults(IProgressMonitor pm) {
            pm.beginTask("Adding references", this.matchesToAddLater.size());
            String lastFilename = null;
            for (PhotranTokenRef tokenRef : this.matchesToAddLater) {
                if (!tokenRef.getFilename().equals(lastFilename)) {
                    lastFilename = tokenRef.getFilename();
                    pm.subTask("Adding references in " + lastFilename.substring(lastFilename.lastIndexOf(47) + 1));
                }
                pm.worked(1);
                this.addSearchResultFromTokenRef(tokenRef);
            }
            pm.done();
        }

        private void addSearchResultFromTokenRef(PhotranTokenRef tokenRef) {
            VPGSearchQuery.addSearchResultFromTokenRef(tokenRef, (ReferenceSearchResult)VPGSearchQuery.this.getSearchResult());
        }
    }
}

