/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.IRemoteServicesDescriptor;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnectionManager;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsFileManager;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsProcessBuilder;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsServices
implements IRemoteServices {
    private static String TARGET_ELEMENT_NAME = "PTP Remote Host";
    private static String REMOTE_TOOLS_ID = "org.eclipse.ptp.remote.RemoteTools";
    private static RemoteToolsServices instance = null;
    private RemoteToolsConnectionManager connMgr = null;
    private Map<String, RemoteToolsFileManager> fileMgrs = new HashMap<String, RemoteToolsFileManager>();
    private final IRemoteServicesDescriptor fDescriptor;

    public static RemoteToolsServices getInstance() {
        if (instance == null) {
            IRemoteServicesDescriptor descriptor = PTPRemoteCorePlugin.getDefault().getRemoteServicesDescriptor(REMOTE_TOOLS_ID);
            instance = new RemoteToolsServices(descriptor);
        }
        return instance;
    }

    public static TargetTypeElement getTargetTypeElement() {
        TargetEnvironmentManager targetMgr = EnvironmentPlugin.getDefault().getTargetsManager();
        for (Object obj : targetMgr.getTypeElements()) {
            TargetTypeElement element = (TargetTypeElement)obj;
            if (!element.getName().equals(TARGET_ELEMENT_NAME)) continue;
            return element;
        }
        return null;
    }

    public RemoteToolsServices(IRemoteServicesDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public IRemoteConnectionManager getConnectionManager() {
        return this.connMgr;
    }

    public String getDirectorySeparator(IRemoteConnection conn) {
        return "/";
    }

    public IRemoteFileManager getFileManager(IRemoteConnection conn) {
        RemoteToolsFileManager fileMgr = this.fileMgrs.get(conn.getName());
        if (fileMgr == null) {
            fileMgr = new RemoteToolsFileManager((RemoteToolsConnection)conn);
            this.fileMgrs.put(conn.getName(), fileMgr);
        }
        return fileMgr;
    }

    public String getId() {
        return this.fDescriptor.getId();
    }

    public String getName() {
        return this.fDescriptor.getName();
    }

    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, List<String> command) {
        return new RemoteToolsProcessBuilder((RemoteToolsConnection)conn, (RemoteToolsFileManager)this.getFileManager(conn), command);
    }

    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, String ... command) {
        return new RemoteToolsProcessBuilder((RemoteToolsConnection)conn, (RemoteToolsFileManager)this.getFileManager(conn), command);
    }

    public String getScheme() {
        return this.fDescriptor.getScheme();
    }

    public void initialize() {
        if (this.connMgr == null) {
            this.connMgr = new RemoteToolsConnectionManager();
        }
    }

    public boolean isInitialized() {
        this.initialize();
        return this.connMgr != null;
    }
}

