/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.util.NoSuchElementException;
import org.eclipse.ptp.remotetools.core.IRemoteFileEnumeration;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.remotetools.internal.ssh.FileTools;

public class RemoteFileEnumeration
implements IRemoteFileEnumeration {
    private IRemoteItem[] items = null;
    private int currentItem = 0;

    public RemoteFileEnumeration(FileTools fileTools, String directoryPath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.items = fileTools.listItems(directoryPath);
        this.currentItem = 0;
    }

    public boolean hasMoreElements() {
        return this.currentItem < this.items.length;
    }

    public boolean hasMoreExceptions() {
        return false;
    }

    public IRemoteItem nextElement() {
        return this.nextElementAsItem();
    }

    public IRemoteItem nextElementAsItem() {
        if (this.currentItem >= this.items.length) {
            throw new NoSuchElementException();
        }
        return this.items[this.currentItem++];
    }

    public Exception nextException() {
        return null;
    }
}

