/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.io.BufferedReader;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.rm.core.RMCorePlugin;
import org.eclipse.ptp.rm.core.rtsystem.AbstractRemoteCommandJob;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2MachineAttributes;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2Plugin;
import org.eclipse.ptp.rm.mpi.mpich2.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2JobMap;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2ListJobsParser;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2RuntimeSystem;

public class MPICH2PeriodicJob
extends AbstractRemoteCommandJob {
    MPICH2RuntimeSystem rts;

    public MPICH2PeriodicJob(MPICH2RuntimeSystem rts, IProgressMonitor monitor) {
        super((AbstractToolRuntimeSystem)rts, NLS.bind((String)Messages.MPICH2MonitorJob_name, (Object)rts.getRmConfiguration().getName()), rts.retrieveEffectiveToolRmConfiguration().getPeriodicMonitorCmd(), Messages.MPICH2MonitorJob_interruptedErrorMessage, Messages.MPICH2MonitorJob_processErrorMessage, Messages.MPICH2MonitorJob_parsingErrorMessage, rts.retrieveEffectiveToolRmConfiguration().getPeriodicMonitorTime(), monitor);
        this.rts = rts;
    }

    protected IStatus parse(BufferedReader output) {
        IResourceManager rm = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.rts.getRmID());
        IPMachine machine = rm.getMachineById(this.rts.getMachineID());
        IPQueue queue = rm.getQueueById(this.rts.getQueueID());
        if (machine == null || queue == null) {
            return Status.OK_STATUS;
        }
        try {
            MPICH2ListJobsParser parser = new MPICH2ListJobsParser();
            MPICH2JobMap jobMap = parser.parse(output);
            if (jobMap == null) {
                return new Status(4, MPICH2Plugin.getDefault().getBundle().getSymbolicName(), parser.getErrorMessage());
            }
            for (List<MPICH2JobMap.Job> jobs : jobMap.getJobs()) {
                for (MPICH2JobMap.Job job : jobs) {
                    IPProcessControl process;
                    IPJob pJob = queue.getJobById(job.getJobAlias());
                    if (pJob == null || (process = (IPProcessControl)pJob.getProcessByIndex(job.getRank())) == null || process.getNode() != null) continue;
                    String nodeID = this.rts.getNodeIDforName(job.getHost());
                    if (nodeID == null) {
                        return new Status(4, RMCorePlugin.getDefault().getBundle().getSymbolicName(), Messages.MPICH2RuntimeSystemJob_Exception_HostnamesDoNotMatch, null);
                    }
                    AttributeManager attrMrg = new AttributeManager();
                    attrMrg.addAttribute((IAttribute)ProcessAttributes.getNodeIdAttributeDefinition().create(nodeID));
                    this.rts.changeProcess(process.getID(), attrMrg);
                }
            }
        }
        catch (Exception e) {
            AttributeManager attrManager = new AttributeManager();
            attrManager.addAttribute((IAttribute)MachineAttributes.getStateAttributeDefinition().create((Enum)MachineAttributes.State.ERROR));
            attrManager.addAttribute((IAttribute)MPICH2MachineAttributes.getStatusMessageAttributeDefinition().create(NLS.bind((String)Messages.MPICH2MonitorJob_Exception_InternalError, (Object)e.getMessage())));
            this.rts.changeMachine(machine.getID(), attrManager);
            return new Status(4, MPICH2Plugin.getDefault().getBundle().getSymbolicName(), NLS.bind((String)Messages.MPICH2MonitorJob_Exception_InternalError, (Object)e.getMessage()), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

