/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ImplicitSpec;
import org.eclipse.photran.internal.core.analysis.binding.Intrinsics;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTBlockConstructNode;
import org.eclipse.photran.internal.core.parser.ASTBlockDataNameNode;
import org.eclipse.photran.internal.core.parser.ASTBlockDataStmtNode;
import org.eclipse.photran.internal.core.parser.ASTBlockDataSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTBlockStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndBlockDataStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndBlockStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndInterfaceStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndModuleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndNameNode;
import org.eclipse.photran.internal.core.parser.ASTEndProgramStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndSubmoduleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndTypeStmtNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionNameNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTGenericNameNode;
import org.eclipse.photran.internal.core.parser.ASTGenericSpecNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBlockNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceStmtNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNameNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTModuleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTProgramNameNode;
import org.eclipse.photran.internal.core.parser.ASTProgramStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubmoduleNode;
import org.eclipse.photran.internal.core.parser.ASTSubmoduleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineNameNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTTypeNameNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.IBlockDataBodyConstruct;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.parser.IDerivedTypeBodyConstruct;
import org.eclipse.photran.internal.core.parser.IInterfaceSpecification;
import org.eclipse.photran.internal.core.parser.IInternalSubprogram;
import org.eclipse.photran.internal.core.parser.IModuleBodyConstruct;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.util.Notification;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.PhotranVPGBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScopingNode
extends Parser.ASTNode {
    private PhotranTokenRef cachedRepresentataiveToken = null;
    private HashMap<String, List<PhotranTokenRef>> definitionCache = new HashMap();

    public static ScopingNode getEnclosingScope(Parser.IASTNode node) {
        Parser.IASTNode candidate = node.getParent();
        while (candidate != null) {
            if (ScopingNode.isScopingNode(candidate)) {
                ScopingNode scope = (ScopingNode)candidate;
                if (ScopingNode.shouldBeBoundToOuterScope(node)) {
                    return ScopingNode.getEnclosingScope(scope);
                }
                return scope;
            }
            candidate = candidate.getParent();
        }
        return null;
    }

    public static ScopingNode getLocalScope(Parser.IASTNode node) {
        Parser.IASTNode candidate = node.getParent();
        while (candidate != null) {
            if (ScopingNode.isScopingNode(candidate)) {
                return (ScopingNode)candidate;
            }
            candidate = candidate.getParent();
        }
        return null;
    }

    private static boolean shouldBeBoundToOuterScope(Parser.IASTNode node) {
        Parser.IASTNode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        Parser.IASTNode grandparent = parent.getParent();
        if (grandparent == null) {
            return false;
        }
        if (ScopingNode.isDeclStmtForScope(parent)) {
            return !(parent instanceof ASTFunctionStmtNode) || node != ((ASTFunctionStmtNode)parent).getName();
        }
        if (parent instanceof ASTProgramNameNode || parent instanceof ASTFunctionNameNode || parent instanceof ASTSubroutineNameNode || parent instanceof ASTModuleNameNode || parent instanceof ASTBlockDataNameNode || parent instanceof ASTTypeNameNode || parent instanceof ASTGenericNameNode || parent instanceof ASTGenericSpecNode || parent instanceof ASTEndNameNode) {
            if (ScopingNode.inAnonymousInterface(grandparent)) {
                return false;
            }
            return ScopingNode.isDeclStmtForScope(grandparent);
        }
        return false;
    }

    private static boolean isDeclStmtForScope(Parser.IASTNode node) {
        return node instanceof ASTProgramStmtNode || node instanceof ASTFunctionStmtNode || node instanceof ASTSubroutineStmtNode || node instanceof ASTModuleStmtNode || node instanceof ASTBlockDataStmtNode || node instanceof ASTDerivedTypeStmtNode || node instanceof ASTInterfaceStmtNode || node instanceof ASTSubmoduleStmtNode || node instanceof ASTBlockStmtNode || node instanceof ASTEndProgramStmtNode || node instanceof ASTEndFunctionStmtNode || node instanceof ASTEndSubroutineStmtNode || node instanceof ASTEndModuleStmtNode || node instanceof ASTEndBlockDataStmtNode || node instanceof ASTEndTypeStmtNode || node instanceof ASTEndInterfaceStmtNode || node instanceof ASTEndSubmoduleStmtNode || node instanceof ASTEndBlockStmtNode;
    }

    private static boolean inAnonymousInterface(Parser.IASTNode n) {
        Parser.IASTNode node = n.getParent();
        while (node != null) {
            if (node instanceof ASTInterfaceBlockNode && ScopingNode.isAnonymousInterface((ASTInterfaceBlockNode)node)) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public static boolean isScopingNode(Parser.IASTNode node) {
        return node instanceof ASTExecutableProgramNode || node instanceof ASTMainProgramNode || node instanceof ASTFunctionSubprogramNode || node instanceof ASTSubroutineSubprogramNode || node instanceof ASTModuleNode || node instanceof ASTBlockDataSubprogramNode || node instanceof ASTDerivedTypeDefNode || node instanceof ASTInterfaceBlockNode && !ScopingNode.isAnonymousInterface((ASTInterfaceBlockNode)node) || node instanceof ASTSubmoduleNode || node instanceof ASTBlockConstructNode;
    }

    private static boolean isAnonymousInterface(ASTInterfaceBlockNode node) {
        return node.getInterfaceStmt().getGenericName() != null && node.getInterfaceStmt().getGenericSpec() != null;
    }

    public ScopingNode getEnclosingScope() {
        return ScopingNode.getEnclosingScope(this);
    }

    public ScopingNode getGlobalScope() {
        Parser.IASTNode result = this;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    public PhotranTokenRef getRepresentativeToken() {
        return this.getRepresentativeToken(false);
    }

    public PhotranTokenRef getRepresentativeToken(boolean force) {
        if (force || this.cachedRepresentataiveToken == null) {
            Token result = this.internalGetRepresentativeToken();
            if (result == null) {
                Token firstToken = this.findFirstToken();
                if (firstToken == null) {
                    throw new Error("Empty file");
                }
                this.cachedRepresentataiveToken = new PhotranTokenRef(firstToken.getIFile(), -1, 0);
            } else {
                this.cachedRepresentataiveToken = result.getTokenRef();
            }
        }
        return this.cachedRepresentataiveToken;
    }

    private Token internalGetRepresentativeToken() {
        if (this instanceof ASTExecutableProgramNode) {
            return null;
        }
        if (this instanceof ASTMainProgramNode) {
            ASTProgramStmtNode m = ((ASTMainProgramNode)this).getProgramStmt();
            if (m != null) {
                if (m.getProgramName() != null) {
                    return m.getProgramName().getProgramName();
                }
                return m.getProgramToken();
            }
            ASTEndProgramStmtNode s = ((ASTMainProgramNode)this).getEndProgramStmt();
            return s.getEndToken();
        }
        if (this instanceof ASTFunctionSubprogramNode) {
            return ((ASTFunctionSubprogramNode)this).getFunctionStmt().getFunctionName().getFunctionName();
        }
        if (this instanceof ASTSubroutineSubprogramNode) {
            return ((ASTSubroutineSubprogramNode)this).getSubroutineStmt().getSubroutineName().getSubroutineName();
        }
        if (this instanceof ASTModuleNode) {
            return ((ASTModuleNode)this).getModuleStmt().getModuleName().getModuleName();
        }
        if (this instanceof ASTBlockDataSubprogramNode) {
            ASTBlockDataStmtNode s = ((ASTBlockDataSubprogramNode)this).getBlockDataStmt();
            if (s.getBlockDataName() != null) {
                return s.getBlockDataName().getBlockDataName();
            }
            return s.getBlockDataToken();
        }
        if (this instanceof ASTDerivedTypeDefNode) {
            return ((ASTDerivedTypeDefNode)this).getDerivedTypeStmt().getTypeName();
        }
        if (this instanceof ASTInterfaceBlockNode) {
            ASTInterfaceStmtNode s = ((ASTInterfaceBlockNode)this).getInterfaceStmt();
            if (s.getGenericName() != null) {
                return s.getGenericName().getGenericName();
            }
            if (s.getGenericSpec() != null && s.getGenericSpec().getEqualsToken() != null) {
                return s.getGenericSpec().getEqualsToken();
            }
            return s.getInterfaceToken();
        }
        if (this instanceof ASTSubmoduleNode) {
            return ((ASTSubmoduleNode)this).getSubmoduleStmt().getSubmoduleName().getModuleName();
        }
        if (this instanceof ASTBlockConstructNode) {
            return ((ASTBlockConstructNode)this).findFirstToken();
        }
        throw new UnsupportedOperationException();
    }

    public void clearAllCachedRepresentativeTokens() {
        this.accept(new Parser.ASTVisitor(){

            public void visitASTNode(Parser.IASTNode node) {
                if (ScopingNode.isScopingNode(node)) {
                    ((ScopingNode)node).cachedRepresentataiveToken = null;
                }
                super.visitASTNode(node);
            }
        });
    }

    public Parser.ASTNode getHeaderStmt() {
        if (this instanceof ASTExecutableProgramNode) {
            return null;
        }
        if (this instanceof ASTMainProgramNode) {
            return ((ASTMainProgramNode)this).getProgramStmt();
        }
        if (this instanceof ASTFunctionSubprogramNode) {
            return ((ASTFunctionSubprogramNode)this).getFunctionStmt();
        }
        if (this instanceof ASTSubroutineSubprogramNode) {
            return ((ASTSubroutineSubprogramNode)this).getSubroutineStmt();
        }
        if (this instanceof ASTModuleNode) {
            return ((ASTModuleNode)this).getModuleStmt();
        }
        if (this instanceof ASTBlockDataSubprogramNode) {
            return ((ASTBlockDataSubprogramNode)this).getBlockDataStmt();
        }
        if (this instanceof ASTDerivedTypeDefNode) {
            return ((ASTDerivedTypeDefNode)this).getDerivedTypeStmt();
        }
        if (this instanceof ASTInterfaceBlockNode) {
            return ((ASTInterfaceBlockNode)this).getInterfaceStmt();
        }
        if (this instanceof ASTSubmoduleNode) {
            return ((ASTSubmoduleNode)this).getSubmoduleStmt();
        }
        if (this instanceof ASTBlockConstructNode) {
            return ((ASTBlockConstructNode)this).getBlockStmt();
        }
        throw new UnsupportedOperationException();
    }

    public Parser.IASTListNode<? extends Parser.IASTNode> getBody() {
        if (this instanceof ASTExecutableProgramNode) {
            return null;
        }
        if (this instanceof ASTMainProgramNode) {
            return ((ASTMainProgramNode)this).getBody();
        }
        if (this instanceof ASTFunctionSubprogramNode) {
            return ((ASTFunctionSubprogramNode)this).getBody();
        }
        if (this instanceof ASTSubroutineSubprogramNode) {
            return ((ASTSubroutineSubprogramNode)this).getBody();
        }
        if (this instanceof ASTModuleNode) {
            return ((ASTModuleNode)this).getModuleBody();
        }
        if (this instanceof ASTBlockDataSubprogramNode) {
            return ((ASTBlockDataSubprogramNode)this).getBlockDataBody();
        }
        if (this instanceof ASTDerivedTypeDefNode) {
            return ((ASTDerivedTypeDefNode)this).getDerivedTypeBody();
        }
        if (this instanceof ASTInterfaceBlockNode) {
            return ((ASTInterfaceBlockNode)this).getInterfaceBlockBody();
        }
        if (this instanceof ASTSubmoduleNode) {
            return ((ASTSubmoduleNode)this).getModuleBody();
        }
        if (this instanceof ASTBlockConstructNode) {
            return ((ASTBlockConstructNode)this).getBody();
        }
        throw new UnsupportedOperationException();
    }

    public Parser.IASTListNode<? extends Parser.IASTNode> getOrCreateBody() {
        if (this.getBody() == null) {
            if (this instanceof ASTMainProgramNode) {
                ((ASTMainProgramNode)this).setBody(new Parser.ASTListNode<IBodyConstruct>());
            } else if (this instanceof ASTFunctionSubprogramNode) {
                ((ASTFunctionSubprogramNode)this).setBody(new Parser.ASTListNode<IBodyConstruct>());
            } else if (this instanceof ASTSubroutineSubprogramNode) {
                ((ASTSubroutineSubprogramNode)this).setBody(new Parser.ASTListNode<IBodyConstruct>());
            } else if (this instanceof ASTModuleNode) {
                ((ASTModuleNode)this).setModuleBody(new Parser.ASTListNode<IModuleBodyConstruct>());
            } else if (this instanceof ASTBlockDataSubprogramNode) {
                ((ASTBlockDataSubprogramNode)this).setBlockDataBody(new Parser.ASTListNode<IBlockDataBodyConstruct>());
            } else if (this instanceof ASTDerivedTypeDefNode) {
                ((ASTDerivedTypeDefNode)this).setDerivedTypeBody(new Parser.ASTListNode<IDerivedTypeBodyConstruct>());
            } else if (this instanceof ASTInterfaceBlockNode) {
                ((ASTInterfaceBlockNode)this).setInterfaceBlockBody(new Parser.ASTListNode<IInterfaceSpecification>());
            } else if (this instanceof ASTSubmoduleNode) {
                ((ASTSubmoduleNode)this).setModuleBody(new Parser.ASTListNode<IModuleBodyConstruct>());
            } else if (this instanceof ASTBlockConstructNode) {
                ((ASTBlockConstructNode)this).setBody(new Parser.ASTListNode<IBodyConstruct>());
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.getBody();
    }

    public boolean isSubprogram() {
        return this instanceof ASTFunctionSubprogramNode || this instanceof ASTSubroutineSubprogramNode;
    }

    public boolean isMainProgram() {
        return this instanceof ASTMainProgramNode;
    }

    public boolean isModule() {
        return this instanceof ASTModuleNode;
    }

    public boolean isInternal() {
        return this.getParent() instanceof IInternalSubprogram;
    }

    public ImplicitSpec getImplicitSpec() {
        return (ImplicitSpec)PhotranVPG.getDatabase().getAnnotation(this.getRepresentativeToken(), 2);
    }

    public boolean isImplicitNone() {
        return this.getImplicitSpec() == null;
    }

    public boolean isDefaultVisibilityPrivate() {
        return PhotranVPG.getDatabase().getAnnotation(this.getRepresentativeToken(), 0) != null;
    }

    public boolean isParentScopeOf(ScopingNode scope) {
        Parser.IASTNode node = scope.getParent();
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public List<ScopingNode> getAllContainedScopes() {
        final LinkedList<ScopingNode> scopes = new LinkedList<ScopingNode>();
        this.accept(new Parser.ASTVisitor(){

            public void visitASTNode(Parser.IASTNode node) {
                if (ScopingNode.isScopingNode(node)) {
                    scopes.add((ScopingNode)node);
                }
                super.visitASTNode(node);
            }
        });
        return scopes;
    }

    public ScopingNode findScopeDeclaringOrImporting(Token identifier) {
        try {
            this.manuallyResolve(identifier, new BindingResolutionCallback(){

                public void foundDefinition(PhotranTokenRef definition, ScopingNode scope) {
                    throw new Notification(scope);
                }
            });
            return null;
        }
        catch (Notification n) {
            return (ScopingNode)n.getResult();
        }
    }

    public Iterable<ScopingNode> findImportingScopes() {
        TreeSet<PhotranTokenRef> allReferences = new TreeSet<PhotranTokenRef>();
        for (Definition def : this.getAllDefinitions()) {
            if (def == null) continue;
            allReferences.addAll(def.findAllReferences(false));
        }
        final HashSet<PhotranTokenRef> scopes = new HashSet<PhotranTokenRef>();
        for (PhotranTokenRef ref : allReferences) {
            scopes.add(ref.findToken().findNearestAncestor(ScopingNode.class).getRepresentativeToken());
        }
        return new Iterable<ScopingNode>(){

            @Override
            public Iterator<ScopingNode> iterator() {
                return new TokenRefToScopeIterator(scopes);
            }
        };
    }

    public static ScopingNode findScopingNodeForRepresentativeToken(PhotranTokenRef tr) {
        PhotranVPG vpg = PhotranVPG.getInstance();
        if (tr.getOffset() < 0) {
            return ((IFortranAST)vpg.acquireTransientAST(tr.getFilename())).getRoot();
        }
        return vpg.findToken(tr).findNearestAncestor(ScopingNode.class);
    }

    public List<PhotranTokenRef> manuallyResolve(Token identifier) {
        String canonicalizedIdentifier = null;
        if (PhotranVPG.getInstance().isDefinitionCachingEnabled() && this.definitionCache.containsKey(canonicalizedIdentifier = PhotranVPG.canonicalizeIdentifier(identifier.getText()))) {
            return this.definitionCache.get(canonicalizedIdentifier);
        }
        final LinkedList<PhotranTokenRef> bindings = new LinkedList<PhotranTokenRef>();
        this.manuallyResolve(identifier, new BindingResolutionCallback(){

            public void foundDefinition(PhotranTokenRef definition, ScopingNode scope) {
                bindings.add(definition);
            }
        });
        if (PhotranVPG.getInstance().isDefinitionCachingEnabled()) {
            this.definitionCache.put(canonicalizedIdentifier, bindings);
        }
        return bindings;
    }

    public List<PhotranTokenRef> manuallyResolveInLocalScope(Token identifier) {
        final LinkedList<PhotranTokenRef> bindings = new LinkedList<PhotranTokenRef>();
        this.manuallyResolveInLocalScope(identifier, new BindingResolutionCallback(){

            public void foundDefinition(PhotranTokenRef definition, ScopingNode scope) {
                bindings.add(definition);
            }
        });
        return bindings;
    }

    private void manuallyResolve(Token identifier, BindingResolutionCallback result) {
        if (!(this.manuallyResolveInLocalScope(identifier, result) || this.manuallyResolveInParentScopes(identifier, result) || this.manuallyResolveIntrinsic(identifier, result))) {
            this.attemptToDeclareImplicit(identifier, result);
        }
    }

    public List<PhotranTokenRef> manuallyResolveNoImplicits(Token identifier) {
        final LinkedList<PhotranTokenRef> bindings = new LinkedList<PhotranTokenRef>();
        this.manuallyResolveNoImplicits(identifier, new BindingResolutionCallback(){

            public void foundDefinition(PhotranTokenRef definition, ScopingNode scope) {
                bindings.add(definition);
            }
        });
        return bindings;
    }

    private void manuallyResolveNoImplicits(Token identifier, BindingResolutionCallback result) {
        if (!this.manuallyResolveInLocalScope(identifier, result) && !this.manuallyResolveInParentScopes(identifier, result)) {
            this.manuallyResolveIntrinsic(identifier, result);
        }
    }

    private boolean manuallyResolveInLocalScope(Token identifier, BindingResolutionCallback bindings) {
        String name = PhotranVPG.canonicalizeIdentifier(identifier.getText());
        boolean wasSuccessful = false;
        for (Definition def : this.getAllDefinitions()) {
            if (def == null || !def.matches(name)) continue;
            bindings.foundDefinition(def.getTokenRef(), this);
            wasSuccessful = true;
        }
        return wasSuccessful;
    }

    private boolean manuallyResolveInParentScopes(Token identifier, BindingResolutionCallback bindings) {
        ScopingNode scope = this.getEnclosingScope();
        while (scope != null) {
            if (scope.manuallyResolveInLocalScope(identifier, bindings)) {
                return true;
            }
            scope = scope.getEnclosingScope();
        }
        return false;
    }

    private boolean manuallyResolveIntrinsic(Token identifier, BindingResolutionCallback bindings) {
        Definition def = Intrinsics.resolveIntrinsic(identifier);
        if (def == null) {
            return false;
        }
        ((PhotranVPGBuilder)PhotranVPG.getInstance()).setDefinitionFor(identifier.getTokenRef(), def);
        return true;
    }

    private void attemptToDeclareImplicit(Token identifier, BindingResolutionCallback bindings) {
        PhotranVPGBuilder vpg = (PhotranVPGBuilder)PhotranVPG.getInstance();
        ImplicitSpec implicitSpec = this.getImplicitSpec();
        if (implicitSpec == null) {
            return;
        }
        if (identifier instanceof Token.FakeToken) {
            return;
        }
        String name = PhotranVPG.canonicalizeIdentifier(identifier.getText());
        PhotranTokenRef tokenRef = identifier.getTokenRef();
        Type type = implicitSpec.getType(name.charAt(0));
        Definition.Classification classification = Definition.Classification.IMPLICIT_LOCAL_VARIABLE;
        classification = this.isSubroutineNameInCallStmt(identifier) || this.isFunctionNameInFunctionCall(identifier) ? Definition.Classification.IMPLICIT_EXTERNAL_SUBPROGRAM : Definition.Classification.IMPLICIT_LOCAL_VARIABLE;
        Definition def = new Definition(identifier.getText(), tokenRef, classification, type);
        vpg.setDefinitionFor(tokenRef, def);
        vpg.markScope(tokenRef, this);
        vpg.markDefinitionVisibilityInScope(tokenRef, this, Definition.Visibility.PUBLIC);
        bindings.foundDefinition(tokenRef, this.getGlobalScope());
    }

    private boolean isSubroutineNameInCallStmt(Token identifier) {
        ASTCallStmtNode call = identifier.findNearestAncestor(ASTCallStmtNode.class);
        if (call != null && call.getSubroutineName() != null) {
            return this.matches(call.getSubroutineName(), identifier);
        }
        return false;
    }

    private boolean isFunctionNameInFunctionCall(Token identifier) {
        ASTVarOrFnRefNode call = identifier.findNearestAncestor(ASTVarOrFnRefNode.class);
        if (call != null && call.getName() != null) {
            return this.matches(call.getName().getName(), identifier) && (call.getPrimarySectionSubscriptList() != null || call.getFunctionArgList() != null);
        }
        return false;
    }

    private boolean matches(Token identifier1, Token identifier2) {
        if (identifier1 == null || identifier2 == null) {
            return false;
        }
        return PhotranVPG.canonicalizeIdentifier(identifier1.getText()).equals(PhotranVPG.canonicalizeIdentifier(identifier2.getText()));
    }

    public List<Definition> getAllDefinitions() {
        PhotranVPG vpg = PhotranVPG.getInstance();
        LinkedList<Definition> result = new LinkedList<Definition>();
        for (PhotranTokenRef t : vpg.db.getIncomingEdgeSources(this.getRepresentativeToken(), 0)) {
            result.add(vpg.getDefinitionFor(t));
        }
        return result;
    }

    public List<Definition> getAllPublicDefinitions() {
        PhotranVPG vpg = PhotranVPG.getInstance();
        LinkedList<Definition> result = new LinkedList<Definition>();
        for (Definition def : this.getAllDefinitions()) {
            if (def == null || !vpg.getVisibilityFor(def, this).equals((Object)Definition.Visibility.PUBLIC)) continue;
            result.add(def);
        }
        return result;
    }

    public IMarker createMarker() {
        Token lastToken;
        Token firstToken;
        block3: {
            try {
                firstToken = this.findFirstTokenIn(this);
                lastToken = this.findLastTokenIn(this);
                if (firstToken != null && lastToken != null && firstToken.getIFile() != null) break block3;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        int startOffset = firstToken.getFileOffset();
        int endOffset = lastToken.getFileOffset() + lastToken.getLength();
        IMarker marker = firstToken.getIFile().createMarker("org.eclipse.core.resources.textmarker");
        marker.setAttribute("charStart", startOffset -= firstToken.getWhiteBefore().length());
        marker.setAttribute("charEnd", endOffset);
        return marker;
    }

    protected Token findFirstTokenIn(Parser.ASTNode node) {
        try {
            node.accept(new Parser.ASTVisitor(){

                public void visitToken(Token token) {
                    throw new Notification(token);
                }
            });
        }
        catch (Notification n) {
            return (Token)n.getResult();
        }
        return null;
    }

    protected Token findLastTokenIn(Parser.ASTNode node) {
        LastTokenVisitor lastTokenVisitor = new LastTokenVisitor();
        node.accept(lastTokenVisitor);
        return lastTokenVisitor.getLastToken();
    }

    public boolean isNamed(String targetName) {
        String name = this.getName();
        if (name == null) {
            return false;
        }
        String actualName = PhotranVPG.canonicalizeIdentifier(name);
        String expectedName = PhotranVPG.canonicalizeIdentifier(targetName);
        return actualName.equals(expectedName);
    }

    public String getName() {
        return this.getName(PhotranVPG.getDatabase().isInHypotheticalMode());
    }

    public String getName(boolean force) {
        Token nameToken = this.getNameToken(force);
        return nameToken == null ? null : nameToken.getText();
    }

    public Token getNameToken() {
        return this.getNameToken(PhotranVPG.getDatabase().isInHypotheticalMode());
    }

    public Token getNameToken(boolean force) {
        Token repToken;
        Token token = repToken = force ? this.internalGetRepresentativeToken() : this.getRepresentativeToken().findTokenOrReturnNull();
        if (repToken == null || repToken.getTerminal() != Terminal.T_IDENT) {
            return null;
        }
        return repToken;
    }

    public String describe() {
        Token nameToken = this.getNameToken();
        if (nameToken == null) {
            return "(anonymous)";
        }
        return nameToken.getText();
    }

    private static interface BindingResolutionCallback {
        public void foundDefinition(PhotranTokenRef var1, ScopingNode var2);
    }

    private static final class LastTokenVisitor
    extends Parser.ASTVisitor {
        private Token lastToken;

        private LastTokenVisitor() {
        }

        public void visitToken(Token token) {
            this.lastToken = token;
        }

        public Token getLastToken() {
            return this.lastToken;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TokenRefToScopeIterator
    implements Iterator<ScopingNode> {
        private Iterator<PhotranTokenRef> it;

        public TokenRefToScopeIterator(Set<PhotranTokenRef> scopes) {
            this.it = scopes.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ScopingNode next() {
            return ScopingNode.findScopingNodeForRepresentativeToken(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

