/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockNode;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockObjectNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.MultipleFileFortranRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SingleFileFortranRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonVarNamesRefactoring
extends SingleFileFortranRefactoring {
    private String commonBlockName = null;
    private HashMap<String, Integer> oldVarNames = new HashMap();
    private HashMap<Integer, String> newVarNames = new HashMap();
    private HashMap<Integer, Definition> varDefs = new HashMap();
    private int numCommonVars = 0;
    private ArrayList<String> oldNames = new ArrayList();
    private ArrayList<String> newNames = new ArrayList();
    private ASTCommonBlockNode commonBlockNode = null;
    private List<IFile> filesContainingCommonBlock = null;

    public String getName() {
        return "Make COMMON Variable Names Consistent";
    }

    public int getNumCommonVars() {
        return this.numCommonVars;
    }

    public ArrayList<String> getOldVarNames() {
        return this.oldNames;
    }

    public ArrayList<String> getNewVarNames() {
        return this.newNames;
    }

    public void modifyNewName(int varNum, String newName) {
        this.newVarNames.put(varNum, PhotranVPG.canonicalizeIdentifier(newName));
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.commonBlockName = this.selectedRegionInEditor.getText();
        Token token = this.findEnclosingToken();
        this.commonBlockNode = token.findNearestAncestor(ASTCommonBlockNode.class);
        if (this.commonBlockNode == null) {
            this.fail("No COMMON block found with name '" + this.commonBlockName + "'.");
        }
        this.filesContainingCommonBlock = PhotranVPG.getInstance().findFilesThatUseCommonBlock(this.commonBlockName);
        if (this.filesContainingCommonBlock.isEmpty()) {
            this.fail("No files found containing the specified COMMON block.");
        } else {
            this.filterCommonBlockFileList();
        }
        this.numCommonVars = this.commonBlockNode.getCommonBlockObjectList().size();
        this.hashOldAndNewNames();
        this.getVariableTypes();
    }

    private Token findEnclosingToken() throws VPGRefactoring.PreconditionFailure {
        Token selectedToken = CommonVarNamesRefactoring.findEnclosingToken(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (selectedToken == null) {
            this.fail("Please select a COMMON block name (highlight the name, excluding /'s)");
        }
        return selectedToken;
    }

    private void filterCommonBlockFileList() throws VPGRefactoring.PreconditionFailure {
        IProject projectInEditor = this.fileInEditor.getProject();
        if (projectInEditor == null) {
            this.fail("Project does not exist!");
        }
        int i = 0;
        while (i < this.filesContainingCommonBlock.size()) {
            if (this.filesContainingCommonBlock.get(i) == null || !this.filesContainingCommonBlock.get(i).getProject().equals((Object)projectInEditor)) {
                this.filesContainingCommonBlock.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void hashOldAndNewNames() {
        Parser.IASTListNode<ASTCommonBlockObjectNode> commonObjects = this.commonBlockNode.getCommonBlockObjectList();
        Iterator iter = commonObjects.iterator();
        int varNameNumber = 0;
        while (iter.hasNext()) {
            String varName = PhotranVPG.canonicalizeIdentifier(((ASTCommonBlockObjectNode)iter.next()).getVariableName().getText());
            this.oldNames.add(varName);
            varName = varName.replaceAll("_common", "");
            String newName = varName.concat("_common");
            this.newNames.add(newName);
            this.oldVarNames.put(varName, varNameNumber);
            this.newVarNames.put(varNameNumber, newName);
            ++varNameNumber;
        }
    }

    private void getVariableTypes() {
        Parser.IASTListNode<ASTCommonBlockObjectNode> commonObjects = this.commonBlockNode.getCommonBlockObjectList();
        int varNameNumber = 0;
        Definition originalDef = null;
        for (ASTCommonBlockObjectNode current : commonObjects) {
            originalDef = current.getVariableName().resolveBinding().get(0);
            this.varDefs.put(varNameNumber, originalDef);
            ++varNameNumber;
        }
    }

    private void checkConflictingBindings(ASTCommonBlockNode node, IProgressMonitor pm, RefactoringStatus status) {
        Definition defToRename = null;
        Collection<String> newNames = this.newVarNames.values();
        Set<PhotranTokenRef> allReferences = null;
        Iterator blockIter = node.getCommonBlockObjectList().iterator();
        Iterator<String> nameIter = newNames.iterator();
        while (blockIter.hasNext() && nameIter.hasNext()) {
            String newName;
            defToRename = ((ASTCommonBlockObjectNode)blockIter.next()).getVariableName().resolveBinding().get(0);
            allReferences = defToRename.findAllReferences(true);
            String oldName = defToRename.getCanonicalizedName();
            if (oldName.equalsIgnoreCase(newName = PhotranVPG.canonicalizeIdentifier(nameIter.next()))) continue;
            CommonVarNamesRefactoring.checkForConflictingBindings(pm, (MultipleFileFortranRefactoring.IConflictingBindingCallback)new ConflictingBindingErrorHandler(status), defToRename, allReferences, newName);
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        assert (this.filesContainingCommonBlock != null);
        try {
            for (IFile file : this.filesContainingCommonBlock) {
                this.makeChangesTo(file, pm, status);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IProgressMonitor pm, RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
        if (ast == null) {
            return;
        }
        try {
            ConsistencyVisitor replacer = new ConsistencyVisitor(pm, status);
            ast.accept(replacer);
            this.addChangeFromModifiedAST(file, pm);
        }
        catch (TypeError e) {
            this.fail(e.getMessage());
        }
        ((PhotranVPG)this.vpg).releaseAST(file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConflictingBindingErrorHandler
    implements MultipleFileFortranRefactoring.IConflictingBindingCallback {
        private final RefactoringStatus status;

        private ConflictingBindingErrorHandler(RefactoringStatus status) {
            this.status = status;
        }

        @Override
        public void addConflictError(List<MultipleFileFortranRefactoring.Conflict> conflictingDef) {
            MultipleFileFortranRefactoring.Conflict conflict = conflictingDef.get(0);
            String msg = "The name \"" + conflict.name + "\" conflicts with " + ((PhotranVPG)CommonVarNamesRefactoring.this.vpg).getDefinitionFor(conflict.tokenRef);
            RefactoringStatusContext context = CommonVarNamesRefactoring.this.createContext(conflict.tokenRef);
            this.status.addError(msg, context);
        }

        @Override
        public void addConflictWarning(List<MultipleFileFortranRefactoring.Conflict> conflictingDef) {
            MultipleFileFortranRefactoring.Conflict conflict = conflictingDef.get(0);
            String msg = "The name \"" + conflict.name + "\" might conflict with the name of an invoked subprogram";
            RefactoringStatusContext context = CommonVarNamesRefactoring.this.createContext(conflict.tokenRef);
            this.status.addWarning(msg, context);
        }

        @Override
        public void addReferenceWillChangeError(String newName, Token reference) {
        }
    }

    private final class ConsistencyVisitor
    extends Parser.GenericASTVisitor {
        private IProgressMonitor pm;
        private RefactoringStatus status;
        private boolean changedAST = false;
        private boolean changeNames = false;
        private HashMap<String, Integer> oldVarNameHash = new HashMap();
        private HashMap<Integer, Definition> blockVarDefs = new HashMap();

        public ConsistencyVisitor(IProgressMonitor pm, RefactoringStatus status) {
            this.pm = pm;
            this.status = status;
        }

        public void visitASTCommonBlockNode(ASTCommonBlockNode node) {
            if (node.getName() == null && !CommonVarNamesRefactoring.this.commonBlockName.equals("")) {
                return;
            }
            if (node.getName() == null && CommonVarNamesRefactoring.this.commonBlockName.equals("") || CommonVarNamesRefactoring.this.commonBlockName.equalsIgnoreCase(node.getName().getCommonBlockName().getText())) {
                CommonVarNamesRefactoring.this.checkConflictingBindings(node, this.pm, this.status);
                this.hashVarNames(node);
            }
        }

        public void visitToken(Token node) {
            if (this.changeNames) {
                for (Definition variable : this.blockVarDefs.values()) {
                    if (!variable.findAllReferences(true).contains(node.getTokenRef()) && !variable.getTokenRef().equals(node.getTokenRef())) continue;
                    try {
                        this.changeName(node);
                    }
                    catch (TypeError e) {
                        throw new TypeError(e.getMessage());
                    }
                }
            }
        }

        private void hashVarNames(ASTCommonBlockNode node) {
            Parser.IASTListNode<ASTCommonBlockObjectNode> objects = node.getCommonBlockObjectList();
            int varNameNumber = 0;
            for (ASTCommonBlockObjectNode current : objects) {
                String currentVarName = current.getVariableName().getText();
                this.oldVarNameHash.put(PhotranVPG.canonicalizeIdentifier(currentVarName), varNameNumber);
                Definition currentDef = current.getVariableName().resolveBinding().get(0);
                this.blockVarDefs.put(varNameNumber, currentDef);
                ++varNameNumber;
            }
            this.changeNames = true;
        }

        private void changeName(Token node) {
            int newNameNumber = this.oldVarNameHash.get(node.getText());
            Definition origDef = (Definition)CommonVarNamesRefactoring.this.varDefs.get(newNameNumber);
            Definition thisDef = this.blockVarDefs.get(newNameNumber);
            if (origDef != null && thisDef != null) {
                if (thisDef.getType().equals(origDef.getType()) || thisDef.isImplicit() || origDef.isImplicit()) {
                    String name = (String)CommonVarNamesRefactoring.this.newVarNames.get(newNameNumber);
                    node.setText(name);
                    this.changedAST = true;
                } else {
                    throw new TypeError("Variable types differ in different uses of the specified COMMON block. Refactoring will not proceed.");
                }
            }
        }
    }

    private final class TypeError
    extends Error {
        private static final long serialVersionUID = 1L;

        public TypeError(String message) {
            super(message);
        }
    }
}

