/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDataStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDataStmtSetNode;
import org.eclipse.photran.internal.core.parser.ASTDataStmtValueNode;
import org.eclipse.photran.internal.core.parser.ASTDatalistNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.parser.IDataStmtObject;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.MultipleFileFortranRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.Reindenter;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SourcePrinter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataToParameterRefactoring
extends MultipleFileFortranRefactoring {
    private List<String> astAssignmentStmtNames = new LinkedList<String>();
    private List<Parser.IASTNode> parameter_nodes = new LinkedList<Parser.IASTNode>();
    private List<Parser.IASTNode> nodes_to_delete = new LinkedList<Parser.IASTNode>();
    private List<ASTDataStmtValueNode> values_to_delete = new LinkedList<ASTDataStmtValueNode>();
    private List<IDataStmtObject> statements_to_delete = new LinkedList<IDataStmtObject>();
    private Parser.IASTListNode<IDataStmtObject> statement_list = null;
    private Parser.IASTListNode<ASTDataStmtValueNode> value_list = null;
    private int statement_count = 0;
    private boolean hasChanged = false;

    public String getName() {
        return "Data To Parameter";
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError("One of the selected files (" + file.getName() + ") cannot be parsed.");
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void populateAssignmentStmtNames(Parser.IASTListNode<Parser.IASTNode> body) {
        for (Parser.IASTNode node : body) {
            if (!(node instanceof ASTAssignmentStmtNode)) continue;
            String name = ((ASTAssignmentStmtNode)node).getLhsVariable().getName().getText();
            this.astAssignmentStmtNames.add(name);
        }
    }

    private void clearLists() {
        this.astAssignmentStmtNames.clear();
        this.parameter_nodes.clear();
        this.nodes_to_delete.clear();
        this.values_to_delete.clear();
        this.statements_to_delete.clear();
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        List<ScopingNode> scopes = ast.getRoot().getAllContainedScopes();
        for (ScopingNode scope : scopes) {
            this.clearLists();
            if (scope instanceof ASTExecutableProgramNode || scope instanceof ASTDerivedTypeDefNode) continue;
            Parser.IASTListNode<Parser.IASTNode> body = scope.getBody();
            this.populateAssignmentStmtNames(body);
            for (Parser.IASTNode node : body) {
                if (!(node instanceof ASTDataStmtNode)) continue;
                this.processDataStmtNode((ASTDataStmtNode)node, ast);
            }
            int i = 0;
            while (i < this.parameter_nodes.size()) {
                body.insertAfter(this.parameter_nodes.get(i), this.parameter_nodes.get(i + 1));
                Reindenter.reindent(this.parameter_nodes.get(i + 1), ast);
                i += 2;
            }
            i = 0;
            while (i < this.nodes_to_delete.size()) {
                ASTDataStmtNode delete = (ASTDataStmtNode)this.nodes_to_delete.get(i);
                if (body.contains(delete)) {
                    delete.removeFromTree();
                }
                ++i;
            }
            this.removeFrontComma(body, ast);
        }
        if (this.hasChanged) {
            status.addWarning("This refactoring is NOT considering variable assignment that could happen as a result of passing a variable to a function/subroutine by reference.");
            this.addChangeFromModifiedAST(file, pm);
        }
    }

    private void removeFrontComma(Parser.IASTListNode<Parser.IASTNode> body, IFortranAST ast) {
        Parser.IASTNode comma = null;
        for (Parser.IASTNode node : body) {
            if (!(node instanceof ASTDataStmtNode)) continue;
            comma = node;
            String source_comma = SourcePrinter.getSourceCodeFromASTNode(comma);
            String[] source_comma_split = source_comma.split("\n");
            String statement = source_comma_split[source_comma_split.length - 1].trim();
            String data = statement.substring(0, 4);
            String list_data = statement.substring(4);
            if (!(list_data = list_data.trim()).startsWith(",")) continue;
            list_data = list_data.substring(1);
            list_data = list_data.trim();
            String new_source = new String("");
            int i = 0;
            while (i < source_comma_split.length - 1) {
                new_source = String.valueOf(new_source) + source_comma_split[i] + "\n";
                ++i;
            }
            new_source = String.valueOf(new_source) + data + " " + list_data;
            IBodyConstruct without_comma = DataToParameterRefactoring.parseLiteralStatement(new_source);
            comma.replaceWith(without_comma);
            Reindenter.reindent(without_comma, ast);
        }
    }

    private void transformToParameter(ASTDataStmtNode node, IFortranAST ast) {
        String parameter_name = ((IDataStmtObject)this.statement_list.get(this.statement_count)).toString().trim();
        if (!this.astAssignmentStmtNames.contains(parameter_name)) {
            this.hasChanged = true;
            IBodyConstruct parameter = null;
            String source = SourcePrinter.getSourceCodeFromASTNode(node);
            String[] source_split = source.split("\n");
            StringBuffer parameter_statement = new StringBuffer("parameter ( ");
            parameter_statement.append(String.valueOf(parameter_name) + " = ");
            String value = ((ASTDataStmtValueNode)this.value_list.get(this.statement_count)).getConstant().toString().trim();
            parameter_statement.append(String.valueOf(value) + " )");
            String comments_end_of_line = source_split[source_split.length - 1];
            boolean has_comment = false;
            int index_comment = 0;
            index_comment = 0;
            while (index_comment < comments_end_of_line.length()) {
                if (comments_end_of_line.charAt(index_comment) == '!') {
                    has_comment = true;
                    break;
                }
                ++index_comment;
            }
            if (has_comment) {
                parameter_statement.append(" " + comments_end_of_line.substring(index_comment));
            }
            parameter = DataToParameterRefactoring.parseLiteralStatement(parameter_statement.toString());
            this.parameter_nodes.add(node);
            this.parameter_nodes.add(parameter);
            ASTDataStmtValueNode value_to_remove = (ASTDataStmtValueNode)this.value_list.get(this.statement_count);
            IDataStmtObject statement_to_remove = (IDataStmtObject)this.statement_list.get(this.statement_count);
            this.values_to_delete.add(value_to_remove);
            this.statements_to_delete.add(statement_to_remove);
        }
    }

    private void processDataStmtNode(ASTDataStmtNode node, IFortranAST ast) throws VPGRefactoring.PreconditionFailure {
        Parser.IASTListNode<ASTDatalistNode> data_list = node.getDatalist();
        if (data_list == null) {
            throw new VPGRefactoring.PreconditionFailure("Data list of a node was empty. Refactoring failed");
        }
        int data_list_size = data_list.size();
        for (ASTDatalistNode data_node : data_list) {
            ASTDataStmtSetNode stmt_set_node = data_node.getDataStmtSet();
            this.statement_list = stmt_set_node.getDataStmtObjectList();
            this.value_list = stmt_set_node.getDataStmtValueList();
            this.statement_count = 0;
            this.values_to_delete.clear();
            this.statements_to_delete.clear();
            this.statement_count = 0;
            while (this.statement_count < this.statement_list.size()) {
                this.transformToParameter(node, ast);
                ++this.statement_count;
            }
            data_list_size = this.removeASTEntries(node, data_node, data_list_size, ast);
        }
    }

    private int removeASTEntries(ASTDataStmtNode node, ASTDatalistNode data_node, int data_list_size, IFortranAST ast) {
        if (this.statement_list.size() == this.statements_to_delete.size()) {
            data_node.removeFromTree();
            if (--data_list_size == 0) {
                IBodyConstruct parameter = null;
                String source = SourcePrinter.getSourceCodeFromASTNode(node);
                String[] source_split = source.split("\n");
                String comments_before_line = new String("");
                int i = 0;
                while (i < source_split.length - 1) {
                    comments_before_line = String.valueOf(comments_before_line) + source_split[i] + "\n";
                    ++i;
                }
                Parser.IASTNode last_parameter_node = this.parameter_nodes.get(this.parameter_nodes.size() - 1);
                String last_parameter_node_source = SourcePrinter.getSourceCodeFromASTNode(last_parameter_node);
                String last_parameter_with_comments = String.valueOf(comments_before_line) + last_parameter_node_source;
                parameter = DataToParameterRefactoring.parseLiteralStatement(last_parameter_with_comments);
                this.parameter_nodes.remove(this.parameter_nodes.size() - 1);
                this.parameter_nodes.add(parameter);
                this.nodes_to_delete.add(node);
            }
        } else {
            this.statement_list.removeAll(this.statements_to_delete);
            for (IDataStmtObject n : this.statement_list) {
                n.findFirstToken().setWhiteBefore(" ");
            }
            this.value_list.removeAll(this.values_to_delete);
        }
        return data_list_size;
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }
}

