/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTEndDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTLabelDoStmtNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.Reindenter;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SingleFileFortranRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class InterchangeLoopsRefactoring
extends SingleFileFortranRefactoring {
    private ASTProperLoopConstructNode outerLoop = null;
    private ASTProperLoopConstructNode innerLoop = null;

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        LoopReplacer.replaceAllLoopsIn(this.astOfFileInEditor.getRoot());
        this.outerLoop = this.findOuterLoop();
        this.innerLoop = this.findInnerLoop();
        if (this.outerLoop == null || this.innerLoop == null || this.outerLoop == this.innerLoop) {
            this.fail("Please select two perfectly-nested loops to refactor.");
        }
        status.addWarning("WARNING: This is an UNCHECKED TRANSFORMATION and is NOT guaranteed to preserve behavior.  Proceed at your own risk.");
    }

    private ASTProperLoopConstructNode findOuterLoop() {
        return InterchangeLoopsRefactoring.getLoopNode(this.astOfFileInEditor, this.selectedRegionInEditor);
    }

    private ASTProperLoopConstructNode findInnerLoop() {
        if (this.outerLoop != null) {
            return InterchangeLoopsRefactoring.getLoopNode(this.outerLoop.getBody().findFirstToken(), this.outerLoop.getBody().findLastToken());
        }
        return null;
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.swapHeaders();
        this.swapEndDoStmt();
        this.swapComments();
        Reindenter.reindent(this.outerLoop, this.astOfFileInEditor, Reindenter.Strategy.REINDENT_EACH_LINE);
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    protected void swapHeaders() {
        ASTLabelDoStmtNode outerHeader = this.outerLoop.getLoopHeader();
        ASTLabelDoStmtNode innerHeader = this.innerLoop.getLoopHeader();
        this.swap(outerHeader, innerHeader);
    }

    protected void swapEndDoStmt() {
        ASTEndDoStmtNode outerEnd = this.outerLoop.getEndDoStmt();
        ASTEndDoStmtNode innerEnd = this.innerLoop.getEndDoStmt();
        this.swap(outerEnd, innerEnd);
    }

    protected void swapComments() {
        Token outerLoopDoToken = this.outerLoop.getLoopHeader().findFirstToken();
        Token innerLoopDoToken = this.innerLoop.getLoopHeader().findFirstToken();
        String outerLoopWhiteText = outerLoopDoToken.getWhiteBefore();
        String innerLoopWhiteText = innerLoopDoToken.getWhiteBefore();
        innerLoopDoToken.setWhiteBefore(outerLoopWhiteText);
        outerLoopDoToken.setWhiteBefore(innerLoopWhiteText);
    }

    protected void swap(Parser.ASTNode outerElement, Parser.ASTNode innerElement) {
        outerElement.setParent(this.innerLoop);
        innerElement.setParent(this.outerLoop);
        this.innerLoop.replaceChild(innerElement, outerElement);
        this.outerLoop.replaceChild(outerElement, innerElement);
    }

    public String getName() {
        return "Interchange Loops (Unchecked)";
    }
}

