/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTOnlyNode;
import org.eclipse.photran.internal.core.parser.ASTUseStmtNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.Reindenter;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SingleFileFortranRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class MinOnlyListRefactoring
extends SingleFileFortranRefactoring {
    private String moduleName;
    private ASTUseStmtNode useNode = null;
    private List<IFile> filesContainingModule = null;
    private List<Definition> moduleEntityDefs = new ArrayList<Definition>();
    private ArrayList<String> moduleEntityNames = new ArrayList();
    private ArrayList<String> existingOnlyListNames = new ArrayList();
    private ArrayList<String> onlyNamesToKeep = new ArrayList();
    private int numOnlysToKeep = 0;

    public String getModuleName() {
        return this.moduleName;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.moduleName = this.selectedRegionInEditor.getText();
        if (this.moduleName == null || this.moduleName.equals("")) {
            this.fail("No module name selected.");
        }
        this.findUseStmtNode();
        this.checkIfModuleExistsInProject();
        this.getModuleDeclaredEntities(pm);
        this.readExistingOnlyList();
    }

    private void findUseStmtNode() throws VPGRefactoring.PreconditionFailure {
        Token token = this.findEnclosingToken();
        if (token == null) {
            this.fail("Please select the name of the module in the USE statement.");
        }
        this.useNode = token.findNearestAncestor(ASTUseStmtNode.class);
        if (this.useNode == null) {
            this.fail("Use statement node could not be found.");
        }
    }

    private void checkIfModuleExistsInProject() throws VPGRefactoring.PreconditionFailure {
        this.filesContainingModule = ((PhotranVPG)this.vpg).findFilesThatExportModule(this.moduleName);
        if (this.filesContainingModule.isEmpty() || this.filesContainingModule == null) {
            this.fail("No files in this project contain the module - " + this.moduleName);
        } else if (this.filesContainingModule.size() > 1) {
            this.filterFileList();
        }
        if (this.filesContainingModule.isEmpty() || this.filesContainingModule == null) {
            this.fail("No files in this project contain the module - " + this.moduleName);
        }
    }

    private void filterFileList() throws VPGRefactoring.PreconditionFailure {
        IProject projectInEditor = this.fileInEditor.getProject();
        if (projectInEditor == null) {
            this.fail("Project does not exist!");
        }
        int i = 0;
        while (i < this.filesContainingModule.size()) {
            if (this.filesContainingModule.get(i) == null || this.filesContainingModule.get(i).getProject() != projectInEditor) {
                this.filesContainingModule.remove(i);
                continue;
            }
            ++i;
        }
    }

    private Token findEnclosingToken() throws VPGRefactoring.PreconditionFailure {
        Token selectedToken = MinOnlyListRefactoring.findEnclosingToken(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (selectedToken == null) {
            this.fail("Please select a module name.");
        }
        return selectedToken;
    }

    private void getModuleDeclaredEntities(IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        ASTModuleNode moduleNode;
        Token moduleToken;
        PhotranTokenRef moduleTokenRef = ((PhotranVPG)this.vpg).getModuleTokenRef(this.moduleName);
        if (moduleTokenRef == null) {
            this.fail("No module with name " + this.moduleName + "found.");
        }
        if ((moduleToken = moduleTokenRef.findTokenOrReturnNull()) == null) {
            this.fail("Module token could not be found.");
        }
        if ((moduleNode = moduleToken.findNearestAncestor(ASTModuleNode.class)) == null) {
            this.fail("Module Node could not be found.");
        }
        this.moduleEntityDefs = moduleNode.getAllPublicDefinitions();
        if (this.moduleEntityDefs.isEmpty()) {
            this.fail("Module contains no declared entities. No ONLY clause is necessary.Please remove the ONLY clause from USE statement.");
        } else {
            int i = 0;
            while (i < this.moduleEntityDefs.size()) {
                this.moduleEntityNames.add(this.moduleEntityDefs.get(i).getCanonicalizedName());
                ++i;
            }
        }
    }

    private void readExistingOnlyList() {
        Parser.ASTSeparatedListNode existingOnlys = (Parser.ASTSeparatedListNode)this.useNode.getOnlyList();
        if (existingOnlys != null) {
            ASTOnlyNode onlyNode = null;
            int i = 0;
            while (i < existingOnlys.size()) {
                onlyNode = (ASTOnlyNode)existingOnlys.get(i);
                String name = PhotranVPG.canonicalizeIdentifier(onlyNode.getName().getText().trim());
                if (this.moduleEntityNames.contains(name)) {
                    if (onlyNode.isRenamed()) {
                        this.existingOnlyListNames.add(onlyNode.getNewName().getText());
                    }
                    this.existingOnlyListNames.add(name);
                }
                ++i;
            }
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IFile file = this.fileInEditor;
        IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
        if (ast == null) {
            return;
        }
        OnlyTokenVisitor visitor = new OnlyTokenVisitor();
        ast.accept(visitor);
        if (this.numOnlysToKeep == this.moduleEntityDefs.size()) {
            this.removeOnlyList(pm, ast);
        } else if (this.onlyNamesToKeep.isEmpty()) {
            this.useNode.removeFromTree();
        } else {
            this.createAndAddMinOnlyList(pm, ast);
        }
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(file);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    private void removeOnlyList(IProgressMonitor pm, IFortranAST ast) {
        if (ast == null) {
            return;
        }
        ASTUseStmtNode newStmtNode = (ASTUseStmtNode)MinOnlyListRefactoring.parseLiteralStatement("use " + this.useNode.getName().getText() + System.getProperty("line.separator"));
        Parser.ASTListNode body = (Parser.ASTListNode)this.useNode.getParent();
        body.replaceChild(this.useNode, newStmtNode);
        Reindenter.reindent(newStmtNode, ast);
    }

    private void createAndAddMinOnlyList(IProgressMonitor pm, IFortranAST ast) {
        if (ast == null) {
            return;
        }
        String list = "";
        int counter = 0;
        while (counter < this.onlyNamesToKeep.size()) {
            String name = this.onlyNamesToKeep.get(counter);
            if (!this.moduleEntityNames.contains(name)) {
                list = String.valueOf(list) + name + " => ";
                name = this.onlyNamesToKeep.get(++counter);
            }
            list = String.valueOf(list) + name;
            if (counter < this.onlyNamesToKeep.size() - 1) {
                list = String.valueOf(list) + ", ";
            }
            ++counter;
        }
        ASTUseStmtNode newStmtNode = (ASTUseStmtNode)MinOnlyListRefactoring.parseLiteralStatement("use " + this.useNode.getName().getText() + ", only: " + list + System.getProperty("line.separator"));
        Parser.ASTListNode body = (Parser.ASTListNode)this.useNode.getParent();
        body.replaceChild(this.useNode, newStmtNode);
        Reindenter.reindent(newStmtNode, ast);
    }

    public String getName() {
        return "Minimize ONLY List";
    }

    private final class OnlyTokenVisitor
    extends Parser.GenericASTVisitor {
        private OnlyTokenVisitor() {
        }

        public void visitToken(Token node) {
            ASTOnlyNode thisOnlyNode;
            String name = PhotranVPG.canonicalizeIdentifier(node.getText());
            if (!(!MinOnlyListRefactoring.this.existingOnlyListNames.contains(name) && !MinOnlyListRefactoring.this.moduleEntityNames.contains(name) || node.getParent() instanceof ASTOnlyNode || node.getEnclosingScope() instanceof ASTModuleNode || MinOnlyListRefactoring.this.onlyNamesToKeep.contains(name))) {
                MinOnlyListRefactoring.this.onlyNamesToKeep.add(name);
                MinOnlyListRefactoring minOnlyListRefactoring = MinOnlyListRefactoring.this;
                minOnlyListRefactoring.numOnlysToKeep = minOnlyListRefactoring.numOnlysToKeep + 1;
            }
            if (MinOnlyListRefactoring.this.existingOnlyListNames.contains(name) && !MinOnlyListRefactoring.this.onlyNamesToKeep.contains(name) && node.getParent() instanceof ASTOnlyNode && (thisOnlyNode = (ASTOnlyNode)node.getParent()).isRenamed()) {
                MinOnlyListRefactoring.this.onlyNamesToKeep.add(thisOnlyNode.getNewName().getText());
                MinOnlyListRefactoring.this.onlyNamesToKeep.add(thisOnlyNode.getName().getText());
                MinOnlyListRefactoring minOnlyListRefactoring = MinOnlyListRefactoring.this;
                minOnlyListRefactoring.numOnlysToKeep = minOnlyListRefactoring.numOnlysToKeep + 1;
            }
        }
    }
}

