/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTObjectNameNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.MultipleFileFortranRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class RemoveUnusedVariablesRefactoring
extends MultipleFileFortranRefactoring {
    public String getName() {
        return "Remove Unused Local Variables";
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError("One of the selected files (" + file.getName() + ") cannot be parsed.");
                }
                List<ScopingNode> scopes = ast.getRoot().getAllContainedScopes();
                for (ScopingNode scope : scopes) {
                    if (scope instanceof ASTExecutableProgramNode || scope.isImplicitNone()) continue;
                    this.fail("All of the selected files must be 'Implict None'! Please use the 'Introduce Implict None Refactoring' first to introduce the 'Implict None' statements in file " + file.getName() + "!");
                }
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError("One of the selected files (" + file.getName() + ") cannot be parsed.");
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private ASTTypeDeclarationStmtNode getTypeDeclarationStmtNode(Parser.IASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ASTTypeDeclarationStmtNode) {
            return (ASTTypeDeclarationStmtNode)node;
        }
        return this.getTypeDeclarationStmtNode(node.getParent());
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        boolean hasChanged = false;
        List<ScopingNode> scopes = ast.getRoot().getAllContainedScopes();
        for (ScopingNode scope : scopes) {
            assert (this.debug("Scope: " + scope.getClass().getName()));
            List<Definition> definitions = scope.getAllDefinitions();
            for (Definition def : definitions) {
                Set<PhotranTokenRef> references;
                if (!def.isLocalVariable() || !(references = def.findAllReferences(true)).isEmpty()) continue;
                hasChanged = true;
                assert (this.debug("The variable [" + def.getDeclaredName() + "] was not used and will be removed."));
                ASTTypeDeclarationStmtNode declarationNode = this.getTypeDeclarationStmtNode(def.getTokenRef().findToken().getParent());
                if (declarationNode.getEntityDeclList().size() == 1) {
                    declarationNode.replaceWith("\n");
                    continue;
                }
                Parser.IASTListNode<ASTEntityDeclNode> statementsInNode = declarationNode.getEntityDeclList();
                for (ASTEntityDeclNode statement : statementsInNode) {
                    ASTObjectNameNode objectName = statement.getObjectName();
                    String statementName = objectName.getObjectName().getText();
                    if (!statementName.equals(def.getDeclaredName())) continue;
                    if (statementsInNode.remove(statement)) break;
                    this.fail("Sorry, could not complete the operation.");
                    break;
                }
                statementsInNode.findFirstToken().setWhiteBefore(" ");
                declarationNode.setEntityDeclList(statementsInNode);
            }
        }
        if (hasChanged) {
            this.addChangeFromModifiedAST(file, pm);
            status.addInfo("After clicking 'Continue', do the same refactoring again to make sure that all unused variables are removed from file " + file.getName() + "!");
            status.addWarning("This refactoring does not remove un-used variables when their dimentions are specified on another line. I.e. real a /n/n dimention a(10) will not be removed.");
        } else {
            status.addInfo("All unused variables have been removed from file " + file.getName() + "!");
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    private boolean debug(String msg) {
        System.out.println(msg);
        return true;
    }
}

