/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.ASTTypeSpecNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.MultipleFileFortranRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.Reindenter;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SourcePrinter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardizeStatementsRefactoring
extends MultipleFileFortranRefactoring {
    public String getName() {
        return "Standardize Statements";
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError("One of the selected files (" + file.getName() + ") cannot be parsed.");
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private boolean points(String s) {
        int i = 0;
        while (i < s.length() - 1) {
            char p1 = s.charAt(i);
            char p2 = s.charAt(i + 1);
            if (p1 == '!' || p2 == '!') {
                return false;
            }
            if (p1 == ':' && p2 == ':') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setNodeType(Parser.IASTNode node, ASTTypeSpecNode type_node) {
        String type = ((ASTTypeDeclarationStmtNode)node).getTypeSpec().toString().trim();
        String[] typeWithoutComments = type.split("\n");
        type = typeWithoutComments[typeWithoutComments.length - 1].trim();
        Token text_type = new Token(null, type);
        type_node.setIsInteger(text_type);
    }

    private String addTwoColons(ASTTypeDeclarationStmtNode new_statement) {
        String source = SourcePrinter.getSourceCodeFromASTNode(new_statement);
        int position_type = new_statement.getTypeSpec().toString().length();
        String twoPoints = "";
        String source_1 = source.substring(0, position_type);
        String source_2 = source.substring(position_type, source.length());
        if (!this.points(source_2)) {
            twoPoints = " :: ";
        }
        source = String.valueOf(source_1) + twoPoints + source_2.trim();
        return source;
    }

    private void populateStatementsList(Parser.IASTListNode<Parser.IASTNode> body, List<ASTTypeDeclarationStmtNode> statements) {
        for (Parser.IASTNode node : body) {
            if (!(node instanceof ASTTypeDeclarationStmtNode)) continue;
            Parser.IASTListNode<ASTEntityDeclNode> variables = ((ASTTypeDeclarationStmtNode)node).getEntityDeclList();
            ASTTypeSpecNode type_node = new ASTTypeSpecNode();
            this.setNodeType(node, type_node);
            int i = 0;
            while (i < variables.size()) {
                ASTTypeDeclarationStmtNode new_statement = (ASTTypeDeclarationStmtNode)node.clone();
                if (i > 0) {
                    new_statement.setTypeSpec(type_node);
                }
                Parser.IASTListNode new_variable = (Parser.IASTListNode)variables.clone();
                LinkedList<ASTEntityDeclNode> list_variables_to_remove = new LinkedList<ASTEntityDeclNode>();
                int j = 0;
                while (j < variables.size()) {
                    if (j != i) {
                        list_variables_to_remove.add((ASTEntityDeclNode)new_variable.get(j));
                    }
                    ++j;
                }
                new_variable.removeAll(list_variables_to_remove);
                new_statement.setEntityDeclList(new_variable);
                String source = this.addTwoColons(new_statement);
                new_statement = (ASTTypeDeclarationStmtNode)StandardizeStatementsRefactoring.parseLiteralStatement(source);
                statements.add((ASTTypeDeclarationStmtNode)node);
                statements.add(new_statement);
                ++i;
            }
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        List<ScopingNode> scopes = ast.getRoot().getAllContainedScopes();
        for (ScopingNode scope : scopes) {
            if (scope instanceof ASTExecutableProgramNode || scope instanceof ASTDerivedTypeDefNode) continue;
            Parser.IASTListNode<Parser.IASTNode> body = scope.getBody();
            LinkedList<ASTTypeDeclarationStmtNode> statements = new LinkedList<ASTTypeDeclarationStmtNode>();
            this.populateStatementsList(body, statements);
            int i = 0;
            while (i < statements.size()) {
                body.insertBefore((Parser.IASTNode)statements.get(i), (Parser.IASTNode)statements.get(i + 1));
                Reindenter.reindent((Parser.IASTNode)statements.get(i + 1), ast);
                i += 2;
            }
            i = 0;
            while (i < statements.size()) {
                ASTTypeDeclarationStmtNode delete = (ASTTypeDeclarationStmtNode)statements.get(i);
                if (body.contains(delete)) {
                    delete.removeFromTree();
                }
                i += 2;
            }
        }
        this.addChangeFromModifiedAST(file, pm);
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }
}

