/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.FortranAST;
import org.eclipse.photran.internal.core.SyntaxException;
import org.eclipse.photran.internal.core.analysis.binding.Binder;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ImplicitSpec;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.LexerException;
import org.eclipse.photran.internal.core.lexer.LexerFactory;
import org.eclipse.photran.internal.core.lexer.SourceForm;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.IncludeLoaderCallback;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGDependency;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotranVPGBuilder
extends PhotranVPG {
    protected PhotranVPGBuilder() {
    }

    public void markFileAsExportingSubprogram(IFile file, String subprogramName) {
        this.db.ensure(new VPGDependency((VPG)this, "subprogram:" + PhotranVPGBuilder.canonicalizeIdentifier(subprogramName), PhotranVPGBuilder.getFilenameForIFile((IFile)file)));
    }

    public void markFileAsImportingSubprogram(IFile file, String subprogramName) {
        this.db.ensure(new VPGDependency((VPG)this, PhotranVPGBuilder.getFilenameForIFile((IFile)file), "subprogram:" + PhotranVPGBuilder.canonicalizeIdentifier(subprogramName)));
    }

    public void markFileAsExportingModule(IFile file, String moduleName) {
        this.db.ensure(new VPGDependency((VPG)this, "module:" + PhotranVPGBuilder.canonicalizeIdentifier(moduleName), PhotranVPGBuilder.getFilenameForIFile((IFile)file)));
    }

    public void markFileAsImportingModule(IFile file, String moduleName) {
        this.db.ensure(new VPGDependency((VPG)this, PhotranVPGBuilder.getFilenameForIFile((IFile)file), "module:" + PhotranVPGBuilder.canonicalizeIdentifier(moduleName)));
    }

    public void markFileAsUsingCommonBlock(IFile file, String commonBlockName) {
        this.db.ensure(new VPGDependency((VPG)this, PhotranVPGBuilder.getFilenameForIFile((IFile)file), "common:" + PhotranVPGBuilder.canonicalizeIdentifier(commonBlockName)));
    }

    public void setDefinitionFor(PhotranTokenRef tokenRef, Definition definition) {
        this.db.setAnnotation(tokenRef, 3, definition);
    }

    public void markDefinitionVisibilityInScope(PhotranTokenRef definitionTokenRef, ScopingNode scope, Definition.Visibility visibility) {
        VPGEdge privateEdge = new VPGEdge((VPG)this, (TokenRef)definitionTokenRef, (TokenRef)scope.getRepresentativeToken(), 4);
        if (visibility.equals((Object)Definition.Visibility.PRIVATE)) {
            this.db.ensure(privateEdge);
        } else {
            this.db.delete(privateEdge);
        }
    }

    public void markScope(PhotranTokenRef identifier, ScopingNode scope) {
        this.db.ensure(new VPGEdge((VPG)this, (TokenRef)identifier, (TokenRef)scope.getRepresentativeToken(), 0));
    }

    public void markIllegalShadowing(PhotranTokenRef shadowingIdent, PhotranTokenRef shadowedIdent) {
        this.db.ensure(new VPGEdge((VPG)this, (TokenRef)shadowingIdent, (TokenRef)shadowedIdent, 5));
    }

    public void markBinding(PhotranTokenRef reference, PhotranTokenRef definition) {
        this.db.ensure(new VPGEdge((VPG)this, (TokenRef)reference, (TokenRef)definition, 2));
    }

    public void markRenamedBinding(PhotranTokenRef reference, PhotranTokenRef definition) {
        this.db.ensure(new VPGEdge((VPG)this, (TokenRef)reference, (TokenRef)definition, 3));
    }

    public void setScopeImplicitSpec(ScopingNode scope, ImplicitSpec implicitSpec) {
        if (implicitSpec != null) {
            this.db.setAnnotation(scope.getRepresentativeToken(), 2, implicitSpec);
        } else {
            this.db.deleteAnnotation(scope.getRepresentativeToken(), 2);
        }
    }

    public void setDefaultScopeVisibilityToPrivate(ScopingNode scope) {
        this.db.setAnnotation(scope.getRepresentativeToken(), 0, Boolean.TRUE);
    }

    public void setModuleSymbolTable(Token moduleNameToken, List<Definition> symbolTable) {
        this.clearModuleSymbolTableEntries(moduleNameToken);
        String filename = "module:" + PhotranVPGBuilder.canonicalizeIdentifier(moduleNameToken.getText());
        PhotranTokenRef tokenRef = this.createTokenRef(filename, 0, 0);
        this.db.setAnnotation(tokenRef, 5, moduleNameToken.getTokenRef());
        int entries = 0;
        for (Definition def : symbolTable) {
            tokenRef = this.createTokenRef(filename, entries++, 0);
            this.db.setAnnotation(tokenRef, 7, def);
        }
        tokenRef = this.createTokenRef(filename, 0, 0);
        this.db.setAnnotation(tokenRef, 6, Integer.valueOf(entries));
    }

    private void clearModuleSymbolTableEntries(Token moduleNameToken) {
        String canonicalizedModuleName = PhotranVPGBuilder.canonicalizeIdentifier(moduleNameToken.getText());
        this.moduleSymTabCache.remove(canonicalizedModuleName);
        int entries = this.countModuleSymbolTableEntries(canonicalizedModuleName);
        if (entries > 0) {
            String filename = "module:" + canonicalizedModuleName;
            int i = 0;
            while (i < entries) {
                PhotranTokenRef tokenRef = this.createTokenRef(filename, i, 0);
                this.db.deleteAnnotation(tokenRef, 7);
                ++i;
            }
            PhotranTokenRef tokenRef = this.createTokenRef(filename, 0, 0);
            this.db.setAnnotation(tokenRef, 6, Integer.valueOf(0));
        }
    }

    public boolean isVirtualFile(String filename) {
        return filename.startsWith("module:") || filename.startsWith("common:") || filename.startsWith("subprogram:");
    }

    public PhotranTokenRef createTokenRef(String filename, int offset, int length) {
        return new PhotranTokenRef(filename, offset, length);
    }

    protected void calculateDependencies(String filename) {
        if (this.isVirtualFile(filename)) {
            return;
        }
        SourceForm sourceForm = this.determineSourceForm(filename);
        try {
            IAccumulatingLexer lexer = LexerFactory.createLexer(PhotranVPGBuilder.getIFileForFilename((String)filename), sourceForm, true);
            long start = System.currentTimeMillis();
            this.calculateDependencies(filename, lexer);
            this.debug("  - Elapsed time in calculateDependencies: " + (System.currentTimeMillis() - start) + " ms", filename);
        }
        catch (Exception e) {
            this.log.logError((Throwable)e);
        }
    }

    private SourceForm determineSourceForm(final String filename) {
        IFile file = PhotranVPGBuilder.getIFileForFilename((String)filename);
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(filename);
        SourceForm sourceForm = contentType != null && contentType.isKindOf(PhotranVPGBuilder.fixedFormContentType()) ? SourceForm.FIXED_FORM : (file == null || file.getProject() == null ? SourceForm.UNPREPROCESSED_FREE_FORM : SourceForm.preprocessedFreeForm(new IncludeLoaderCallback(file.getProject()){

            public InputStream getIncludedFileAsStream(String fileToInclude) throws FileNotFoundException {
                PhotranVPGBuilder.this.db.ensure(new VPGDependency((VPG)PhotranVPGBuilder.this, filename, PhotranVPGBuilder.getFilenameForIFile((IFile)this.getIncludedFile(fileToInclude))));
                return super.getIncludedFileAsStream(fileToInclude);
            }

            public void logError(String message, IFile topLevelFile, int offset) {
                PhotranVPG.getInstance().log.logError(message, (TokenRef)new PhotranTokenRef(topLevelFile, offset, 0));
            }
        }));
        return sourceForm;
    }

    private void calculateDependencies(String filename, IAccumulatingLexer lexer) {
        if (!this.isVirtualFile(filename)) {
            this.db.deleteAllIncomingDependenciesFor(filename);
            this.db.deleteAllOutgoingDependenciesFor(filename);
        }
        if (lexer == null) {
            return;
        }
        try {
            this.calculateFileDepsFromModuleAndUseStmts(filename, lexer);
        }
        catch (Exception e) {
            this.log.logError((Throwable)e);
        }
    }

    private void calculateFileDepsFromModuleAndUseStmts(String filename, IAccumulatingLexer lexer) throws Exception {
        IFile file = PhotranVPGBuilder.getIFileForFilename((String)filename);
        int state = 0;
        Token tok = lexer.yylex();
        while (tok != null && tok.getTerminal() != Terminal.END_OF_INPUT) {
            if (state == 0 && tok.getTerminal() == Terminal.T_USE) {
                state = 1;
            } else if (state == 0 && tok.getTerminal() == Terminal.T_MODULE) {
                state = 2;
            } else if (state == 1) {
                if (tok.getTerminal() == Terminal.T_IDENT) {
                    this.markFileAsImportingModule(file, tok.getText());
                }
                state = 0;
            } else if (state == 2) {
                if (tok.getTerminal() == Terminal.T_IDENT) {
                    this.markFileAsExportingModule(file, tok.getText());
                }
                state = 0;
            }
            tok = lexer.yylex();
        }
    }

    protected void doCommitChangeFromAST(String filename) {
        if (this.isVirtualFile(filename)) {
            return;
        }
        IFortranAST ast = (IFortranAST)this.acquireTransientAST(filename);
        if (ast == null) {
            throw new IllegalArgumentException(String.valueOf(filename) + " returned null AST");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        ast.getRoot().printOn(new PrintStream(out), null);
        ast = this.parse(filename, new ByteArrayInputStream(out.toByteArray()));
        this.computeEdgesAndAnnotations(filename, ast);
    }

    public String getSourceCodeFromAST(IFortranAST ast) {
        return ast.getRoot().toString();
    }

    protected IFortranAST parse(String filename) {
        return this.parse(filename, null);
    }

    private IFortranAST parse(String filename, InputStream stream) {
        if (filename == null || this.isVirtualFile(filename)) {
            return null;
        }
        IFile file = PhotranVPGBuilder.getIFileForFilename((String)filename);
        if (file == null) {
            return null;
        }
        SourceForm sourceForm = this.determineSourceForm(filename);
        try {
            if (stream == null) {
                stream = file.getContents(true);
            }
            IAccumulatingLexer lexer = LexerFactory.createLexer(stream, file, filename, sourceForm, true);
            long start = System.currentTimeMillis();
            ASTExecutableProgramNode ast = this.parser.parse(lexer);
            this.debug("  - Elapsed time in Parser#parse: " + (System.currentTimeMillis() - start) + " ms", filename);
            return new FortranAST(file, ast, lexer.getTokenList());
        }
        catch (SyntaxException e) {
            if (e.getFile() != null) {
                this.log.logError("Error parsing " + filename + ": " + e.getMessage(), (TokenRef)new PhotranTokenRef(e.getFile(), e.getTokenOffset(), e.getTokenLength()));
            } else {
                this.logError(file, "Error parsing " + filename, e);
            }
            return null;
        }
        catch (LexerException e) {
            if (e.getFile() != null) {
                this.log.logError("Error parsing " + filename + ": " + e.getMessage(), (TokenRef)new PhotranTokenRef(e.getFile(), e.getTokenOffset(), e.getTokenLength()));
            } else {
                this.logError(file, "Error parsing " + filename, e);
            }
            return null;
        }
        catch (Throwable e) {
            this.logError(file, "Error parsing " + filename, e);
            return null;
        }
    }

    private void logError(IFile file, String message, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append(": ");
        sb.append(e.getMessage());
        sb.append('\n');
        sb.append(e.getClass().getName());
        sb.append(":\n");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(bs));
        sb.append(bs);
        if (file != null) {
            this.log.logError(sb.toString(), (TokenRef)new PhotranTokenRef(file, 0, 0));
        } else {
            this.log.logError(sb.toString());
        }
    }

    protected void populateVPG(String filename, IFortranAST ast) {
        if (!this.isVirtualFile(filename)) {
            this.db.deleteAllIncomingDependenciesFor(filename);
            this.db.deleteAllOutgoingDependenciesFor(filename);
        }
        if (ast == null || PhotranVPGBuilder.isEmpty(ast.getRoot())) {
            return;
        }
        long start = System.currentTimeMillis();
        Binder.bind(ast, PhotranVPGBuilder.getIFileForFilename((String)filename));
        this.debug("  - Elapsed time in Binder#bind: " + (System.currentTimeMillis() - start) + " ms", filename);
    }

    public static boolean isEmpty(ASTExecutableProgramNode ast) {
        return ast.findFirstToken() == null;
    }
}

