/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.Activator;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.PhotranVPGLog;
import org.eclipse.photran.internal.core.vpg.PhotranVPGSerializer;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.db.caching.CachingDB;
import org.eclipse.rephraserengine.core.vpg.db.cdt.CDTDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotranVPGDB
extends CachingDB<IFortranAST, Token, PhotranTokenRef, PhotranCDTDB, PhotranVPGLog> {
    public PhotranVPGDB() {
        super((VPGDB)new PhotranCDTDB(), 500, 10000);
    }

    public String describeEdgeType(int edgeType) {
        return super.describeEdgeType(edgeType);
    }

    public String describeAnnotationType(int annotationType) {
        return super.describeAnnotationType(annotationType);
    }

    public String describeToken(String filename, int offset, int length) {
        return super.describeToken(filename, offset, length);
    }

    public void clearDatabase() {
        ((PhotranCDTDB)this.db).clearDatabase();
    }

    public void deleteAllEdgesAndAnnotationsFor(String filename) {
        if (!this.getVPG().isVirtualFile(filename)) {
            super.deleteAllEdgesAndAnnotationsFor(filename);
        }
    }

    public void enterHypotheticalMode() throws IOException {
        ((PhotranVPG)this.getVPG()).moduleSymTabCache.clear();
        super.enterHypotheticalMode();
    }

    public void leaveHypotheticalMode() throws IOException {
        ((PhotranVPG)this.getVPG()).moduleSymTabCache.clear();
        super.leaveHypotheticalMode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PhotranCDTDB
    extends CDTDB<IFortranAST, Token, PhotranTokenRef, PhotranVPGLog> {
        public PhotranCDTDB() {
            this(PhotranVPG.inTestingMode() ? PhotranCDTDB.createTempFile() : String.valueOf(Activator.getDefault().getStateLocation().addTrailingSeparator().toOSString()) + "photran60vpg2");
        }

        private PhotranCDTDB(String filename) {
            super(filename);
            if (FortranPreferences.ENABLE_VPG_LOGGING.getValue()) {
                System.out.println("Using Photran VPG database " + filename);
            }
        }

        private static String createTempFile() {
            try {
                File f = File.createTempFile("vpg", null);
                f.deleteOnExit();
                return f.getAbsolutePath();
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }

        protected long getModificationStamp(String filename) {
            if (this.getVPG().isVirtualFile(filename)) {
                return Long.MIN_VALUE;
            }
            IFile ifile = PhotranVPG.getIFileForFilename((String)filename);
            return ifile == null ? Integer.MIN_VALUE : ifile.getLocalTimeStamp();
        }

        protected byte[] serialize(Serializable annotation) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PhotranVPGSerializer.serialize(annotation, (OutputStream)out);
            return out.toByteArray();
        }

        protected Serializable deserialize(InputStream binaryStream) throws IOException, ClassNotFoundException {
            return PhotranVPGSerializer.deserialize(binaryStream);
        }
    }
}

