/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTConstructorInitializer
extends ASTNode
implements ICPPASTConstructorInitializer,
IASTAmbiguityParent {
    private IASTExpression exp;
    private boolean fIsPackExpansion;

    public CPPASTConstructorInitializer() {
    }

    public CPPASTConstructorInitializer(IASTExpression exp) {
        this.setExpression(exp);
    }

    public CPPASTConstructorInitializer copy() {
        CPPASTConstructorInitializer copy = new CPPASTConstructorInitializer(this.exp == null ? null : this.exp.copy());
        copy.setOffsetAndLength(this);
        copy.fIsPackExpansion = this.fIsPackExpansion;
        return copy;
    }

    public IASTExpression getExpression() {
        return this.exp;
    }

    public void setExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.exp = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(EXPRESSION);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitInitializers) {
            switch (action.visit((IASTInitializer)((Object)this))) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.exp != null && !this.exp.accept(action)) {
            return false;
        }
        if (action.shouldVisitInitializers) {
            switch (action.leave((IASTInitializer)((Object)this))) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.exp) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.exp = (IASTExpression)other;
        }
    }

    public boolean isPackExpansion() {
        return this.fIsPackExpansion;
    }

    public void setIsPackExpansion(boolean val) {
        this.assertNotFrozen();
        this.fIsPackExpansion = val;
    }
}

