/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPEnumerator;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPEnumeration
extends PDOMCPPBinding
implements IEnumeration,
IIndexType {
    private static final int FIRST_ENUMERATOR = 28;
    private static final int OFFSET_MIN_VALUE = 32;
    private static final int OFFSET_MAX_VALUE = 40;
    protected static final int RECORD_SIZE = 48;
    private Long fMinValue;
    private Long fMaxValue;

    public PDOMCPPEnumeration(PDOMLinkage linkage, PDOMNode parent, IEnumeration enumeration) throws CoreException {
        super(linkage, parent, enumeration.getNameCharArray());
        this.storeValueBounds(enumeration);
    }

    public PDOMCPPEnumeration(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        this.storeValueBounds((IEnumeration)newBinding);
    }

    private void storeValueBounds(IEnumeration enumeration) throws CoreException {
        Database db = this.getDB();
        long minValue = enumeration.getMinValue();
        long maxValue = enumeration.getMaxValue();
        db.putLong(this.record + 32L, minValue);
        db.putLong(this.record + 40L, maxValue);
        this.fMinValue = minValue;
        this.fMaxValue = maxValue;
    }

    protected int getRecordSize() {
        return 48;
    }

    public int getNodeType() {
        return 15;
    }

    public IEnumerator[] getEnumerators() throws DOMException {
        try {
            ArrayList<PDOMCPPEnumerator> enums = new ArrayList<PDOMCPPEnumerator>();
            PDOMCPPEnumerator enumerator = this.getFirstEnumerator();
            while (enumerator != null) {
                enums.add(enumerator);
                enumerator = enumerator.getNextEnumerator();
            }
            IEnumerator[] enumerators = enums.toArray(new IEnumerator[enums.size()]);
            int n = enumerators.length;
            int i = 0;
            while (i < n / 2) {
                IEnumerator tmp = enumerators[i];
                enumerators[i] = enumerators[n - 1 - i];
                enumerators[n - 1 - i] = tmp;
                ++i;
            }
            return enumerators;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return new IEnumerator[0];
        }
    }

    private PDOMCPPEnumerator getFirstEnumerator() throws CoreException {
        long value = this.getDB().getRecPtr(this.record + 28L);
        return value != 0L ? new PDOMCPPEnumerator((PDOMLinkage)this.getLinkage(), value) : null;
    }

    public void addEnumerator(PDOMCPPEnumerator enumerator) throws CoreException {
        PDOMCPPEnumerator first = this.getFirstEnumerator();
        enumerator.setNextEnumerator(first);
        this.getDB().putRecPtr(this.record + 28L, enumerator.getRecord());
    }

    public boolean isSameType(IType type) {
        block6: {
            IEnumeration etype;
            block7: {
                PDOMNode node;
                if (type instanceof ITypedef) {
                    return type.isSameType(this);
                }
                if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
                    return node.getRecord() == this.getRecord();
                }
                if (!(type instanceof IEnumeration)) break block6;
                etype = (IEnumeration)type;
                char[] nchars = etype.getNameCharArray();
                if (nchars.length == 0) {
                    nchars = ASTTypeUtil.createNameForAnonymous(etype);
                }
                if (nchars != null && CharArrayUtils.equals(nchars, this.getNameCharArray())) break block7;
                return false;
            }
            try {
                return SemanticUtil.isSameOwner(this.getOwner(), etype.getOwner());
            }
            catch (DOMException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        return false;
    }

    public long getMinValue() {
        if (this.fMinValue != null) {
            return this.fMinValue;
        }
        long minValue = 0L;
        try {
            minValue = this.getDB().getLong(this.record + 32L);
        }
        catch (CoreException coreException) {}
        this.fMinValue = minValue;
        return minValue;
    }

    public long getMaxValue() {
        if (this.fMaxValue != null) {
            return this.fMaxValue;
        }
        long maxValue = 0L;
        try {
            maxValue = this.getDB().getLong(this.record + 40L);
        }
        catch (CoreException coreException) {}
        this.fMaxValue = maxValue;
        return maxValue;
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }
}

