/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTBinaryExpression
extends ASTNode
implements IASTBinaryExpression,
IASTAmbiguityParent {
    private int op;
    private IASTExpression operand1;
    private IASTExpression operand2;

    public CASTBinaryExpression() {
    }

    public CASTBinaryExpression(int op, IASTExpression operand1, IASTExpression operand2) {
        this.op = op;
        this.setOperand1(operand1);
        this.setOperand2(operand2);
    }

    public CASTBinaryExpression copy() {
        CASTBinaryExpression copy = new CASTBinaryExpression();
        copy.op = this.op;
        copy.setOperand1(this.operand1 == null ? null : this.operand1.copy());
        copy.setOperand2(this.operand2 == null ? null : this.operand2.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public int getOperator() {
        return this.op;
    }

    public IASTExpression getOperand1() {
        return this.operand1;
    }

    public IASTExpression getOperand2() {
        return this.operand2;
    }

    public void setOperator(int op) {
        this.assertNotFrozen();
        this.op = op;
    }

    public void setOperand1(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand1 = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_ONE);
        }
    }

    public void setOperand2(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand2 = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_TWO);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (this.operand1 instanceof IASTBinaryExpression || this.operand2 instanceof IASTBinaryExpression) {
            return CASTBinaryExpression.acceptWithoutRecursion(this, action);
        }
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.operand1 != null && !this.operand1.accept(action)) {
            return false;
        }
        if (this.operand2 != null && !this.operand2.accept(action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean acceptWithoutRecursion(IASTBinaryExpression bexpr, ASTVisitor action) {
        stack = new N(bexpr);
        block4: while (stack != null) {
            block10: {
                expr = stack.fExpression;
                if (stack.fState != 0) break block10;
                if (!action.shouldVisitExpressions) ** GOTO lbl-1000
                switch (action.visit(expr)) {
                    case 2: {
                        return false;
                    }
                    case 1: {
                        stack = stack.fNext;
                        continue block4;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        stack.fState = 1;
                        op1 = expr.getOperand1();
                        if (op1 instanceof IASTBinaryExpression) {
                            n = new N((IASTBinaryExpression)op1);
                            n.fNext = stack;
                            stack = n;
                            continue block4;
                        }
                        if (op1 == null || op1.accept(action)) break;
                        return false;
                    }
                }
            }
            if (stack.fState == 1) {
                stack.fState = 2;
                op2 = expr.getOperand2();
                if (op2 instanceof IASTBinaryExpression) {
                    n = new N((IASTBinaryExpression)op2);
                    n.fNext = stack;
                    stack = n;
                    continue;
                }
                if (op2 != null && !op2.accept(action)) {
                    return false;
                }
            }
            if (action.shouldVisitExpressions && action.leave(expr) == 2) {
                return false;
            }
            stack = stack.fNext;
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand1) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand1 = (IASTExpression)other;
        }
        if (child == this.operand2) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand2 = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        IType t2;
        IType t1;
        int op = this.getOperator();
        IType type = CArithmeticConversion.convertCOperandTypes(op, t1 = CVisitor.unwrapTypedefs(this.getOperand1().getExpressionType()), t2 = CVisitor.unwrapTypedefs(this.getOperand2().getExpressionType()));
        if (type != null) {
            return type;
        }
        switch (op) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 28: 
            case 29: {
                return new CBasicType(IBasicType.Kind.eInt, 0, this);
            }
            case 4: {
                if (!(t2 instanceof IPointerType)) break;
                return t2;
            }
            case 5: {
                if (!(t2 instanceof IPointerType)) break;
                if (t1 instanceof IPointerType) {
                    return CVisitor.getPtrDiffType(this);
                }
                return t1;
            }
        }
        return t1;
    }

    public boolean isLValue() {
        switch (this.getOperator()) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    private static class N {
        final IASTBinaryExpression fExpression;
        int fState;
        N fNext;

        N(IASTBinaryExpression expr) {
            this.fExpression = expr;
        }
    }
}

