/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalNameOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPPASTQualifiedName
extends CPPASTNameBase
implements ICPPASTQualifiedName,
IASTCompletionContext {
    private IASTName[] names = null;
    private int namesPos = -1;
    private boolean isFullyQualified;
    private char[] signature;

    @Override
    public CPPASTQualifiedName copy() {
        CPPASTQualifiedName copy = new CPPASTQualifiedName();
        IASTName[] iASTNameArray = this.getNames();
        int n = iASTNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName name = iASTNameArray[n2];
            copy.addName(name == null ? null : name.copy());
            ++n2;
        }
        copy.setFullyQualified(this.isFullyQualified);
        copy.setOffsetAndLength(this);
        return copy;
    }

    @Override
    public final IBinding resolvePreBinding() {
        return this.getLastName().resolvePreBinding();
    }

    @Override
    public IBinding resolveBinding() {
        IASTName lastName = this.getLastName();
        return lastName == null ? null : lastName.resolveBinding();
    }

    @Override
    public final IBinding getPreBinding() {
        return this.getLastName().getPreBinding();
    }

    @Override
    public IBinding getBinding() {
        return this.getLastName().getBinding();
    }

    @Override
    public void setBinding(IBinding binding) {
        this.getLastName().setBinding(binding);
    }

    @Override
    public void addName(IASTName name) {
        this.assertNotFrozen();
        assert (!(name instanceof ICPPASTQualifiedName));
        if (name != null) {
            this.names = (IASTName[])ArrayUtil.append(IASTName.class, this.names, ++this.namesPos, name);
            name.setParent(this);
            name.setPropertyInParent(SEGMENT_NAME);
        }
    }

    @Override
    public IASTName[] getNames() {
        if (this.namesPos < 0) {
            return IASTName.EMPTY_NAME_ARRAY;
        }
        this.names = (IASTName[])ArrayUtil.removeNullsAfter(IASTName.class, this.names, this.namesPos);
        return this.names;
    }

    @Override
    public IASTName getLastName() {
        if (this.namesPos < 0) {
            return null;
        }
        return this.names[this.namesPos];
    }

    @Override
    public char[] getSimpleID() {
        return this.names[this.namesPos].getSimpleID();
    }

    @Override
    public char[] getLookupKey() {
        return this.names[this.namesPos].getLookupKey();
    }

    @Override
    public char[] toCharArray() {
        if (this.signature == null) {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i <= this.namesPos) {
                if (i > 0 || this.isFullyQualified) {
                    buf.append(Keywords.cpCOLONCOLON);
                }
                buf.append(this.names[i].toCharArray());
                ++i;
            }
            int len = buf.length();
            this.signature = new char[len];
            buf.getChars(0, len, this.signature, 0);
        }
        return this.signature;
    }

    @Override
    public boolean isFullyQualified() {
        return this.isFullyQualified;
    }

    @Override
    public void setFullyQualified(boolean isFullyQualified) {
        this.assertNotFrozen();
        this.isFullyQualified = isFullyQualified;
    }

    @Deprecated
    public void setSignature(String signature) {
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        int i = 0;
        while (i <= this.namesPos) {
            IASTName name = this.names[i];
            if (i == this.namesPos ? name.getLookupKey().length > 0 && !name.accept(action) : !name.accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleOfName(boolean allowResolution) {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTInternalNameOwner) {
            return ((IASTInternalNameOwner)((Object)parent)).getRoleForName(this, allowResolution);
        }
        if (parent instanceof IASTNameOwner) {
            return ((IASTNameOwner)((Object)parent)).getRoleForName(this);
        }
        return 3;
    }

    @Override
    public int getRoleForName(IASTName n) {
        IASTNode p;
        int i = 0;
        while (i < this.namesPos) {
            if (this.names[i] == n) {
                return 1;
            }
            ++i;
        }
        if (this.getLastName() == n && (p = this.getParent()) instanceof IASTNameOwner) {
            return ((IASTNameOwner)((Object)p)).getRoleForName(this);
        }
        return 3;
    }

    @Override
    public boolean isConversionOrOperator() {
        IASTName tempName;
        IASTName lastName = this.getLastName();
        if (lastName instanceof ICPPASTConversionName || lastName instanceof ICPPASTOperatorName) {
            return true;
        }
        return lastName instanceof ICPPASTTemplateId && ((tempName = ((ICPPASTTemplateId)lastName).getTemplateName()) instanceof ICPPASTConversionName || tempName instanceof ICPPASTOperatorName);
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        ICPPClassType classType;
        IBinding binding;
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
        if (this.namesPos > 0 && (binding = this.names[this.namesPos - 1].resolveBinding()) instanceof ICPPClassType && !this.canBeFieldAccess(classType = (ICPPClassType)binding)) {
            boolean isDeclaration = this.getParent().getParent() instanceof IASTSimpleDeclaration;
            List<IBinding> filtered = this.filterClassScopeBindings(classType, bindings, isDeclaration);
            if (isDeclaration && this.nameMatches(classType.getNameCharArray(), n.getLookupKey(), isPrefix)) {
                try {
                    ICPPConstructor[] constructors = classType.getConstructors();
                    int i = 0;
                    while (i < constructors.length) {
                        if (!constructors[i].isImplicit()) {
                            filtered.add(constructors[i]);
                        }
                        ++i;
                    }
                }
                catch (DOMException dOMException) {}
            }
            return filtered.toArray(new IBinding[filtered.size()]);
        }
        return bindings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canBeFieldAccess(ICPPClassType baseClass) {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTFieldReference) {
            return true;
        }
        if (!(parent instanceof IASTIdExpression)) return false;
        IScope scope = CPPVisitor.getContainingScope(this);
        try {
            while (true) {
                ICPPClassType classType;
                if (scope == null) {
                    return false;
                }
                if (scope instanceof ICPPClassScope && SemanticUtil.calculateInheritanceDepth(classType = ((ICPPClassScope)scope).getClassType(), baseClass) >= 0) {
                    return true;
                }
                scope = scope.getParent();
            }
        }
        catch (DOMException dOMException) {}
        return false;
    }

    private List<IBinding> filterClassScopeBindings(ICPPClassType classType, IBinding[] bindings, boolean isDeclaration) {
        ArrayList<IBinding> filtered = new ArrayList<IBinding>();
        try {
            IBinding[] iBindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IType type;
                ICPPMethod method;
                IField field;
                IBinding binding = iBindingArray[n2];
                if (!(binding instanceof IField ? !(field = (IField)binding).isStatic() : (binding instanceof ICPPMethod ? (method = (ICPPMethod)binding).isImplicit() || !isDeclaration && (method.isDestructor() || method instanceof ICPPConstructor || !method.isStatic()) : (binding instanceof IEnumerator || binding instanceof IEnumerator ? isDeclaration : binding instanceof IType && (type = (IType)((Object)binding)).isSameType(classType))))) {
                    filtered.add(binding);
                }
                ++n2;
            }
        }
        catch (DOMException dOMException) {}
        return filtered;
    }

    private boolean nameMatches(char[] potential, char[] name, boolean isPrefix) {
        if (isPrefix) {
            return CharArrayUtils.equals(potential, 0, name.length, name, true);
        }
        return CharArrayUtils.equals(potential, name);
    }

    @Override
    protected IBinding createIntermediateBinding() {
        Assert.isLegal((boolean)false);
        return null;
    }
}

