/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPTemplateNonTypeParameter
extends CPPTemplateParameter
implements ICPPTemplateNonTypeParameter {
    private IType type = null;

    public CPPTemplateNonTypeParameter(IASTName name) {
        super(name);
    }

    public IASTExpression getDefault() {
        IASTName[] nds = this.getDeclarations();
        if (nds == null || nds.length == 0) {
            return null;
        }
        IASTName[] iASTNameArray = nds;
        int n = nds.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName name = iASTNameArray[n2];
            if (name != null) {
                IASTDeclarator dtor;
                IASTInitializer initializer;
                IASTNode parent = name.getParent();
                assert (parent instanceof IASTDeclarator);
                if (parent instanceof IASTDeclarator && (initializer = (dtor = (IASTDeclarator)parent).getInitializer()) instanceof IASTInitializerExpression) {
                    return ((IASTInitializerExpression)initializer).getExpression();
                }
            }
            ++n2;
        }
        return null;
    }

    public ICPPTemplateArgument getDefaultValue() {
        IASTExpression d = this.getDefault();
        if (d == null) {
            return null;
        }
        IValue val = Value.create(d, 25);
        IType t = this.getType();
        return new CPPTemplateArgument(val, t);
    }

    public IType getType() {
        if (this.type == null) {
            IASTNode parent = this.getPrimaryDeclaration().getParent();
            while (parent != null) {
                if (parent instanceof ICPPASTParameterDeclaration) {
                    this.type = CPPVisitor.createParameterType((ICPPASTParameterDeclaration)parent, true);
                    break;
                }
                parent = parent.getParent();
            }
        }
        return this.type;
    }

    public boolean isParameterPack() {
        return this.getType() instanceof ICPPParameterPackType;
    }

    public boolean isStatic() throws DOMException {
        return false;
    }

    public boolean isExtern() throws DOMException {
        return false;
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public IValue getInitialValue() {
        return null;
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isMutable() {
        return false;
    }
}

