/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class TemplateArgumentDeduction {
    private CPPTemplateParameterMap fExplicitArgs;
    private CPPTemplateParameterMap fDeducedArgs;
    private Set<Integer> fTemplateParameterPacks;
    private int fPackOffset;
    private final int fPackSize;

    static ICPPTemplateArgument[] deduceForFunctionCall(ICPPFunctionTemplate template, ICPPTemplateArgument[] tmplArgs, IType[] fnArgs, BitSet argIsLValue, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        int numTmplParams = tmplParams.length;
        int numTmplArgs = tmplArgs.length;
        tmplArgs = SemanticUtil.getSimplifiedArguments(tmplArgs);
        ICPPTemplateParameter tmplParam = null;
        int packOffset = -1;
        int i = 0;
        while (i < numTmplArgs) {
            if (packOffset < 0 || tmplParam == null) {
                if (i >= numTmplParams) {
                    return null;
                }
                tmplParam = tmplParams[i];
                if (tmplParam.isParameterPack()) {
                    packOffset = i;
                }
            }
            ICPPTemplateArgument tmplArg = tmplArgs[i];
            if ((tmplArg = CPPTemplates.matchTemplateParameterAndArgument(tmplParam, tmplArg, map)) == null) {
                return null;
            }
            if (packOffset < 0) {
                map.put(tmplParam, tmplArg);
            }
            ++i;
        }
        if (packOffset >= 0) {
            int packSize = tmplArgs.length - packOffset;
            ICPPTemplateArgument[] pack = new ICPPTemplateArgument[packSize];
            System.arraycopy(tmplArgs, packOffset, pack, 0, packSize);
            map.put(tmplParam, pack);
        }
        if (!TemplateArgumentDeduction.deduceFromFunctionArgs(template, fnArgs, argIsLValue, map, false)) {
            return null;
        }
        ArrayList<ICPPTemplateArgument> result = new ArrayList<ICPPTemplateArgument>(numTmplParams);
        ICPPTemplateParameter[] iCPPTemplateParameterArray = tmplParams;
        int n = tmplParams.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                ICPPTemplateArgument[] deducedArgs = map.getPackExpansion(tpar);
                if (deducedArgs == null) {
                    return null;
                }
                result.addAll(Arrays.asList(deducedArgs));
            } else {
                ICPPTemplateArgument deducedArg = map.getArgument(tpar);
                if (deducedArg == null) {
                    return null;
                }
                result.add(deducedArg);
            }
            ++n2;
        }
        return result.toArray(new ICPPTemplateArgument[result.size()]);
    }

    static ICPPTemplateArgument[] deduceForConversion(ICPPFunctionTemplate template, IType conversionType, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        int length = tmplParams.length;
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[length];
        IType a = SemanticUtil.getSimplifiedType(conversionType);
        IType p = template.getType().getReturnType();
        TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplParams, null, map, 0);
        if (!deduct.fromType(p = TemplateArgumentDeduction.getArgumentTypeForDeduction(p, a instanceof ICPPReferenceType), a = SemanticUtil.getNestedType(a, 3))) {
            return null;
        }
        int i = 0;
        while (i < length) {
            if (result[i] == null) {
                ICPPTemplateArgument deducedArg = map.getArgument(tmplParams[i]);
                if (deducedArg == null) {
                    return null;
                }
                result[i] = deducedArg;
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean deduceFromFunctionArgs(ICPPFunctionTemplate template, IType[] fnArgs, BitSet argIsLValue, CPPTemplateParameterMap map, boolean checkExactMatch) {
        try {
            IType[] fnPars = template.getType().getParameterTypes();
            int fnParCount = fnPars.length;
            if (fnParCount == 0) {
                return true;
            }
            ICPPTemplateParameter[] tmplPars = template.getTemplateParameters();
            TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplPars, map, new CPPTemplateParameterMap(fnParCount), 0);
            IType fnParPack = null;
            int j = 0;
            while (j < fnArgs.length) {
                IType par;
                if (fnParPack != null) {
                    par = fnParPack;
                    deduct.incPackOffset();
                } else {
                    if (j >= fnParCount) break;
                    par = fnPars[j];
                    if (par instanceof ICPPParameterPackType) {
                        if (j != fnParCount - 1) {
                            return false;
                        }
                        par = fnParPack = ((ICPPParameterPackType)par).getType();
                        deduct = new TemplateArgumentDeduction(deduct, fnArgs.length - j);
                    }
                }
                par = CPPTemplates.instantiateType(par, map, -1, null);
                if (!CPPTemplates.isValidType(par)) {
                    return false;
                }
                boolean isDependentPar = CPPTemplates.isDependentType(par);
                if (checkExactMatch || isDependentPar) {
                    IType instantiated;
                    IType pcheck;
                    CVQualifier cvArg;
                    CVQualifier cvPar;
                    boolean isReferenceTypeParameter = false;
                    IType arg = fnArgs[j];
                    if ((par = SemanticUtil.getNestedType(par, 1)) instanceof ICPPReferenceType) {
                        isReferenceTypeParameter = true;
                        ICPPReferenceType refPar = (ICPPReferenceType)par;
                        arg = refPar.isRValueReference() && refPar.getType() instanceof ICPPTemplateParameter && argIsLValue.get(j) ? new CPPReferenceType(SemanticUtil.getSimplifiedType(arg), false) : TemplateArgumentDeduction.getArgumentTypeForDeduction(arg, true);
                        par = SemanticUtil.getNestedType(par, 3);
                    } else {
                        arg = TemplateArgumentDeduction.getArgumentTypeForDeduction(arg, false);
                    }
                    if (!checkExactMatch && ((cvPar = SemanticUtil.getCVQualifier(par)) == (cvArg = SemanticUtil.getCVQualifier(arg)) || isReferenceTypeParameter && cvPar.isAtLeastAsQualifiedAs(cvArg)) && !((pcheck = SemanticUtil.getNestedType(par, 4)) instanceof ICPPTemplateParameter)) {
                        ICPPClassType aInst;
                        ICPPTemplateInstance pInst;
                        ICPPClassTemplate pTemplate;
                        par = pcheck;
                        IType argcheck = arg = SemanticUtil.getNestedType(arg, 4);
                        if (par instanceof IPointerType && arg instanceof IPointerType) {
                            pcheck = ((IPointerType)par).getType();
                            argcheck = ((IPointerType)arg).getType();
                            if (pcheck instanceof ICPPTemplateParameter) {
                                pcheck = null;
                            } else {
                                cvPar = SemanticUtil.getCVQualifier(pcheck);
                                if (cvPar.isAtLeastAsQualifiedAs(cvArg = SemanticUtil.getCVQualifier(argcheck))) {
                                    pcheck = SemanticUtil.getNestedType(pcheck, 4);
                                    argcheck = SemanticUtil.getNestedType(argcheck, 4);
                                } else {
                                    pcheck = null;
                                }
                            }
                        }
                        if (pcheck instanceof ICPPTemplateInstance && argcheck instanceof ICPPClassType && (pTemplate = TemplateArgumentDeduction.getPrimaryTemplate(pInst = (ICPPTemplateInstance)((Object)pcheck))) != null && (aInst = TemplateArgumentDeduction.findBaseInstance((ICPPClassType)argcheck, pTemplate, 16)) != null && aInst != argcheck) {
                            par = pcheck;
                            arg = aInst;
                        }
                    }
                    if (isDependentPar && !deduct.fromType(par, arg)) {
                        return false;
                    }
                    if (checkExactMatch && !(instantiated = CPPTemplates.instantiateType(par, deduct.fDeducedArgs, deduct.fPackOffset, null)).isSameType(arg)) {
                        return false;
                    }
                }
                ++j;
            }
            if (!deduct.fExplicitArgs.mergeToExplicit(deduct.fDeducedArgs)) {
                return false;
            }
            return TemplateArgumentDeduction.verifyDeduction(tmplPars, map, true);
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    private static ICPPClassType findBaseInstance(ICPPClassType a, ICPPClassTemplate pTemplate, int maxdepth) throws DOMException {
        ICPPTemplateInstance inst;
        ICPPClassTemplate tmpl;
        if (a instanceof ICPPTemplateInstance && pTemplate.isSameType(tmpl = TemplateArgumentDeduction.getPrimaryTemplate(inst = (ICPPTemplateInstance)((Object)a)))) {
            return a;
        }
        if (maxdepth-- > 0) {
            ICPPBase[] iCPPBaseArray = a.getBases();
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassType inst2;
                ICPPBase cppBase = iCPPBaseArray[n2];
                IBinding base = cppBase.getBaseClass();
                if (base instanceof ICPPClassType && (inst2 = TemplateArgumentDeduction.findBaseInstance((ICPPClassType)base, pTemplate, maxdepth)) != null) {
                    return inst2;
                }
                ++n2;
            }
        }
        return null;
    }

    private static ICPPClassTemplate getPrimaryTemplate(ICPPTemplateInstance inst) throws DOMException {
        ICPPTemplateDefinition template = inst.getTemplateDefinition();
        if (template instanceof ICPPClassTemplatePartialSpecialization) {
            return ((ICPPClassTemplatePartialSpecialization)template).getPrimaryClassTemplate();
        }
        if (template instanceof ICPPClassTemplate) {
            return (ICPPClassTemplate)template;
        }
        return null;
    }

    private static IType getArgumentTypeForDeduction(IType type, boolean parameterIsAReferenceType) {
        if ((type = SemanticUtil.getSimplifiedType(type)) instanceof ICPPReferenceType) {
            type = ((ICPPReferenceType)type).getType();
        }
        IType result = type;
        if (!parameterIsAReferenceType) {
            result = type instanceof IArrayType ? new CPPPointerType(((IArrayType)type).getType()) : (type instanceof IFunctionType ? new CPPPointerType(type) : SemanticUtil.getNestedType(type, 9));
        }
        return result;
    }

    public static boolean fromTemplateArguments(ICPPTemplateParameter[] pars, ICPPTemplateArgument[] p, ICPPTemplateArgument[] a, CPPTemplateParameterMap map) throws DOMException {
        TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(pars, null, map, 0);
        int len = a.length;
        if (p == null || p.length != len) {
            return false;
        }
        int j = 0;
        while (j < len) {
            if (!deduct.fromTemplateArgument(p[j], a[j])) {
                return false;
            }
            ++j;
        }
        return TemplateArgumentDeduction.verifyDeduction(pars, map, false);
    }

    private static boolean verifyDeduction(ICPPTemplateParameter[] pars, CPPTemplateParameterMap tpMap, boolean useDefaults) {
        ICPPTemplateParameter[] iCPPTemplateParameterArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                ICPPTemplateArgument[] deducedArgs = tpMap.getPackExpansion(tpar);
                if (deducedArgs == null) {
                    tpMap.put(tpar, ICPPTemplateArgument.EMPTY_ARGUMENTS);
                } else {
                    ICPPTemplateArgument[] iCPPTemplateArgumentArray = deducedArgs;
                    int n3 = deducedArgs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n4];
                        if (arg == null) {
                            return false;
                        }
                        ++n4;
                    }
                }
            } else {
                ICPPTemplateArgument deducedArg = tpMap.getArgument(tpar);
                if (deducedArg == null && useDefaults && (deducedArg = tpar.getDefaultValue()) != null && (deducedArg = CPPTemplates.instantiateArgument(deducedArg, tpMap, -1, null)) != null) {
                    tpMap.put(tpar, deducedArg);
                }
                if (deducedArg == null) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private TemplateArgumentDeduction(ICPPTemplateParameter[] tpars, CPPTemplateParameterMap explicit, CPPTemplateParameterMap result, int packSize) {
        this.fExplicitArgs = explicit;
        this.fDeducedArgs = result;
        this.fPackSize = packSize;
        this.fPackOffset = packSize > 0 ? 0 : -1;
        ICPPTemplateParameter[] iCPPTemplateParameterArray = tpars;
        int n = tpars.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                if (this.fTemplateParameterPacks == null) {
                    this.fTemplateParameterPacks = new HashSet<Integer>();
                }
                this.fTemplateParameterPacks.add(tpar.getParameterID());
            }
            ++n2;
        }
    }

    private TemplateArgumentDeduction(TemplateArgumentDeduction base, int packSize) {
        this.fExplicitArgs = base.fExplicitArgs;
        this.fDeducedArgs = base.fDeducedArgs;
        this.fTemplateParameterPacks = base.fTemplateParameterPacks;
        this.fPackSize = packSize;
        this.fPackOffset = packSize > 0 ? 0 : -1;
    }

    private void incPackOffset() {
        ++this.fPackOffset;
        assert (this.fPackOffset < this.fPackSize);
    }

    private boolean fromTemplateArgument(ICPPTemplateArgument p, ICPPTemplateArgument a) throws DOMException {
        if (p.isNonTypeValue() != a.isNonTypeValue()) {
            return false;
        }
        if (p.isNonTypeValue()) {
            IValue tval = p.getNonTypeValue();
            int parId = Value.isTemplateParameter(tval);
            if (parId >= 0) {
                ICPPTemplateArgument old = this.fDeducedArgs.getArgument(parId, this.fPackOffset);
                if (old == null) {
                    return this.deduce(parId, a);
                }
                return old.isSameValue(a);
            }
            IValue sval = a.getNonTypeValue();
            return tval.equals(sval);
        }
        return this.fromType(p.getTypeValue(), a.getTypeValue());
    }

    /*
     * Unable to fully structure code
     */
    private boolean fromType(IType p, IType a) throws DOMException {
        ** GOTO lbl70
        {
            a = ((ITypedef)a).getType();
            do {
                if (a instanceof ITypedef) continue block0;
                if (p instanceof IBasicType) {
                    return p.isSameType(a);
                }
                if (p instanceof ICPPPointerToMemberType) {
                    if (!(a instanceof ICPPPointerToMemberType)) {
                        return false;
                    }
                    if (!this.fromType(((ICPPPointerToMemberType)p).getMemberOfClass(), ((ICPPPointerToMemberType)a).getMemberOfClass())) {
                        return false;
                    }
                    p = ((ICPPPointerToMemberType)p).getType();
                    a = ((ICPPPointerToMemberType)a).getType();
                    continue;
                }
                if (p instanceof IPointerType) {
                    if (!(a instanceof IPointerType)) {
                        return false;
                    }
                    p = ((IPointerType)p).getType();
                    a = ((IPointerType)a).getType();
                    continue;
                }
                if (p instanceof ICPPReferenceType) {
                    if (!(a instanceof ICPPReferenceType)) {
                        return false;
                    }
                    p = ((ICPPReferenceType)p).getType();
                    a = ((ICPPReferenceType)a).getType();
                    continue;
                }
                if (p instanceof IArrayType) {
                    if (!(a instanceof IArrayType)) {
                        return false;
                    }
                    aa = (IArrayType)a;
                    pa = (IArrayType)p;
                    as = aa.getSize();
                    if (as != (ps = pa.getSize())) {
                        if (as == null || ps == null) {
                            return false;
                        }
                        parID = Value.isTemplateParameter(ps);
                        if (parID >= 0 ? ((old = this.fDeducedArgs.getArgument(parID, this.fPackOffset)) == null ? this.deduce(parID, new CPPTemplateArgument(as, new CPPBasicType(IBasicType.Kind.eInt, 0))) == false : as.equals(old.getNonTypeValue()) == false) : as.equals(as) == false) {
                            return false;
                        }
                    }
                    p = pa.getType();
                    a = aa.getType();
                    continue;
                }
                if (p instanceof IQualifierType) {
                    uqp = SemanticUtil.getNestedType(p, 8);
                    uqa = SemanticUtil.getNestedType(a, 8);
                    if (uqp instanceof ICPPTemplateParameter && (remaining = SemanticUtil.getCVQualifier(a).remove(SemanticUtil.getCVQualifier(p))) != CVQualifier._) {
                        uqa = SemanticUtil.addQualifiers(uqa, remaining.isConst(), remaining.isVolatile());
                    }
                    a = uqa;
                    p = uqp;
                    continue;
                }
                if (p instanceof IFunctionType) {
                    if (!(a instanceof IFunctionType)) {
                        return false;
                    }
                    return this.fromFunctionType((IFunctionType)p, (IFunctionType)a);
                }
                if (p instanceof ICPPTemplateParameter) {
                    current = this.fDeducedArgs.getArgument(((ICPPTemplateParameter)p).getParameterID(), this.fPackOffset);
                    if (current != null) {
                        if (current.isNonTypeValue()) {
                            return false;
                        }
                        return current.getTypeValue().isSameType(a);
                    }
                    if (a == null) {
                        return false;
                    }
                    return this.deduce(((ICPPTemplateParameter)p).getParameterID(), new CPPTemplateArgument(a));
                }
                if (p instanceof ICPPTemplateInstance) {
                    if (!(a instanceof ICPPTemplateInstance)) {
                        return false;
                    }
                    return this.fromTemplateInstance((ICPPTemplateInstance)p, (ICPPTemplateInstance)a);
                }
                if (p instanceof ICPPUnknownBinding) {
                    return true;
                }
                return p.isSameType(a);
lbl70:
                // 6 sources

            } while (p != null);
        }
        return false;
    }

    private boolean fromTemplateInstance(ICPPTemplateInstance pInst, ICPPTemplateInstance aInst) throws DOMException {
        int tparId;
        ICPPTemplateArgument current;
        ICPPClassTemplate pTemplate = TemplateArgumentDeduction.getPrimaryTemplate(pInst);
        ICPPClassTemplate aTemplate = TemplateArgumentDeduction.getPrimaryTemplate(aInst);
        if (pTemplate == null || aTemplate == null) {
            return false;
        }
        if (pTemplate instanceof ICPPTemplateTemplateParameter ? ((current = this.fDeducedArgs.getArgument(tparId = ((ICPPTemplateTemplateParameter)pTemplate).getParameterID(), this.fPackOffset)) != null ? current.isNonTypeValue() || !current.getTypeValue().isSameType(aTemplate) : !this.deduce(tparId, new CPPTemplateArgument(aTemplate))) : !aTemplate.isSameType(pTemplate)) {
            return false;
        }
        ICPPTemplateArgument[] pArgs = pInst.getTemplateArguments();
        int i = 0;
        while (i < pArgs.length - 1) {
            if (pArgs[i].isPackExpansion()) {
                return true;
            }
            ++i;
        }
        ICPPTemplateArgument[] aArgs = aInst.getTemplateArguments();
        if (pArgs.length != aArgs.length) {
            if (pArgs.length == 0 || pArgs.length > aArgs.length + 1) {
                return false;
            }
            ICPPTemplateArgument lastPParam = pArgs[pArgs.length - 1];
            if (!lastPParam.isPackExpansion()) {
                return false;
            }
        }
        ICPPTemplateArgument expansionPattern = null;
        TemplateArgumentDeduction deduct = this;
        int i2 = 0;
        while (i2 < aArgs.length) {
            ICPPTemplateArgument p;
            if (expansionPattern != null) {
                p = expansionPattern;
                deduct.incPackOffset();
                p = CPPTemplates.instantiateArgument(p, this.fExplicitArgs, deduct.fPackOffset, null);
                if (!CPPTemplates.isValidArgument(p)) {
                    return false;
                }
            } else {
                p = pArgs[i2];
                if (p.isPackExpansion()) {
                    p = expansionPattern = p.getExpansionPattern();
                    deduct = new TemplateArgumentDeduction(this, aArgs.length - i2);
                    if (!CPPTemplates.isValidArgument(p = CPPTemplates.instantiateArgument(p, this.fExplicitArgs, deduct.fPackOffset, null))) {
                        return false;
                    }
                }
            }
            if (!deduct.fromTemplateArgument(p, aArgs[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean fromFunctionType(IFunctionType ftp, IFunctionType fta) throws DOMException {
        IType[] aParams;
        if (!this.fromType(ftp.getReturnType(), fta.getReturnType())) {
            return false;
        }
        IType[] pParams = ftp.getParameterTypes();
        if (pParams.length != (aParams = fta.getParameterTypes()).length) {
            if (pParams.length == 0 || pParams.length > aParams.length + 1) {
                return false;
            }
            IType lastPParam = pParams[pParams.length - 1];
            if (!(lastPParam instanceof ICPPParameterPackType)) {
                return false;
            }
        }
        IType parameterPack = null;
        TemplateArgumentDeduction deduct = this;
        int i = 0;
        while (i < aParams.length) {
            IType p;
            if (parameterPack != null) {
                p = parameterPack;
                deduct.incPackOffset();
                p = CPPTemplates.instantiateType(p, this.fExplicitArgs, deduct.fPackOffset, null);
                if (!CPPTemplates.isValidType(p)) {
                    return false;
                }
            } else {
                p = pParams[i];
                if (p instanceof ICPPParameterPackType) {
                    p = parameterPack = ((ICPPParameterPackType)p).getType();
                    deduct = new TemplateArgumentDeduction(this, aParams.length - i);
                    if (!CPPTemplates.isValidType(p = CPPTemplates.instantiateType(p, this.fExplicitArgs, deduct.fPackOffset, null))) {
                        return false;
                    }
                }
            }
            if (!deduct.fromType(p, aParams[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean deduce(int parID, ICPPTemplateArgument arg) {
        if (this.fTemplateParameterPacks != null && this.fTemplateParameterPacks.contains(parID)) {
            if (this.fPackSize == 0) {
                return false;
            }
            return this.fDeducedArgs.putPackElement(parID, this.fPackOffset, arg, this.fPackSize);
        }
        this.fDeducedArgs.put(parID, arg);
        return true;
    }
}

