/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypedefNameSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CEnumeration;
import org.eclipse.core.runtime.CoreException;

public class CQualifierType
implements ICQualifierType,
ITypeContainer,
ISerializableType {
    private boolean isConst;
    private boolean isVolatile;
    private boolean isRestrict;
    private IType type = null;

    public CQualifierType(ICASTDeclSpecifier declSpec) {
        this.type = this.resolveType(declSpec);
        this.isConst = declSpec.isConst();
        this.isVolatile = declSpec.isVolatile();
        this.isRestrict = declSpec.isRestrict();
    }

    public CQualifierType(IType type, boolean isConst, boolean isVolatile, boolean isRestrict) {
        this.type = type;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
        this.isRestrict = isRestrict;
    }

    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return obj.isSameType(this);
        }
        if (obj instanceof ICQualifierType) {
            ICQualifierType qt = (ICQualifierType)obj;
            if (this.isConst() != qt.isConst()) {
                return false;
            }
            if (this.isRestrict() != qt.isRestrict()) {
                return false;
            }
            if (this.isVolatile() != qt.isVolatile()) {
                return false;
            }
            if (this.type == null) {
                return false;
            }
            return this.type.isSameType(qt.getType());
        }
        return false;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    private IType resolveType(ICASTDeclSpecifier declSpec) {
        IType t = null;
        if (declSpec instanceof ICASTTypedefNameSpecifier) {
            ICASTTypedefNameSpecifier nameSpec = (ICASTTypedefNameSpecifier)declSpec;
            t = (IType)((Object)nameSpec.getName().resolveBinding());
        } else if (declSpec instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elabTypeSpec = (IASTElaboratedTypeSpecifier)((Object)declSpec);
            t = (IType)((Object)elabTypeSpec.getName().resolveBinding());
        } else if (declSpec instanceof IASTCompositeTypeSpecifier) {
            IASTCompositeTypeSpecifier compTypeSpec = (IASTCompositeTypeSpecifier)((Object)declSpec);
            t = (IType)((Object)compTypeSpec.getName().resolveBinding());
        } else {
            t = declSpec instanceof IASTEnumerationSpecifier ? new CEnumeration(((IASTEnumerationSpecifier)((Object)declSpec)).getName()) : new CBasicType((ICASTSimpleDeclSpecifier)declSpec);
        }
        return t;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType t) {
        this.type = t;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int firstByte = 4;
        if (this.isConst()) {
            firstByte |= 0x10;
        }
        if (this.isVolatile()) {
            firstByte |= 0x20;
        }
        if (this.isRestrict()) {
            firstByte |= 0x40;
        }
        buffer.putByte((byte)firstByte);
        buffer.marshalType(this.getType());
    }

    public static IType unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        IType nested = buffer.unmarshalType();
        return new CQualifierType(nested, (firstByte & 0x10) != 0, (firstByte & 0x20) != 0, (firstByte & 0x40) != 0);
    }
}

