/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class CPPASTInitializerList
extends ASTNode
implements ICPPASTInitializerList {
    private IASTInitializer[] initializers = null;
    private int initializersPos = -1;
    private int actualLength;
    private boolean fIsPackExpansion;

    public CPPASTInitializerList copy() {
        CPPASTInitializerList copy = new CPPASTInitializerList();
        IASTInitializer[] iASTInitializerArray = this.getInitializers();
        int n = iASTInitializerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializer initializer = iASTInitializerArray[n2];
            copy.addInitializer(initializer == null ? null : initializer.copy());
            ++n2;
        }
        copy.setOffsetAndLength(this);
        copy.actualLength = this.getSize();
        copy.fIsPackExpansion = this.fIsPackExpansion;
        return copy;
    }

    public int getSize() {
        return this.actualLength;
    }

    public IASTInitializer[] getInitializers() {
        if (this.initializers == null) {
            return IASTInitializer.EMPTY_INITIALIZER_ARRAY;
        }
        this.initializers = ArrayUtil.trimAt(IASTInitializer.class, this.initializers, this.initializersPos);
        return this.initializers;
    }

    public void addInitializer(IASTInitializer d) {
        this.assertNotFrozen();
        if (d != null) {
            this.initializers = (IASTInitializer[])ArrayUtil.append(IASTInitializer.class, this.initializers, ++this.initializersPos, d);
            d.setParent(this);
            d.setPropertyInParent(NESTED_INITIALIZER);
        }
        ++this.actualLength;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitInitializers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTInitializer[] list = this.getInitializers();
        int i = 0;
        while (i < list.length) {
            if (!list[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitInitializers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public boolean isPackExpansion() {
        return this.fIsPackExpansion;
    }

    public void setIsPackExpansion(boolean val) {
        this.assertNotFrozen();
        this.fIsPackExpansion = val;
    }
}

