/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;

public class CPPASTSimpleTypeConstructorExpression
extends ASTNode
implements ICPPASTSimpleTypeConstructorExpression,
IASTAmbiguityParent {
    private int st;
    private IASTExpression init;

    public CPPASTSimpleTypeConstructorExpression() {
    }

    public CPPASTSimpleTypeConstructorExpression(int st, IASTExpression init) {
        this.st = st;
        this.setInitialValue(init);
    }

    public CPPASTSimpleTypeConstructorExpression copy() {
        CPPASTSimpleTypeConstructorExpression copy = new CPPASTSimpleTypeConstructorExpression();
        copy.st = this.st;
        copy.setInitialValue(this.init == null ? null : this.init.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public int getSimpleType() {
        return this.st;
    }

    public void setSimpleType(int value) {
        this.assertNotFrozen();
        this.st = value;
    }

    public IASTExpression getInitialValue() {
        return this.init;
    }

    public void setInitialValue(IASTExpression expression) {
        this.assertNotFrozen();
        this.init = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(INITIALIZER_VALUE);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.init != null && !this.init.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.init) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.init = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        return new CPPBasicType(CPPBasicType.getKind(this.st), 0);
    }

    public boolean isLValue() {
        return false;
    }
}

