/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTUnaryExpression
extends ASTNode
implements ICPPASTUnaryExpression,
IASTAmbiguityParent {
    private int op;
    private IASTExpression operand;
    private ICPPFunction overload = UNINITIALIZED_FUNCTION;
    private IASTImplicitName[] implicitNames = null;

    public CPPASTUnaryExpression() {
    }

    public CPPASTUnaryExpression(int operator, IASTExpression operand) {
        this.op = operator;
        this.setOperand(operand);
    }

    public CPPASTUnaryExpression copy() {
        CPPASTUnaryExpression copy = new CPPASTUnaryExpression(this.op, this.operand == null ? null : this.operand.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public int getOperator() {
        return this.op;
    }

    public void setOperator(int operator) {
        this.assertNotFrozen();
        this.op = operator;
    }

    public IASTExpression getOperand() {
        return this.operand;
    }

    public void setOperand(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND);
        }
    }

    public boolean isPostfixOperator() {
        return this.op == 10 || this.op == 9;
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction overload = this.getOverload();
            if (overload == null) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            CPPASTImplicitName operatorName = new CPPASTImplicitName(overload.getNameCharArray(), (IASTNode)this);
            operatorName.setOperator(true);
            operatorName.setBinding(overload);
            operatorName.computeOperatorOffsets(this.operand, this.isPostfixOperator());
            this.implicitNames = new IASTImplicitName[]{operatorName};
        }
        return this.implicitNames;
    }

    public boolean accept(ASTVisitor action) {
        IASTImplicitName name;
        int n;
        int n2;
        IASTImplicitName[] iASTImplicitNameArray;
        boolean isPostfix;
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!(isPostfix = this.isPostfixOperator()) && action.shouldVisitImplicitNames) {
            iASTImplicitNameArray = this.getImplicitNames();
            n2 = iASTImplicitNameArray.length;
            n = 0;
            while (n < n2) {
                name = iASTImplicitNameArray[n];
                if (!name.accept(action)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.operand != null && !this.operand.accept(action)) {
            return false;
        }
        if (isPostfix && action.shouldVisitImplicitNames) {
            iASTImplicitNameArray = this.getImplicitNames();
            n2 = iASTImplicitNameArray.length;
            n = 0;
            while (n < n2) {
                name = iASTImplicitNameArray[n];
                if (!name.accept(action)) {
                    return false;
                }
                ++n;
            }
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand = (IASTExpression)other;
        }
    }

    public ICPPFunction getOverload() {
        if (this.overload != UNINITIALIZED_FUNCTION) {
            return this.overload;
        }
        this.overload = CPPSemantics.findOverloadedOperator(this);
        if (this.overload != null && this.op == 5 && this.computePointerToMemberType() instanceof CPPPointerToMemberType) {
            this.overload = null;
        }
        return this.overload;
    }

    private IType computePointerToMemberType() {
        IASTName name;
        IBinding b;
        IASTExpression child = this.operand;
        boolean inParenthesis = false;
        while (child instanceof IASTUnaryExpression && ((IASTUnaryExpression)child).getOperator() == 11) {
            child = ((IASTUnaryExpression)child).getOperand();
            inParenthesis = true;
        }
        if (child instanceof IASTIdExpression && (b = (name = ((IASTIdExpression)child).getName()).resolveBinding()) instanceof ICPPMember) {
            ICPPMember member = (ICPPMember)b;
            try {
                if (name instanceof ICPPASTQualifiedName && !member.isStatic()) {
                    if (!inParenthesis) {
                        return new CPPPointerToMemberType(member.getType(), member.getClassOwner(), false, false);
                    }
                    if (member instanceof IFunction) {
                        return new ProblemBinding(this.operand, 5, this.operand.getRawSignature().toCharArray());
                    }
                }
            }
            catch (DOMException e) {
                return e.getProblem();
            }
        }
        return null;
    }

    public IType getExpressionType() {
        int op = this.getOperator();
        switch (op) {
            case 8: 
            case 16: {
                return CPPVisitor.get_SIZE_T(this);
            }
            case 13: {
                return CPPVisitor.get_type_info(this);
            }
        }
        IASTExpression operand = this.getOperand();
        if (op == 5) {
            IType ptm = this.computePointerToMemberType();
            if (ptm != null) {
                return ptm;
            }
            IType operator = this.findOperatorReturnType();
            if (operator != null) {
                return operator;
            }
            IType type = operand.getExpressionType();
            type = SemanticUtil.getNestedType(type, 3);
            return new CPPPointerType(type);
        }
        if (op == 4) {
            IType type = operand.getExpressionType();
            if ((type = SemanticUtil.getNestedType(type, 7)) instanceof IProblemBinding) {
                return type;
            }
            IType operator = this.findOperatorReturnType();
            if (operator != null) {
                return operator;
            }
            if (type instanceof IPointerType || type instanceof IArrayType) {
                return ((ITypeContainer)type).getType();
            }
            if (type instanceof ICPPUnknownType) {
                return CPPUnknownClass.createUnnamedInstance();
            }
            return new ProblemBinding(this, 5, this.getRawSignature().toCharArray());
        }
        IType origType = operand.getExpressionType();
        IType type = SemanticUtil.getUltimateTypeUptoPointers(origType);
        IType operator = this.findOperatorReturnType();
        if (operator != null) {
            return operator;
        }
        switch (op) {
            case 7: {
                return new CPPBasicType(IBasicType.Kind.eBoolean, 0);
            }
            case 2: 
            case 3: 
            case 6: {
                IType t = CPPArithmeticConversion.promoteCppType(type);
                if (t == null) break;
                return t;
            }
        }
        if (origType instanceof CPPBasicType) {
            ((CPPBasicType)origType).setFromExpression(this);
        }
        return origType;
    }

    public boolean isLValue() {
        ICPPFunction op = this.getOverload();
        if (op != null) {
            try {
                return CPPVisitor.isLValueReference(op.getType().getReturnType());
            }
            catch (DOMException dOMException) {}
        }
        switch (this.getOperator()) {
            case 11: {
                return this.getOperand().isLValue();
            }
            case 0: 
            case 1: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private IType findOperatorReturnType() {
        ICPPFunction operatorFunction = this.getOverload();
        if (operatorFunction != null) {
            try {
                return operatorFunction.getType().getReturnType();
            }
            catch (DOMException e) {
                return e.getProblem();
            }
        }
        return null;
    }
}

