/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPFunctionTemplate
extends CPPTemplateDefinition
implements ICPPFunctionTemplate,
ICPPInternalFunction {
    protected ICPPFunctionType type = null;

    public CPPFunctionTemplate(IASTName name) {
        super(name);
    }

    public void addDefinition(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTDeclarator fdecl = this.getDeclaratorByName(node);
        if (fdecl instanceof ICPPASTFunctionDeclarator) {
            this.updateFunctionParameterBindings((ICPPASTFunctionDeclarator)fdecl);
            super.addDefinition(node);
        }
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTDeclarator fdecl = this.getDeclaratorByName(node);
        if (fdecl == null) {
            return;
        }
        if (fdecl instanceof ICPPASTFunctionDeclarator) {
            this.updateFunctionParameterBindings((ICPPASTFunctionDeclarator)fdecl);
        }
        super.addDeclaration(node);
    }

    private ICPPASTFunctionDeclarator getFirstFunctionDtor() {
        IASTDeclarator dtor = this.getDeclaratorByName(this.getDefinition());
        if (dtor instanceof ICPPASTFunctionDeclarator) {
            return (ICPPASTFunctionDeclarator)dtor;
        }
        IASTNode[] decls = this.getDeclarations();
        if (decls != null) {
            IASTNode[] iASTNodeArray = decls;
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode decl = iASTNodeArray[n2];
                dtor = this.getDeclaratorByName(decl);
                if (dtor instanceof ICPPASTFunctionDeclarator) {
                    return (ICPPASTFunctionDeclarator)dtor;
                }
                ++n2;
            }
        }
        return null;
    }

    public ICPPParameter[] getParameters() {
        ICPPASTFunctionDeclarator fdecl = this.getFirstFunctionDtor();
        if (fdecl != null) {
            ICPPASTParameterDeclaration[] params = fdecl.getParameters();
            int size = params.length;
            ICPPParameter[] result = new ICPPParameter[size];
            if (size > 0) {
                int i = 0;
                while (i < size) {
                    ICPPASTParameterDeclaration p = params[i];
                    IASTName pname = ASTQueries.findInnermostDeclarator(p.getDeclarator()).getName();
                    IBinding binding = pname.resolveBinding();
                    result[i] = binding instanceof ICPPParameter ? (ICPPParameter)binding : new CPPParameter.CPPParameterProblem(p, 5, pname.toCharArray());
                    ++i;
                }
            }
            return result;
        }
        return CPPBuiltinParameter.createParameterList(this.getType());
    }

    public int getRequiredArgumentCount() throws DOMException {
        return CPPFunction.getRequiredArgumentCount(this.getParameters());
    }

    public boolean hasParameterPack() {
        ICPPParameter[] pars = this.getParameters();
        return pars.length > 0 && pars[pars.length - 1].isParameterPack();
    }

    public IScope getFunctionScope() {
        return null;
    }

    public ICPPFunctionType getType() {
        if (this.type == null) {
            IASTName name = this.getTemplateName();
            IASTNode parent = name.getParent();
            while (parent.getParent() instanceof IASTDeclarator) {
                parent = parent.getParent();
            }
            IType temp = SemanticUtil.getNestedType(CPPVisitor.createType((IASTDeclarator)parent), 1);
            if (temp instanceof ICPPFunctionType) {
                this.type = (ICPPFunctionType)temp;
            }
        }
        return this.type;
    }

    public boolean hasStorageClass(int storage) {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        int i = -1;
        do {
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || declSpec.getStorageClass() != storage) continue;
            return true;
        } while (ns != null && ++i < ns.length && (name = (IASTName)ns[i]) != null);
        return false;
    }

    public IBinding resolveParameter(CPPParameter param) {
        int pos = param.getParameterPosition();
        IASTNode[] decls = this.getDeclarations();
        int tdeclLen = decls == null ? 0 : decls.length;
        int i = -1;
        while (i < tdeclLen) {
            block4: {
                ICPPASTParameterDeclaration[] params;
                IASTDeclarator tdecl;
                block3: {
                    block2: {
                        if (i != -1) break block2;
                        tdecl = this.getDeclaratorByName(this.getDefinition());
                        if (tdecl != null) break block3;
                        break block4;
                    }
                    if (decls == null || (tdecl = this.getDeclaratorByName(decls[i])) == null) break;
                }
                if (tdecl instanceof ICPPASTFunctionDeclarator && pos < (params = ((ICPPASTFunctionDeclarator)tdecl).getParameters()).length) {
                    IASTName oName = this.getParamName(params[pos]);
                    return oName.resolvePreBinding();
                }
            }
            ++i;
        }
        return param;
    }

    protected void updateFunctionParameterBindings(ICPPASTFunctionDeclarator fdtor) {
        ICPPASTParameterDeclaration[] updateParams = fdtor.getParameters();
        int k = 0;
        IASTNode[] decls = this.getDeclarations();
        int tdeclLen = decls == null ? 0 : decls.length;
        int i = -1;
        while (i < tdeclLen && k < updateParams.length) {
            block5: {
                IASTDeclarator tdecl;
                block4: {
                    block3: {
                        if (i != -1) break block3;
                        tdecl = this.getDeclaratorByName(this.getDefinition());
                        if (tdecl != null) break block4;
                        break block5;
                    }
                    if (decls == null || (tdecl = this.getDeclaratorByName(decls[i])) == null) break;
                }
                if (tdecl instanceof ICPPASTFunctionDeclarator) {
                    ICPPASTParameterDeclaration[] params = ((ICPPASTFunctionDeclarator)tdecl).getParameters();
                    int end = Math.min(params.length, updateParams.length);
                    while (k < end) {
                        IASTName oName = this.getParamName(params[k]);
                        IBinding b = oName.resolvePreBinding();
                        IASTName n = this.getParamName(updateParams[k]);
                        n.setBinding(b);
                        ASTInternal.addDeclaration(b, n);
                        ++k;
                    }
                }
            }
            ++i;
        }
    }

    private IASTName getParamName(IASTParameterDeclaration paramDecl) {
        return ASTQueries.findInnermostDeclarator(paramDecl.getDeclarator()).getName();
    }

    public boolean isStatic() {
        return this.hasStorageClass(3);
    }

    public boolean isMutable() {
        return this.hasStorageClass(6);
    }

    public boolean isInline() throws DOMException {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        int i = -1;
        do {
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || !declSpec.isInline()) continue;
            return true;
        } while (ns != null && ++i < ns.length && (name = (IASTName)ns[i]) != null);
        return false;
    }

    public boolean isExternC() throws DOMException {
        if (CPPVisitor.isExternC(this.getDefinition())) {
            return true;
        }
        IASTNode[] ds = this.getDeclarations();
        if (ds != null) {
            IASTNode[] iASTNodeArray = ds;
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode element = iASTNodeArray[n2];
                if (CPPVisitor.isExternC(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public boolean takesVarArgs() {
        ICPPASTFunctionDeclarator fdecl = this.getFirstFunctionDtor();
        if (fdecl != null) {
            return fdecl.takesVarArgs();
        }
        return false;
    }

    private IASTDeclarator getDeclaratorByName(IASTNode node) {
        while (node != null) {
            if (!((node = node.getParent()) instanceof IASTDeclarator)) continue;
            return ASTQueries.findTypeRelevantDeclarator((IASTDeclarator)node);
        }
        return null;
    }

    public boolean isStatic(boolean resolveAll) {
        return this.hasStorageClass(3);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        ICPPFunctionType t = this.getType();
        result.append(t != null ? ASTTypeUtil.getParameterTypeString(t) : "()");
        return result.toString();
    }

    public IType[] getExceptionSpecification() throws DOMException {
        ICPPASTFunctionDeclarator declarator = this.getFirstFunctionDtor();
        if (declarator != null) {
            IASTTypeId[] astTypeIds = declarator.getExceptionSpecification();
            if (astTypeIds.equals(ICPPASTFunctionDeclarator.NO_EXCEPTION_SPECIFICATION)) {
                return null;
            }
            if (astTypeIds.equals(IASTTypeId.EMPTY_TYPEID_ARRAY)) {
                return IType.EMPTY_TYPE_ARRAY;
            }
            IType[] typeIds = new IType[astTypeIds.length];
            int i = 0;
            while (i < astTypeIds.length) {
                typeIds[i] = CPPVisitor.createType(astTypeIds[i]);
                ++i;
            }
            return typeIds;
        }
        return null;
    }

    public static final class CPPFunctionTemplateProblem
    extends ProblemBinding
    implements ICPPFunctionTemplate {
        public CPPFunctionTemplateProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public ICPPTemplateParameter[] getTemplateParameters() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPClassTemplatePartialSpecialization[] getTemplateSpecializations() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isMutable() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isInline() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExternC() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPParameter[] getParameters() throws DOMException {
            throw new DOMException(this);
        }

        public IScope getFunctionScope() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPFunctionType getType() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExtern() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isAuto() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isRegister() throws DOMException {
            throw new DOMException(this);
        }

        public boolean takesVarArgs() throws DOMException {
            throw new DOMException(this);
        }

        public IType[] getExceptionSpecification() throws DOMException {
            throw new DOMException(this);
        }

        public int getRequiredArgumentCount() throws DOMException {
            throw new DOMException(this);
        }

        public boolean hasParameterPack() {
            return false;
        }
    }
}

