/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.BitSet;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.ArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionCost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class Conversions {
    private static final BitSet RVBITSET = new BitSet();
    private static final BitSet LVBITSET = new BitSet();

    static {
        LVBITSET.set(0, true);
    }

    public static Cost checkImplicitConversionSequence(IType target, IType exprType, boolean exprIsLValue, UDCMode udc, boolean isImpliedObjectType) throws DOMException {
        int depth;
        if (isImpliedObjectType) {
            udc = UDCMode.noUDC;
        }
        target = SemanticUtil.getNestedType(target, 1);
        exprType = SemanticUtil.getNestedType(exprType, 3);
        if (target instanceof ICPPReferenceType) {
            Cost cost;
            boolean ok;
            boolean isLValueRef = !((ICPPReferenceType)target).isRValueReference();
            IType cv1T1 = SemanticUtil.getNestedType(target, 3);
            IType T1 = SemanticUtil.getNestedType(cv1T1, 11);
            IType cv2T2 = exprType;
            IType T2 = SemanticUtil.getNestedType(cv2T2, 11);
            boolean isImplicitWithoutRefQualifier = isImpliedObjectType;
            Cost.ReferenceBinding refBindingType = Cost.ReferenceBinding.OTHER;
            if (!isImplicitWithoutRefQualifier) {
                if (isLValueRef) {
                    refBindingType = Cost.ReferenceBinding.LVALUE_REF;
                } else if (exprIsLValue) {
                    refBindingType = Cost.ReferenceBinding.RVALUE_REF_BINDS_RVALUE;
                }
            }
            if (isLValueRef) {
                Cost cost2;
                if (exprIsLValue && (cost2 = Conversions.isReferenceCompatible(cv1T1, cv2T2, isImpliedObjectType)) != null) {
                    if (cost2.getInheritanceDistance() > 0) {
                        cost2.setRank(Cost.Rank.CONVERSION);
                    }
                    cost2.setReferenceBinding(refBindingType);
                    return cost2;
                }
                if (T2 instanceof ICPPClassType && udc != UDCMode.noUDC && Conversions.isReferenceRelated(T1, T2) < 0 && (cost2 = Conversions.conversionFuncForDirectReference(cv1T1, cv2T2, T2, true)) != null) {
                    cost2.setReferenceBinding(refBindingType);
                    return cost2;
                }
            }
            if (isLValueRef) {
                ok = SemanticUtil.getCVQualifier(cv1T1) == CVQualifier.c;
            } else {
                boolean bl = ok = !exprIsLValue;
            }
            if (!ok) {
                return new Cost(exprType, cv1T1, Cost.Rank.NO_MATCH);
            }
            if (T1 instanceof ICPPClassType && T2 instanceof ICPPClassType) {
                if (!exprIsLValue && (cost = Conversions.isReferenceCompatible(cv1T1, cv2T2, isImpliedObjectType)) != null) {
                    if (cost.getInheritanceDistance() > 0) {
                        cost.setRank(Cost.Rank.CONVERSION);
                    }
                    cost.setReferenceBinding(refBindingType);
                    return cost;
                }
                if (udc != UDCMode.noUDC && Conversions.isReferenceRelated(T1, T2) < 0 && (cost = Conversions.conversionFuncForDirectReference(cv1T1, cv2T2, T2, false)) != null) {
                    cost.setReferenceBinding(refBindingType);
                    return cost;
                }
            }
            if (!exprIsLValue && T2 instanceof IArrayType && (cost = Conversions.isReferenceCompatible(cv1T1, cv2T2, isImpliedObjectType)) != null) {
                cost.setReferenceBinding(refBindingType);
                return cost;
            }
            if (!(isImpliedObjectType || Conversions.isReferenceRelated(T1, T2) >= 0 && Conversions.compareQualifications(cv1T1, cv2T2) < 0)) {
                cost = Conversions.nonReferenceConversion(exprIsLValue, cv2T2, T1, udc, false);
                if (!isImplicitWithoutRefQualifier) {
                    cost.setReferenceBinding(isLValueRef ? Cost.ReferenceBinding.LVALUE_REF : Cost.ReferenceBinding.RVALUE_REF_BINDS_RVALUE);
                }
                return cost;
            }
            return new Cost(exprType, cv1T1, Cost.Rank.NO_MATCH);
        }
        IType uqsource = SemanticUtil.getNestedType(exprType, 11);
        IType uqtarget = SemanticUtil.getNestedType(target, 11);
        if (uqsource instanceof ICPPClassType && uqtarget instanceof ICPPClassType && (depth = SemanticUtil.calculateInheritanceDepth(uqsource, uqtarget)) > -1) {
            if (depth == 0) {
                return new Cost(uqsource, uqtarget, Cost.Rank.IDENTITY);
            }
            Cost cost = new Cost(uqsource, uqtarget, Cost.Rank.CONVERSION);
            cost.setInheritanceDistance(depth);
            return cost;
        }
        return Conversions.nonReferenceConversion(exprIsLValue, exprType, uqtarget, udc, isImpliedObjectType);
    }

    private static Cost conversionFuncForDirectReference(IType cv1T1, IType cv2T2, IType T2, boolean forLValue) throws DOMException {
        ICPPMethod[] fcns = SemanticUtil.getConversionOperators((ICPPClassType)T2);
        Cost operatorCost = null;
        FunctionCost bestUdcCost = null;
        boolean ambiguousConversionOperator = false;
        if (fcns.length > 0 && !(fcns[0] instanceof IProblemBinding)) {
            ICPPMethod[] iCPPMethodArray = fcns;
            int n = fcns.length;
            int n2 = 0;
            while (n2 < n) {
                Cost cost;
                FunctionCost udcFuncCost;
                int cmp;
                IType implicitObjectType;
                Cost udcCost;
                ICPPMethod op = iCPPMethodArray[n2];
                ICPPFunctionType ft = op.getType();
                IType convertedType = ft.getReturnType();
                boolean isLValue = CPPVisitor.isLValueReference(convertedType);
                if (isLValue == forLValue && (udcCost = Conversions.isReferenceCompatible(SemanticUtil.getNestedType(implicitObjectType = CPPSemantics.getImplicitType(op, ft.isConst(), ft.isVolatile()), 3), cv2T2, true)) != null && (cmp = (udcFuncCost = new FunctionCost((IFunction)op, udcCost)).compareTo(null, bestUdcCost)) <= 0 && (cost = Conversions.isReferenceCompatible(cv1T1, SemanticUtil.getNestedType(convertedType, 3), false)) != null) {
                    bestUdcCost = udcFuncCost;
                    ambiguousConversionOperator = cmp == 0;
                    operatorCost = cost;
                    operatorCost.setUserDefinedConversion(op);
                }
                ++n2;
            }
        }
        if (operatorCost != null && !ambiguousConversionOperator) {
            return operatorCost;
        }
        return null;
    }

    private static Cost nonReferenceConversion(boolean sourceIsLValue, IType source, IType target, UDCMode udc, boolean isImpliedObject) throws DOMException {
        IType uqSource = SemanticUtil.getNestedType(source, 9);
        Cost cost = Conversions.checkStandardConversionSequence(uqSource, sourceIsLValue, target, isImpliedObject);
        if (cost.getRank() != Cost.Rank.NO_MATCH || udc == UDCMode.noUDC) {
            return cost;
        }
        Cost temp = Conversions.checkUserDefinedConversionSequence(sourceIsLValue, source, target, udc == UDCMode.deferUDC);
        if (temp != null) {
            cost = temp;
        }
        return cost;
    }

    private static final int compareQualifications(IType t1, IType t2) throws DOMException {
        CVQualifier cv2;
        CVQualifier cv1 = SemanticUtil.getCVQualifier(t1);
        if (cv1 == (cv2 = SemanticUtil.getCVQualifier(t2))) {
            return 0;
        }
        switch (cv1) {
            case cv: {
                switch (cv2) {
                    case _: {
                        return 3;
                    }
                    case c: {
                        return 2;
                    }
                    case v: {
                        return 1;
                    }
                    case cv: {
                        return 0;
                    }
                }
                break;
            }
            case c: {
                return cv2 == CVQualifier._ ? 1 : -1;
            }
            case v: {
                return cv2 == CVQualifier._ ? 2 : -1;
            }
            case _: {
                return -1;
            }
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int isReferenceRelated(IType cv1Target, IType cv2Source) throws DOMException {
        IType t = SemanticUtil.getNestedType(cv1Target, 3);
        IType s = SemanticUtil.getNestedType(cv2Source, 3);
        if (t instanceof IPointerType) {
            if (!(s instanceof IPointerType)) return -1;
            t = SemanticUtil.getNestedType(((IPointerType)t).getType(), 3);
            s = SemanticUtil.getNestedType(((IPointerType)s).getType(), 3);
        } else if (t instanceof IArrayType) {
            IValue sv;
            if (!(s instanceof IArrayType)) return -1;
            IArrayType at = (IArrayType)t;
            IArrayType st = (IArrayType)s;
            IValue av = at.getSize();
            if (av != (sv = st.getSize()) && (av == null || !av.equals(sv))) return -1;
            t = SemanticUtil.getNestedType(at.getType(), 3);
            s = SemanticUtil.getNestedType(st.getType(), 3);
        } else {
            if (t instanceof IQualifierType) {
                t = SemanticUtil.getNestedType(((IQualifierType)t).getType(), 3);
            }
            if (s instanceof IQualifierType) {
                s = SemanticUtil.getNestedType(((IQualifierType)s).getType(), 3);
            }
            if (t instanceof ICPPClassType && s instanceof ICPPClassType) {
                return SemanticUtil.calculateInheritanceDepth(s, t);
            }
        }
        if (t != s && (t == null || s == null || !t.isSameType(s))) return -1;
        return 0;
    }

    private static final Cost isReferenceCompatible(IType cv1Target, IType cv2Source, boolean isImpliedObject) throws DOMException {
        int inheritanceDist = Conversions.isReferenceRelated(cv1Target, cv2Source);
        if (inheritanceDist < 0) {
            return null;
        }
        int cmp = Conversions.compareQualifications(cv1Target, cv2Source);
        if (cmp < 0) {
            return null;
        }
        if (isImpliedObject) {
            inheritanceDist = 0;
        }
        Cost cost = new Cost(cv2Source, cv1Target, Cost.Rank.IDENTITY);
        cost.setQualificationAdjustment(cmp);
        cost.setInheritanceDistance(inheritanceDist);
        return cost;
    }

    private static final Cost checkStandardConversionSequence(IType source, boolean isLValue, IType target, boolean isImplicitThis) throws DOMException {
        Cost cost = new Cost(source, target, Cost.Rank.IDENTITY);
        if (Conversions.lvalue_to_rvalue(cost, isLValue)) {
            return cost;
        }
        if (Conversions.promotion(cost)) {
            return cost;
        }
        if (Conversions.conversion(cost, isImplicitThis)) {
            return cost;
        }
        if (Conversions.qualificationConversion(cost)) {
            return cost;
        }
        cost.setRank(Cost.Rank.NO_MATCH);
        return cost;
    }

    static final Cost checkUserDefinedConversionSequence(boolean sourceIsLValue, IType source, IType target, boolean deferUDC) throws DOMException {
        IType s;
        block19: {
            Object ft;
            s = SemanticUtil.getNestedType(source, 7);
            IType t = SemanticUtil.getNestedType(target, 7);
            if (!(s instanceof ICPPClassType) && !(t instanceof ICPPClassType)) {
                return null;
            }
            if (deferUDC) {
                Cost c = new Cost(source, target, Cost.Rank.USER_DEFINED_CONVERSION);
                c.setDeferredUDC(true);
                return c;
            }
            if (!(t instanceof ICPPClassType)) break block19;
            FunctionCost cost1 = null;
            Cost cost2 = null;
            IFunction[] ctors = ((ICPPClassType)t).getConstructors();
            CPPTemplates.instantiateFunctionTemplates(ctors, new IType[]{source}, sourceIsLValue ? LVBITSET : RVBITSET, null);
            IFunction[] iFunctionArray = ctors;
            int n = ctors.length;
            int n2 = 0;
            while (n2 < n) {
                block20: {
                    FunctionCost c1;
                    IFunction ctor;
                    block22: {
                        IType[] ptypes;
                        block21: {
                            ctor = iFunctionArray[n2];
                            if (ctor == null || ctor instanceof IProblemBinding || ctor.isExplicit()) break block20;
                            ft = ctor.getType();
                            ptypes = ft.getParameterTypes();
                            if (ptypes.length != 0) break block21;
                            if (!ctor.takesVarArgs()) break block20;
                            c1 = new FunctionCost(ctor, new Cost(source, null, Cost.Rank.ELLIPSIS_CONVERSION));
                            break block22;
                        }
                        IType ptype = SemanticUtil.getNestedType(ptypes[0], 1);
                        if (SemanticUtil.isVoidType(ptype) || ctor.getRequiredArgumentCount() > 1) break block20;
                        c1 = new FunctionCost(ctor, Conversions.checkImplicitConversionSequence(ptype, source, sourceIsLValue, UDCMode.noUDC, false));
                    }
                    int cmp = c1.compareTo(null, cost1);
                    if (cmp <= 0) {
                        cost1 = c1;
                        cost2 = new Cost(t, t, Cost.Rank.IDENTITY);
                        cost2.setUserDefinedConversion((ICPPMethod)ctor);
                        if (cmp == 0) {
                            cost2.setAmbiguousUDC(true);
                        }
                    }
                }
                ++n2;
            }
            if (s instanceof ICPPClassType) {
                IFunction[] ops = SemanticUtil.getConversionOperators((ICPPClassType)s);
                CPPTemplates.instantiateConversionTemplates(ops, target);
                ft = ops;
                int n3 = ops.length;
                n = 0;
                while (n < n3) {
                    FunctionCost c1;
                    int cmp;
                    ICPPFunctionType ft2;
                    IType implicitType;
                    Cost udcCost;
                    IType returnType;
                    IType uqReturnType;
                    int dist;
                    Object op = ft[n];
                    if (op != null && !(op instanceof IProblemBinding) && (dist = SemanticUtil.calculateInheritanceDepth(uqReturnType = SemanticUtil.getNestedType(returnType = op.getType().getReturnType(), 7), t)) >= 0 && (udcCost = Conversions.isReferenceCompatible(SemanticUtil.getNestedType(implicitType = CPPSemantics.getImplicitType((ICPPMethod)op, (ft2 = op.getType()).isConst(), ft2.isVolatile()), 3), source, true)) != null && (cmp = (c1 = new FunctionCost((IFunction)op, udcCost)).compareTo(null, cost1)) <= 0) {
                        cost1 = c1;
                        cost2 = new Cost(t, t, Cost.Rank.IDENTITY);
                        if (dist > 0) {
                            cost2.setInheritanceDistance(dist);
                            cost2.setRank(Cost.Rank.CONVERSION);
                        }
                        cost2.setUserDefinedConversion((ICPPMethod)op);
                        if (cmp == 0) {
                            cost2.setAmbiguousUDC(true);
                        }
                    }
                    ++n;
                }
            }
            if (cost1 == null || cost1.getCost(0).getRank() == Cost.Rank.NO_MATCH) {
                return null;
            }
            return cost2;
        }
        if (s instanceof ICPPClassType) {
            IFunction[] ops = SemanticUtil.getConversionOperators((ICPPClassType)s);
            CPPTemplates.instantiateConversionTemplates(ops, target);
            FunctionCost cost1 = null;
            Cost cost2 = null;
            IFunction[] iFunctionArray = ops;
            int n = ops.length;
            int n4 = 0;
            while (n4 < n) {
                FunctionCost c1;
                int cmp;
                ICPPFunctionType ftype;
                IType implicitType;
                Cost udcCost;
                IType returnType;
                boolean isLValue;
                IType uqReturnType;
                Cost c2;
                IFunction op = iFunctionArray[n4];
                if (op != null && !(op instanceof IProblemBinding) && (c2 = Conversions.checkImplicitConversionSequence(target, uqReturnType, isLValue = (uqReturnType = SemanticUtil.getNestedType(returnType = op.getType().getReturnType(), 9)) instanceof ICPPReferenceType && !((ICPPReferenceType)uqReturnType).isRValueReference(), UDCMode.noUDC, false)).getRank() != Cost.Rank.NO_MATCH && (udcCost = Conversions.isReferenceCompatible(SemanticUtil.getNestedType(implicitType = CPPSemantics.getImplicitType((ICPPMethod)op, (ftype = op.getType()).isConst(), ftype.isVolatile()), 3), source, true)) != null && (cmp = (c1 = new FunctionCost(op, udcCost)).compareTo(null, cost1)) <= 0) {
                    cost1 = c1;
                    cost2 = c2;
                    cost2.setUserDefinedConversion((ICPPMethod)op);
                    if (cmp == 0) {
                        cost2.setAmbiguousUDC(true);
                    }
                }
                ++n4;
            }
            if (cost1 == null || cost1.getCost(0).getRank() == Cost.Rank.NO_MATCH) {
                return null;
            }
            return cost2;
        }
        return null;
    }

    private static final boolean lvalue_to_rvalue(Cost cost, boolean isLValue) throws DOMException {
        IType targetPtrTgt;
        boolean isConverted = false;
        IType target = SemanticUtil.getNestedType(cost.target, 3);
        IType source = SemanticUtil.getNestedType(cost.source, 3);
        if (isLValue && !(source instanceof IFunctionType) && !(source instanceof IArrayType)) {
            IType unqualifiedSrcRValue = SemanticUtil.getNestedType(source, 11);
            if (unqualifiedSrcRValue instanceof ICPPClassType) {
                cost.setRank(Cost.Rank.NO_MATCH);
                return true;
            }
            source = unqualifiedSrcRValue;
            isConverted = true;
        }
        if (!isConverted && source instanceof IArrayType) {
            IASTLiteralExpression lit;
            IASTExpression val;
            IType tmp;
            IType targetPtrTgt2;
            IArrayType arrayType = (IArrayType)source;
            if (target instanceof IPointerType && (!((targetPtrTgt2 = SemanticUtil.getNestedType(((IPointerType)target).getType(), 1)) instanceof IQualifierType) || !((IQualifierType)targetPtrTgt2).isConst()) && (tmp = arrayType.getType()) instanceof IQualifierType && ((IQualifierType)tmp).isConst() && (tmp = ((IQualifierType)tmp).getType()) instanceof CPPBasicType && (val = ((CPPBasicType)tmp).getCreatedFromExpression()) instanceof IASTLiteralExpression && (lit = (IASTLiteralExpression)val).getKind() == 3) {
                source = new CPPPointerType(tmp, false, false);
                cost.setQualificationAdjustment(SemanticUtil.getCVQualifier(targetPtrTgt2).isVolatile() ? 2 : 1);
                isConverted = true;
            }
            if (!isConverted && (target instanceof IPointerType || target instanceof IBasicType)) {
                source = new CPPPointerType(SemanticUtil.getNestedType(arrayType.getType(), 1));
                isConverted = true;
            }
        }
        if (!isConverted && target instanceof IPointerType && (targetPtrTgt = SemanticUtil.getNestedType(((IPointerType)target).getType(), 1)) instanceof IFunctionType && source instanceof IFunctionType) {
            source = new CPPPointerType(source);
            isConverted = true;
        }
        if (source == null || target == null) {
            cost.setRank(Cost.Rank.NO_MATCH);
            return true;
        }
        cost.source = source;
        cost.target = target;
        return source.isSameType(target);
    }

    private static final boolean qualificationConversion(Cost cost) throws DOMException {
        int cmp;
        IType s = cost.source;
        IType t = cost.target;
        boolean constInEveryCV2k = true;
        boolean firstPointer = true;
        int adjustments = 0;
        while (true) {
            s = SemanticUtil.getNestedType(s, 3);
            t = SemanticUtil.getNestedType(t, 3);
            if (!(s instanceof IPointerType) || !(t instanceof IPointerType)) break;
            adjustments <<= 2;
            cmp = Conversions.compareQualifications(t, s);
            if (cmp < 0 || cmp > 0 && !constInEveryCV2k) {
                return false;
            }
            boolean sIsPtrToMember = s instanceof ICPPPointerToMemberType;
            boolean tIsPtrToMember = t instanceof ICPPPointerToMemberType;
            if (sIsPtrToMember != tIsPtrToMember) {
                return false;
            }
            if (sIsPtrToMember) {
                IType sMemberOf = ((ICPPPointerToMemberType)s).getMemberOfClass();
                IType tMemberOf = ((ICPPPointerToMemberType)t).getMemberOfClass();
                if (sMemberOf == null || tMemberOf == null || !sMemberOf.isSameType(tMemberOf)) {
                    return false;
                }
            }
            IPointerType tPtr = (IPointerType)t;
            IPointerType sPtr = (IPointerType)s;
            constInEveryCV2k &= firstPointer || tPtr.isConst();
            s = sPtr.getType();
            t = tPtr.getType();
            firstPointer = false;
            adjustments |= cmp;
        }
        adjustments <<= 2;
        cmp = Conversions.compareQualifications(t, s);
        if (cmp < 0 || cmp > 0 && !constInEveryCV2k) {
            return false;
        }
        s = SemanticUtil.getNestedType(s, 11);
        t = SemanticUtil.getNestedType(t, 11);
        if ((adjustments |= cmp) > 0) {
            cost.setQualificationAdjustment(adjustments);
        }
        return s != null && t != null && s.isSameType(t);
    }

    private static final boolean promotion(Cost cost) throws DOMException {
        boolean canPromote;
        block11: {
            IBasicType.Kind tKind;
            IType trg;
            IType src;
            block12: {
                IBasicType.Kind sKind;
                block13: {
                    src = cost.source;
                    trg = cost.target;
                    canPromote = false;
                    if (!(trg instanceof IBasicType)) break block11;
                    IBasicType basicTgt = (IBasicType)trg;
                    tKind = basicTgt.getKind();
                    if (!(src instanceof IBasicType)) break block12;
                    IBasicType basicSrc = (IBasicType)src;
                    sKind = basicSrc.getKind();
                    if (tKind != IBasicType.Kind.eInt) break block13;
                    switch (sKind) {
                        case eInt: {
                            if (basicSrc.isShort()) {
                                canPromote = true;
                                break;
                            }
                            break block11;
                        }
                        case eUnspecified: 
                        case eChar: 
                        case eWChar: 
                        case eBoolean: {
                            canPromote = true;
                            break;
                        }
                    }
                    break block11;
                }
                if (tKind == IBasicType.Kind.eDouble && sKind == IBasicType.Kind.eFloat) {
                    canPromote = true;
                }
                break block11;
            }
            if (src instanceof IEnumeration && (tKind == IBasicType.Kind.eInt || tKind == IBasicType.Kind.eUnspecified)) {
                if (trg instanceof ICPPBasicType) {
                    int targetModifiers;
                    int qualifiers = ArithmeticConversion.getEnumIntTypeModifiers((IEnumeration)src);
                    if (qualifiers == ((targetModifiers = ((ICPPBasicType)trg).getModifiers()) & 0x4B)) {
                        canPromote = true;
                    }
                } else {
                    canPromote = true;
                }
            }
        }
        if (canPromote) {
            cost.setRank(Cost.Rank.PROMOTION);
            return true;
        }
        return false;
    }

    private static final boolean conversion(Cost cost, boolean forImplicitThis) throws DOMException {
        IType s = cost.source;
        IType t = cost.target;
        if (t instanceof IBasicType) {
            if (s instanceof IBasicType || s instanceof IEnumeration) {
                cost.setRank(Cost.Rank.CONVERSION);
                return true;
            }
            IBasicType.Kind tgtKind = ((IBasicType)t).getKind();
            if (tgtKind == IBasicType.Kind.eBoolean && s instanceof IPointerType) {
                cost.setRank(Cost.Rank.CONVERSION_PTR_BOOL);
                return true;
            }
        }
        if (t instanceof IPointerType) {
            IPointerType tgtPtr = (IPointerType)t;
            if (s instanceof CPPBasicType) {
                Long val;
                IASTExpression exp = ((CPPBasicType)s).getCreatedFromExpression();
                if (exp != null && (val = Value.create(exp, 25).numericalValue()) != null && val == 0L) {
                    cost.setRank(Cost.Rank.CONVERSION);
                    return true;
                }
                return false;
            }
            if (s instanceof IPointerType) {
                IPointerType srcPtr = (IPointerType)s;
                IType tgtPtrTgt = SemanticUtil.getNestedType(tgtPtr.getType(), 7);
                if (SemanticUtil.isVoidType(tgtPtrTgt)) {
                    cost.setRank(Cost.Rank.CONVERSION);
                    cost.setInheritanceDistance(Short.MAX_VALUE);
                    CVQualifier cv = SemanticUtil.getCVQualifier(srcPtr.getType());
                    cost.source = new CPPPointerType(SemanticUtil.addQualifiers(CPPSemantics.VOID_TYPE, cv.isConst(), cv.isVolatile()));
                    return false;
                }
                boolean tIsPtrToMember = t instanceof ICPPPointerToMemberType;
                boolean sIsPtrToMember = s instanceof ICPPPointerToMemberType;
                if (!tIsPtrToMember && !sIsPtrToMember) {
                    IType srcPtrTgt = SemanticUtil.getNestedType(srcPtr.getType(), 7);
                    if (tgtPtrTgt instanceof ICPPClassType && srcPtrTgt instanceof ICPPClassType) {
                        int depth = SemanticUtil.calculateInheritanceDepth(srcPtrTgt, tgtPtrTgt);
                        if (depth == -1) {
                            cost.setRank(Cost.Rank.NO_MATCH);
                            return true;
                        }
                        if (depth > 0) {
                            if (!forImplicitThis) {
                                cost.setRank(Cost.Rank.CONVERSION);
                                cost.setInheritanceDistance(depth);
                            }
                            CVQualifier cv = SemanticUtil.getCVQualifier(srcPtr.getType());
                            cost.source = new CPPPointerType(SemanticUtil.addQualifiers(tgtPtrTgt, cv.isConst(), cv.isVolatile()));
                        }
                        return false;
                    }
                } else if (tIsPtrToMember && sIsPtrToMember) {
                    ICPPPointerToMemberType spm = (ICPPPointerToMemberType)s;
                    ICPPPointerToMemberType tpm = (ICPPPointerToMemberType)t;
                    IType st = spm.getType();
                    IType tt = tpm.getType();
                    if (st != null && tt != null && st.isSameType(tt)) {
                        int depth = SemanticUtil.calculateInheritanceDepth(tpm.getMemberOfClass(), spm.getMemberOfClass());
                        if (depth == -1) {
                            cost.setRank(Cost.Rank.NO_MATCH);
                            return true;
                        }
                        if (depth > 0) {
                            cost.setRank(Cost.Rank.CONVERSION);
                            cost.setInheritanceDistance(depth);
                            cost.source = new CPPPointerToMemberType(spm.getType(), tpm.getMemberOfClass(), spm.isConst(), spm.isVolatile());
                        }
                        return false;
                    }
                }
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UDCMode {
        allowUDC,
        noUDC,
        deferUDC;

    }
}

